/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.entries;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.entries.LootEntryAlternatives;
import net.minecraft.world.level.storage.loot.entries.LootEntryChildren;
import net.minecraft.world.level.storage.loot.entries.LootEntryGroup;
import net.minecraft.world.level.storage.loot.entries.LootEntrySequence;
import net.minecraft.world.level.storage.loot.entries.LootEntryType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionUser;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;

public abstract class LootEntryAbstract
implements LootEntryChildren {
    protected final List<LootItemCondition> conditions;
    private final Predicate<LootTableInfo> compositeCondition;

    protected LootEntryAbstract(List<LootItemCondition> var0) {
        this.conditions = var0;
        this.compositeCondition = LootItemConditions.andConditions(var0);
    }

    protected static <T extends LootEntryAbstract> Products.P1<RecordCodecBuilder.Mu<T>, List<LootItemCondition>> commonFields(RecordCodecBuilder.Instance<T> var02) {
        return var02.group((App)ExtraCodecs.strictOptionalField(LootItemConditions.CODEC.listOf(), "conditions", List.of()).forGetter(var0 -> var0.conditions));
    }

    public void validate(LootCollector var0) {
        for (int var1 = 0; var1 < this.conditions.size(); ++var1) {
            this.conditions.get(var1).validate(var0.forChild(".condition[" + var1 + "]"));
        }
    }

    protected final boolean canRun(LootTableInfo var0) {
        return this.compositeCondition.test(var0);
    }

    public abstract LootEntryType getType();

    public static abstract class a<T extends a<T>>
    implements LootItemConditionUser<T> {
        private final ImmutableList.Builder<LootItemCondition> conditions = ImmutableList.builder();

        protected abstract T getThis();

        @Override
        public T when(LootItemCondition.a var0) {
            this.conditions.add((Object)var0.build());
            return this.getThis();
        }

        @Override
        public final T unwrap() {
            return this.getThis();
        }

        protected List<LootItemCondition> getConditions() {
            return this.conditions.build();
        }

        public LootEntryAlternatives.a otherwise(a<?> var0) {
            return new LootEntryAlternatives.a(this, var0);
        }

        public LootEntryGroup.a append(a<?> var0) {
            return new LootEntryGroup.a(this, var0);
        }

        public LootEntrySequence.a then(a<?> var0) {
            return new LootEntrySequence.a(this, var0);
        }

        public abstract LootEntryAbstract build();

        @Override
        public /* synthetic */ LootItemConditionUser unwrap() {
            return this.unwrap();
        }

        @Override
        public /* synthetic */ LootItemConditionUser when(LootItemCondition.a a2) {
            return this.when(a2);
        }
    }
}

