/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import java.io.File;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.SavedFile;
import org.slf4j.Logger;

public class WorldNBTStorage {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final File playerDir;
    protected final DataFixer fixerUpper;

    public WorldNBTStorage(Convertable.ConversionSession var0, DataFixer var1) {
        this.fixerUpper = var1;
        this.playerDir = var0.getLevelPath(SavedFile.PLAYER_DATA_DIR).toFile();
        this.playerDir.mkdirs();
    }

    public void save(EntityHuman var0) {
        try {
            NBTTagCompound var1 = var0.saveWithoutId(new NBTTagCompound());
            File var2 = File.createTempFile(var0.getStringUUID() + "-", ".dat", this.playerDir);
            NBTCompressedStreamTools.writeCompressed(var1, var2);
            File var3 = new File(this.playerDir, var0.getStringUUID() + ".dat");
            File var4 = new File(this.playerDir, var0.getStringUUID() + ".dat_old");
            SystemUtils.safeReplaceFile(var3, var2, var4);
        }
        catch (Exception var1) {
            LOGGER.warn("Failed to save player data for {}", (Object)var0.getName().getString());
        }
    }

    @Nullable
    public NBTTagCompound load(EntityHuman var0) {
        NBTTagCompound var1 = null;
        try {
            File var2 = new File(this.playerDir, var0.getStringUUID() + ".dat");
            if (var2.exists() && var2.isFile()) {
                var1 = NBTCompressedStreamTools.readCompressed(var2);
            }
        }
        catch (Exception var2) {
            LOGGER.warn("Failed to load player data for {}", (Object)var0.getName().getString());
        }
        if (var1 != null) {
            int var2 = GameProfileSerializer.getDataVersion(var1, -1);
            var0.load(DataFixTypes.PLAYER.updateToCurrentVersion(this.fixerUpper, var1, var2));
        }
        return var1;
    }

    public String[] getSeenPlayers() {
        String[] var0 = this.playerDir.list();
        if (var0 == null) {
            var0 = new String[]{};
        }
        for (int var1 = 0; var1 < var0.length; ++var1) {
            if (!var0[var1].endsWith(".dat")) continue;
            var0[var1] = var0[var1].substring(0, var0[var1].length() - 4);
        }
        return var0;
    }
}

