/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.levelgen.GeneratorSettings;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.storage.IWorldDataServer;
import net.minecraft.world.level.storage.LevelVersion;
import net.minecraft.world.level.storage.SaveData;
import net.minecraft.world.level.timers.CustomFunctionCallbackTimerQueue;
import net.minecraft.world.level.timers.CustomFunctionCallbackTimers;
import org.slf4j.Logger;

public class WorldDataServer
implements IWorldDataServer,
SaveData {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected static final String PLAYER = "Player";
    protected static final String WORLD_GEN_SETTINGS = "WorldGenSettings";
    public WorldSettings settings;
    private final WorldOptions worldOptions;
    private final a specialWorldProperty;
    private final Lifecycle worldGenSettingsLifecycle;
    private int xSpawn;
    private int ySpawn;
    private int zSpawn;
    private float spawnAngle;
    private long gameTime;
    private long dayTime;
    @Nullable
    private final DataFixer fixerUpper;
    private final int playerDataVersion;
    private boolean upgradedPlayerTag;
    @Nullable
    private NBTTagCompound loadedPlayerTag;
    private final int version;
    private int clearWeatherTime;
    private boolean raining;
    private int rainTime;
    private boolean thundering;
    private int thunderTime;
    private boolean initialized;
    private boolean difficultyLocked;
    private WorldBorder.c worldBorder;
    private EnderDragonBattle.a endDragonFightData;
    @Nullable
    private NBTTagCompound customBossEvents;
    private int wanderingTraderSpawnDelay;
    private int wanderingTraderSpawnChance;
    @Nullable
    private UUID wanderingTraderId;
    private final Set<String> knownServerBrands;
    private boolean wasModded;
    private final Set<String> removedFeatureFlags;
    private final CustomFunctionCallbackTimerQueue<MinecraftServer> scheduledEvents;

    private WorldDataServer(@Nullable DataFixer var0, int var1, @Nullable NBTTagCompound var2, boolean var3, int var4, int var5, int var6, float var7, long var8, long var10, int var12, int var13, int var14, boolean var15, int var16, boolean var17, boolean var18, boolean var19, WorldBorder.c var20, int var21, int var22, @Nullable UUID var23, Set<String> var24, Set<String> var25, CustomFunctionCallbackTimerQueue<MinecraftServer> var26, @Nullable NBTTagCompound var27, EnderDragonBattle.a var28, WorldSettings var29, WorldOptions var30, a var31, Lifecycle var32) {
        this.fixerUpper = var0;
        this.wasModded = var3;
        this.xSpawn = var4;
        this.ySpawn = var5;
        this.zSpawn = var6;
        this.spawnAngle = var7;
        this.gameTime = var8;
        this.dayTime = var10;
        this.version = var12;
        this.clearWeatherTime = var13;
        this.rainTime = var14;
        this.raining = var15;
        this.thunderTime = var16;
        this.thundering = var17;
        this.initialized = var18;
        this.difficultyLocked = var19;
        this.worldBorder = var20;
        this.wanderingTraderSpawnDelay = var21;
        this.wanderingTraderSpawnChance = var22;
        this.wanderingTraderId = var23;
        this.knownServerBrands = var24;
        this.removedFeatureFlags = var25;
        this.loadedPlayerTag = var2;
        this.playerDataVersion = var1;
        this.scheduledEvents = var26;
        this.customBossEvents = var27;
        this.endDragonFightData = var28;
        this.settings = var29;
        this.worldOptions = var30;
        this.specialWorldProperty = var31;
        this.worldGenSettingsLifecycle = var32;
    }

    public WorldDataServer(WorldSettings var0, WorldOptions var1, a var2, Lifecycle var3) {
        this(null, SharedConstants.getCurrentVersion().getDataVersion().getVersion(), null, false, 0, 0, 0, 0.0f, 0L, 0L, 19133, 0, 0, false, 0, false, false, false, WorldBorder.DEFAULT_SETTINGS, 0, 0, null, Sets.newLinkedHashSet(), new HashSet<String>(), new CustomFunctionCallbackTimerQueue<MinecraftServer>(CustomFunctionCallbackTimers.SERVER_CALLBACKS), null, EnderDragonBattle.a.DEFAULT, var0.copy(), var1, var2, var3);
    }

    public static <T> WorldDataServer parse(Dynamic<T> var02, DataFixer var1, int var2, @Nullable NBTTagCompound var3, WorldSettings var4, LevelVersion var5, a var6, WorldOptions var7, Lifecycle var8) {
        long var9 = var02.get("Time").asLong(0L);
        return new WorldDataServer(var1, var2, var3, var02.get("WasModded").asBoolean(false), var02.get("SpawnX").asInt(0), var02.get("SpawnY").asInt(0), var02.get("SpawnZ").asInt(0), var02.get("SpawnAngle").asFloat(0.0f), var9, var02.get("DayTime").asLong(var9), var5.levelDataVersion(), var02.get("clearWeatherTime").asInt(0), var02.get("rainTime").asInt(0), var02.get("raining").asBoolean(false), var02.get("thunderTime").asInt(0), var02.get("thundering").asBoolean(false), var02.get("initialized").asBoolean(true), var02.get("DifficultyLocked").asBoolean(false), WorldBorder.c.read(var02, WorldBorder.DEFAULT_SETTINGS), var02.get("WanderingTraderSpawnDelay").asInt(0), var02.get("WanderingTraderSpawnChance").asInt(0), var02.get("WanderingTraderId").read(UUIDUtil.CODEC).result().orElse(null), var02.get("ServerBrands").asStream().flatMap(var0 -> var0.asString().result().stream()).collect(Collectors.toCollection(Sets::newLinkedHashSet)), var02.get("removed_features").asStream().flatMap(var0 -> var0.asString().result().stream()).collect(Collectors.toSet()), new CustomFunctionCallbackTimerQueue<MinecraftServer>(CustomFunctionCallbackTimers.SERVER_CALLBACKS, var02.get("ScheduledEvents").asStream()), (NBTTagCompound)var02.get("CustomBossEvents").orElseEmptyMap().getValue(), var02.get("DragonFight").read(EnderDragonBattle.a.CODEC).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElse(EnderDragonBattle.a.DEFAULT), var4, var7, var6, var8);
    }

    @Override
    public NBTTagCompound createTag(IRegistryCustom var0, @Nullable NBTTagCompound var1) {
        this.updatePlayerTag();
        if (var1 == null) {
            var1 = this.loadedPlayerTag;
        }
        NBTTagCompound var2 = new NBTTagCompound();
        this.setTagData(var0, var2, var1);
        return var2;
    }

    private void setTagData(IRegistryCustom var02, NBTTagCompound var12, @Nullable NBTTagCompound var2) {
        var12.put("ServerBrands", WorldDataServer.stringCollectionToTag(this.knownServerBrands));
        var12.putBoolean("WasModded", this.wasModded);
        if (!this.removedFeatureFlags.isEmpty()) {
            var12.put("removed_features", WorldDataServer.stringCollectionToTag(this.removedFeatureFlags));
        }
        NBTTagCompound var3 = new NBTTagCompound();
        var3.putString("Name", SharedConstants.getCurrentVersion().getName());
        var3.putInt("Id", SharedConstants.getCurrentVersion().getDataVersion().getVersion());
        var3.putBoolean("Snapshot", !SharedConstants.getCurrentVersion().isStable());
        var3.putString("Series", SharedConstants.getCurrentVersion().getDataVersion().getSeries());
        var12.put("Version", var3);
        GameProfileSerializer.addCurrentDataVersion(var12);
        RegistryOps<NBTBase> var4 = RegistryOps.create(DynamicOpsNBT.INSTANCE, var02);
        GeneratorSettings.encode(var4, this.worldOptions, var02).resultOrPartial(SystemUtils.prefix("WorldGenSettings: ", arg_0 -> ((Logger)LOGGER).error(arg_0))).ifPresent(var1 -> var12.put(WORLD_GEN_SETTINGS, (NBTBase)var1));
        var12.putInt("GameType", this.settings.gameType().getId());
        var12.putInt("SpawnX", this.xSpawn);
        var12.putInt("SpawnY", this.ySpawn);
        var12.putInt("SpawnZ", this.zSpawn);
        var12.putFloat("SpawnAngle", this.spawnAngle);
        var12.putLong("Time", this.gameTime);
        var12.putLong("DayTime", this.dayTime);
        var12.putLong("LastPlayed", SystemUtils.getEpochMillis());
        var12.putString("LevelName", this.settings.levelName());
        var12.putInt("version", 19133);
        var12.putInt("clearWeatherTime", this.clearWeatherTime);
        var12.putInt("rainTime", this.rainTime);
        var12.putBoolean("raining", this.raining);
        var12.putInt("thunderTime", this.thunderTime);
        var12.putBoolean("thundering", this.thundering);
        var12.putBoolean("hardcore", this.settings.hardcore());
        var12.putBoolean("allowCommands", this.settings.allowCommands());
        var12.putBoolean("initialized", this.initialized);
        this.worldBorder.write(var12);
        var12.putByte("Difficulty", (byte)this.settings.difficulty().getId());
        var12.putBoolean("DifficultyLocked", this.difficultyLocked);
        var12.put("GameRules", this.settings.gameRules().createTag());
        var12.put("DragonFight", (NBTBase)SystemUtils.getOrThrow(EnderDragonBattle.a.CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)this.endDragonFightData), IllegalStateException::new));
        if (var2 != null) {
            var12.put(PLAYER, var2);
        }
        DataResult var5 = WorldDataConfiguration.CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)this.settings.getDataConfiguration());
        var5.get().ifLeft(var1 -> var12.merge((NBTTagCompound)var1)).ifRight(var0 -> LOGGER.warn("Failed to encode configuration {}", (Object)var0.message()));
        if (this.customBossEvents != null) {
            var12.put("CustomBossEvents", this.customBossEvents);
        }
        var12.put("ScheduledEvents", this.scheduledEvents.store());
        var12.putInt("WanderingTraderSpawnDelay", this.wanderingTraderSpawnDelay);
        var12.putInt("WanderingTraderSpawnChance", this.wanderingTraderSpawnChance);
        if (this.wanderingTraderId != null) {
            var12.putUUID("WanderingTraderId", this.wanderingTraderId);
        }
    }

    private static NBTTagList stringCollectionToTag(Set<String> var0) {
        NBTTagList var1 = new NBTTagList();
        var0.stream().map(NBTTagString::valueOf).forEach(var1::add);
        return var1;
    }

    @Override
    public int getXSpawn() {
        return this.xSpawn;
    }

    @Override
    public int getYSpawn() {
        return this.ySpawn;
    }

    @Override
    public int getZSpawn() {
        return this.zSpawn;
    }

    @Override
    public float getSpawnAngle() {
        return this.spawnAngle;
    }

    @Override
    public long getGameTime() {
        return this.gameTime;
    }

    @Override
    public long getDayTime() {
        return this.dayTime;
    }

    private void updatePlayerTag() {
        if (this.upgradedPlayerTag || this.loadedPlayerTag == null) {
            return;
        }
        if (this.playerDataVersion < SharedConstants.getCurrentVersion().getDataVersion().getVersion()) {
            if (this.fixerUpper == null) {
                throw SystemUtils.pauseInIde(new NullPointerException("Fixer Upper not set inside LevelData, and the player tag is not upgraded."));
            }
            this.loadedPlayerTag = DataFixTypes.PLAYER.updateToCurrentVersion(this.fixerUpper, this.loadedPlayerTag, this.playerDataVersion);
        }
        this.upgradedPlayerTag = true;
    }

    @Override
    public NBTTagCompound getLoadedPlayerTag() {
        this.updatePlayerTag();
        return this.loadedPlayerTag;
    }

    @Override
    public void setXSpawn(int var0) {
        this.xSpawn = var0;
    }

    @Override
    public void setYSpawn(int var0) {
        this.ySpawn = var0;
    }

    @Override
    public void setZSpawn(int var0) {
        this.zSpawn = var0;
    }

    @Override
    public void setSpawnAngle(float var0) {
        this.spawnAngle = var0;
    }

    @Override
    public void setGameTime(long var0) {
        this.gameTime = var0;
    }

    @Override
    public void setDayTime(long var0) {
        this.dayTime = var0;
    }

    @Override
    public void setSpawn(BlockPosition var0, float var1) {
        this.xSpawn = var0.getX();
        this.ySpawn = var0.getY();
        this.zSpawn = var0.getZ();
        this.spawnAngle = var1;
    }

    @Override
    public String getLevelName() {
        return this.settings.levelName();
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public int getClearWeatherTime() {
        return this.clearWeatherTime;
    }

    @Override
    public void setClearWeatherTime(int var0) {
        this.clearWeatherTime = var0;
    }

    @Override
    public boolean isThundering() {
        return this.thundering;
    }

    @Override
    public void setThundering(boolean var0) {
        this.thundering = var0;
    }

    @Override
    public int getThunderTime() {
        return this.thunderTime;
    }

    @Override
    public void setThunderTime(int var0) {
        this.thunderTime = var0;
    }

    @Override
    public boolean isRaining() {
        return this.raining;
    }

    @Override
    public void setRaining(boolean var0) {
        this.raining = var0;
    }

    @Override
    public int getRainTime() {
        return this.rainTime;
    }

    @Override
    public void setRainTime(int var0) {
        this.rainTime = var0;
    }

    @Override
    public EnumGamemode getGameType() {
        return this.settings.gameType();
    }

    @Override
    public void setGameType(EnumGamemode var0) {
        this.settings = this.settings.withGameType(var0);
    }

    @Override
    public boolean isHardcore() {
        return this.settings.hardcore();
    }

    @Override
    public boolean getAllowCommands() {
        return this.settings.allowCommands();
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void setInitialized(boolean var0) {
        this.initialized = var0;
    }

    @Override
    public GameRules getGameRules() {
        return this.settings.gameRules();
    }

    @Override
    public WorldBorder.c getWorldBorder() {
        return this.worldBorder;
    }

    @Override
    public void setWorldBorder(WorldBorder.c var0) {
        this.worldBorder = var0;
    }

    @Override
    public EnumDifficulty getDifficulty() {
        return this.settings.difficulty();
    }

    @Override
    public void setDifficulty(EnumDifficulty var0) {
        this.settings = this.settings.withDifficulty(var0);
    }

    @Override
    public boolean isDifficultyLocked() {
        return this.difficultyLocked;
    }

    @Override
    public void setDifficultyLocked(boolean var0) {
        this.difficultyLocked = var0;
    }

    @Override
    public CustomFunctionCallbackTimerQueue<MinecraftServer> getScheduledEvents() {
        return this.scheduledEvents;
    }

    @Override
    public void fillCrashReportCategory(CrashReportSystemDetails var0, LevelHeightAccessor var1) {
        IWorldDataServer.super.fillCrashReportCategory(var0, var1);
        SaveData.super.fillCrashReportCategory(var0);
    }

    @Override
    public WorldOptions worldGenOptions() {
        return this.worldOptions;
    }

    @Override
    public boolean isFlatWorld() {
        return this.specialWorldProperty == a.FLAT;
    }

    @Override
    public boolean isDebugWorld() {
        return this.specialWorldProperty == a.DEBUG;
    }

    @Override
    public Lifecycle worldGenSettingsLifecycle() {
        return this.worldGenSettingsLifecycle;
    }

    @Override
    public EnderDragonBattle.a endDragonFightData() {
        return this.endDragonFightData;
    }

    @Override
    public void setEndDragonFightData(EnderDragonBattle.a var0) {
        this.endDragonFightData = var0;
    }

    @Override
    public WorldDataConfiguration getDataConfiguration() {
        return this.settings.getDataConfiguration();
    }

    @Override
    public void setDataConfiguration(WorldDataConfiguration var0) {
        this.settings = this.settings.withDataConfiguration(var0);
    }

    @Override
    @Nullable
    public NBTTagCompound getCustomBossEvents() {
        return this.customBossEvents;
    }

    @Override
    public void setCustomBossEvents(@Nullable NBTTagCompound var0) {
        this.customBossEvents = var0;
    }

    @Override
    public int getWanderingTraderSpawnDelay() {
        return this.wanderingTraderSpawnDelay;
    }

    @Override
    public void setWanderingTraderSpawnDelay(int var0) {
        this.wanderingTraderSpawnDelay = var0;
    }

    @Override
    public int getWanderingTraderSpawnChance() {
        return this.wanderingTraderSpawnChance;
    }

    @Override
    public void setWanderingTraderSpawnChance(int var0) {
        this.wanderingTraderSpawnChance = var0;
    }

    @Override
    @Nullable
    public UUID getWanderingTraderId() {
        return this.wanderingTraderId;
    }

    @Override
    public void setWanderingTraderId(UUID var0) {
        this.wanderingTraderId = var0;
    }

    @Override
    public void setModdedInfo(String var0, boolean var1) {
        this.knownServerBrands.add(var0);
        this.wasModded |= var1;
    }

    @Override
    public boolean wasModded() {
        return this.wasModded;
    }

    @Override
    public Set<String> getKnownServerBrands() {
        return ImmutableSet.copyOf(this.knownServerBrands);
    }

    @Override
    public Set<String> getRemovedFeatureFlags() {
        return Set.copyOf(this.removedFeatureFlags);
    }

    @Override
    public IWorldDataServer overworldData() {
        return this;
    }

    @Override
    public WorldSettings getLevelSettings() {
        return this.settings.copy();
    }

    @Deprecated
    public static final class a
    extends Enum<a> {
        public static final /* enum */ a NONE = new a();
        public static final /* enum */ a FLAT = new a();
        public static final /* enum */ a DEBUG = new a();
        private static final /* synthetic */ a[] d;

        public static a[] values() {
            return (a[])d.clone();
        }

        public static a valueOf(String var0) {
            return Enum.valueOf(a.class, var0);
        }

        private static /* synthetic */ a[] a() {
            return new a[]{NONE, FLAT, DEBUG};
        }

        static {
            d = a.a();
        }
    }
}

