/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.level.storage.WorldPersistentData;

public class PersistentCommandStorage {
    private static final String ID_PREFIX = "command_storage_";
    private final Map<String, a> namespaces = Maps.newHashMap();
    private final WorldPersistentData storage;

    public PersistentCommandStorage(WorldPersistentData var0) {
        this.storage = var0;
    }

    private a newStorage(String var0) {
        a var1 = new a();
        this.namespaces.put(var0, var1);
        return var1;
    }

    private PersistentBase.a<a> factory(String var0) {
        return new PersistentBase.a<a>(() -> this.newStorage(var0), var1 -> this.newStorage(var0).load((NBTTagCompound)var1), DataFixTypes.SAVED_DATA_COMMAND_STORAGE);
    }

    public NBTTagCompound get(MinecraftKey var0) {
        String var1 = var0.getNamespace();
        a var2 = (a)this.storage.get(this.factory(var1), PersistentCommandStorage.createId(var1));
        return var2 != null ? var2.get(var0.getPath()) : new NBTTagCompound();
    }

    public void set(MinecraftKey var0, NBTTagCompound var1) {
        String var2 = var0.getNamespace();
        this.storage.computeIfAbsent(this.factory(var2), PersistentCommandStorage.createId(var2)).put(var0.getPath(), var1);
    }

    public Stream<MinecraftKey> keys() {
        return this.namespaces.entrySet().stream().flatMap(var0 -> ((a)var0.getValue()).getKeys((String)var0.getKey()));
    }

    private static String createId(String var0) {
        return ID_PREFIX + var0;
    }

    static class a
    extends PersistentBase {
        private static final String TAG_CONTENTS = "contents";
        private final Map<String, NBTTagCompound> storage = Maps.newHashMap();

        a() {
        }

        a load(NBTTagCompound var0) {
            NBTTagCompound var1 = var0.getCompound(TAG_CONTENTS);
            for (String var3 : var1.getAllKeys()) {
                this.storage.put(var3, var1.getCompound(var3));
            }
            return this;
        }

        @Override
        public NBTTagCompound save(NBTTagCompound var0) {
            NBTTagCompound var12 = new NBTTagCompound();
            this.storage.forEach((var1, var2) -> var12.put((String)var1, var2.copy()));
            var0.put(TAG_CONTENTS, var12);
            return var0;
        }

        public NBTTagCompound get(String var0) {
            NBTTagCompound var1 = this.storage.get(var0);
            return var1 != null ? var1 : new NBTTagCompound();
        }

        public void put(String var0, NBTTagCompound var1) {
            if (var1.isEmpty()) {
                this.storage.remove(var0);
            } else {
                this.storage.put(var0, var1);
            }
            this.setDirty();
        }

        public Stream<MinecraftKey> getKeys(String var0) {
            return this.storage.keySet().stream().map(var1 -> new MinecraftKey(var0, (String)var1));
        }
    }
}

