/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.saveddata.maps;

import com.mojang.serialization.Codec;
import javax.annotation.Nullable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.material.MaterialMapColor;

public record MapIcon(Type type, byte x, byte y, byte rot, @Nullable IChatBaseComponent name) {
    public byte getImage() {
        return this.type.getIcon();
    }

    public boolean renderOnFrame() {
        return this.type.isRenderedOnFrame();
    }

    public static final class Type
    extends Enum<Type>
    implements INamable {
        public static final /* enum */ Type PLAYER = new Type("player", false, true);
        public static final /* enum */ Type FRAME = new Type("frame", true, true);
        public static final /* enum */ Type RED_MARKER = new Type("red_marker", false, true);
        public static final /* enum */ Type BLUE_MARKER = new Type("blue_marker", false, true);
        public static final /* enum */ Type TARGET_X = new Type("target_x", true, false);
        public static final /* enum */ Type TARGET_POINT = new Type("target_point", true, false);
        public static final /* enum */ Type PLAYER_OFF_MAP = new Type("player_off_map", false, true);
        public static final /* enum */ Type PLAYER_OFF_LIMITS = new Type("player_off_limits", false, true);
        public static final /* enum */ Type MANSION = new Type("mansion", true, 5393476, false, true);
        public static final /* enum */ Type MONUMENT = new Type("monument", true, 3830373, false, true);
        public static final /* enum */ Type BANNER_WHITE = new Type("banner_white", true, true);
        public static final /* enum */ Type BANNER_ORANGE = new Type("banner_orange", true, true);
        public static final /* enum */ Type BANNER_MAGENTA = new Type("banner_magenta", true, true);
        public static final /* enum */ Type BANNER_LIGHT_BLUE = new Type("banner_light_blue", true, true);
        public static final /* enum */ Type BANNER_YELLOW = new Type("banner_yellow", true, true);
        public static final /* enum */ Type BANNER_LIME = new Type("banner_lime", true, true);
        public static final /* enum */ Type BANNER_PINK = new Type("banner_pink", true, true);
        public static final /* enum */ Type BANNER_GRAY = new Type("banner_gray", true, true);
        public static final /* enum */ Type BANNER_LIGHT_GRAY = new Type("banner_light_gray", true, true);
        public static final /* enum */ Type BANNER_CYAN = new Type("banner_cyan", true, true);
        public static final /* enum */ Type BANNER_PURPLE = new Type("banner_purple", true, true);
        public static final /* enum */ Type BANNER_BLUE = new Type("banner_blue", true, true);
        public static final /* enum */ Type BANNER_BROWN = new Type("banner_brown", true, true);
        public static final /* enum */ Type BANNER_GREEN = new Type("banner_green", true, true);
        public static final /* enum */ Type BANNER_RED = new Type("banner_red", true, true);
        public static final /* enum */ Type BANNER_BLACK = new Type("banner_black", true, true);
        public static final /* enum */ Type RED_X = new Type("red_x", true, false);
        public static final /* enum */ Type DESERT_VILLAGE = new Type("village_desert", true, MaterialMapColor.COLOR_LIGHT_GRAY.col, false, true);
        public static final /* enum */ Type PLAINS_VILLAGE = new Type("village_plains", true, MaterialMapColor.COLOR_LIGHT_GRAY.col, false, true);
        public static final /* enum */ Type SAVANNA_VILLAGE = new Type("village_savanna", true, MaterialMapColor.COLOR_LIGHT_GRAY.col, false, true);
        public static final /* enum */ Type SNOWY_VILLAGE = new Type("village_snowy", true, MaterialMapColor.COLOR_LIGHT_GRAY.col, false, true);
        public static final /* enum */ Type TAIGA_VILLAGE = new Type("village_taiga", true, MaterialMapColor.COLOR_LIGHT_GRAY.col, false, true);
        public static final /* enum */ Type JUNGLE_TEMPLE = new Type("jungle_temple", true, MaterialMapColor.COLOR_LIGHT_GRAY.col, false, true);
        public static final /* enum */ Type SWAMP_HUT = new Type("swamp_hut", true, MaterialMapColor.COLOR_LIGHT_GRAY.col, false, true);
        public static final Codec<Type> CODEC;
        private final String name;
        private final byte icon;
        private final boolean renderedOnFrame;
        private final int mapColor;
        private final boolean isExplorationMapElement;
        private final boolean trackCount;
        private static final /* synthetic */ Type[] P;

        public static Type[] values() {
            return (Type[])P.clone();
        }

        public static Type valueOf(String var0) {
            return Enum.valueOf(Type.class, var0);
        }

        private Type(String var2, boolean var3, boolean var4) {
            this(var2, var3, -1, var4, false);
        }

        private Type(String var2, boolean var3, int var4, boolean var5, boolean var6) {
            this.name = var2;
            this.trackCount = var5;
            this.icon = (byte)this.ordinal();
            this.renderedOnFrame = var3;
            this.mapColor = var4;
            this.isExplorationMapElement = var6;
        }

        public byte getIcon() {
            return this.icon;
        }

        public boolean isExplorationMapElement() {
            return this.isExplorationMapElement;
        }

        public boolean isRenderedOnFrame() {
            return this.renderedOnFrame;
        }

        public boolean hasMapColor() {
            return this.mapColor >= 0;
        }

        public int getMapColor() {
            return this.mapColor;
        }

        public static Type byIcon(byte var0) {
            return Type.values()[MathHelper.clamp(var0, 0, Type.values().length - 1)];
        }

        public boolean shouldTrackCount() {
            return this.trackCount;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        private static /* synthetic */ Type[] h() {
            return new Type[]{PLAYER, FRAME, RED_MARKER, BLUE_MARKER, TARGET_X, TARGET_POINT, PLAYER_OFF_MAP, PLAYER_OFF_LIMITS, MANSION, MONUMENT, BANNER_WHITE, BANNER_ORANGE, BANNER_MAGENTA, BANNER_LIGHT_BLUE, BANNER_YELLOW, BANNER_LIME, BANNER_PINK, BANNER_GRAY, BANNER_LIGHT_GRAY, BANNER_CYAN, BANNER_PURPLE, BANNER_BLUE, BANNER_BROWN, BANNER_GREEN, BANNER_RED, BANNER_BLACK, RED_X, DESERT_VILLAGE, PLAINS_VILLAGE, SAVANNA_VILLAGE, SNOWY_VILLAGE, TAIGA_VILLAGE, JUNGLE_TEMPLE, SWAMP_HUT};
        }

        static {
            P = Type.h();
            CODEC = INamable.fromEnum(Type::values);
        }
    }
}

