/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.ArraySetSorted;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.SinglePieceStructure;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.structures.DesertPyramidPiece;
import net.minecraft.world.level.storage.loot.LootTables;

public class DesertPyramidStructure
extends SinglePieceStructure {
    public static final Codec<DesertPyramidStructure> CODEC = DesertPyramidStructure.simpleCodec(DesertPyramidStructure::new);

    public DesertPyramidStructure(Structure.c var0) {
        super(DesertPyramidPiece::new, 21, 21, var0);
    }

    @Override
    public void afterPlace(GeneratorAccessSeed var0, StructureManager var1, ChunkGenerator var2, RandomSource var3, StructureBoundingBox var4, ChunkCoordIntPair var5, PiecesContainer var6) {
        ArraySetSorted var7 = ArraySetSorted.create(BaseBlockPosition::compareTo);
        for (StructurePiece structurePiece : var6.pieces()) {
            if (!(structurePiece instanceof DesertPyramidPiece)) continue;
            DesertPyramidPiece var10 = (DesertPyramidPiece)structurePiece;
            var7.addAll(var10.getPotentialSuspiciousSandWorldPositions());
            DesertPyramidStructure.placeSuspiciousSand(var4, var0, var10.getRandomCollapsedRoofPos());
        }
        ObjectArrayList var8 = new ObjectArrayList(var7.stream().toList());
        RandomSource randomSource = RandomSource.create(var0.getSeed()).forkPositional().at(var6.calculateBoundingBox().getCenter());
        SystemUtils.shuffle(var8, randomSource);
        int var10 = Math.min(var7.size(), randomSource.nextInt(5, 8));
        for (BlockPosition var12 : var8) {
            if (var10 > 0) {
                --var10;
                DesertPyramidStructure.placeSuspiciousSand(var4, var0, var12);
                continue;
            }
            if (!var4.isInside(var12)) continue;
            var0.setBlock(var12, Blocks.SAND.defaultBlockState(), 2);
        }
    }

    private static void placeSuspiciousSand(StructureBoundingBox var0, GeneratorAccessSeed var12, BlockPosition var2) {
        if (var0.isInside(var2)) {
            var12.setBlock(var2, Blocks.SUSPICIOUS_SAND.defaultBlockState(), 2);
            var12.getBlockEntity(var2, TileEntityTypes.BRUSHABLE_BLOCK).ifPresent(var1 -> var1.setLootTable(LootTables.DESERT_PYRAMID_ARCHAEOLOGY, var2.asLong()));
        }
    }

    @Override
    public StructureType<?> type() {
        return StructureType.DESERT_PYRAMID;
    }
}

