/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.placement.RepeatingPlacement;

public class NoiseThresholdCountPlacement
extends RepeatingPlacement {
    public static final Codec<NoiseThresholdCountPlacement> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)Codec.DOUBLE.fieldOf("noise_level").forGetter(var0 -> var0.noiseLevel), (App)Codec.INT.fieldOf("below_noise").forGetter(var0 -> var0.belowNoise), (App)Codec.INT.fieldOf("above_noise").forGetter(var0 -> var0.aboveNoise)).apply((Applicative)var02, NoiseThresholdCountPlacement::new));
    private final double noiseLevel;
    private final int belowNoise;
    private final int aboveNoise;

    private NoiseThresholdCountPlacement(double var0, int var2, int var3) {
        this.noiseLevel = var0;
        this.belowNoise = var2;
        this.aboveNoise = var3;
    }

    public static NoiseThresholdCountPlacement of(double var0, int var2, int var3) {
        return new NoiseThresholdCountPlacement(var0, var2, var3);
    }

    @Override
    protected int count(RandomSource var0, BlockPosition var1) {
        double var2 = BiomeBase.BIOME_INFO_NOISE.getValue((double)var1.getX() / 200.0, (double)var1.getZ() / 200.0, false);
        return var2 < this.noiseLevel ? this.belowNoise : this.aboveNoise;
    }

    @Override
    public PlacementModifierType<?> type() {
        return PlacementModifierType.NOISE_THRESHOLD_COUNT;
    }
}

