/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gameevent;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.GameEventListenerRegistry;
import net.minecraft.world.phys.Vec3D;

public class EuclideanGameEventListenerRegistry
implements GameEventListenerRegistry {
    private final List<GameEventListener> listeners = Lists.newArrayList();
    private final Set<GameEventListener> listenersToRemove = Sets.newHashSet();
    private final List<GameEventListener> listenersToAdd = Lists.newArrayList();
    private boolean processing;
    private final WorldServer level;
    private final int sectionY;
    private final a onEmptyAction;

    public EuclideanGameEventListenerRegistry(WorldServer var0, int var1, a var2) {
        this.level = var0;
        this.sectionY = var1;
        this.onEmptyAction = var2;
    }

    @Override
    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    @Override
    public void register(GameEventListener var0) {
        if (this.processing) {
            this.listenersToAdd.add(var0);
        } else {
            this.listeners.add(var0);
        }
        PacketDebug.sendGameEventListenerInfo(this.level, var0);
    }

    @Override
    public void unregister(GameEventListener var0) {
        if (this.processing) {
            this.listenersToRemove.add(var0);
        } else {
            this.listeners.remove(var0);
        }
        if (this.listeners.isEmpty()) {
            this.onEmptyAction.apply(this.sectionY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean visitInRangeListeners(GameEvent var0, Vec3D var1, GameEvent.a var2, GameEventListenerRegistry.a var3) {
        this.processing = true;
        boolean var4 = false;
        try {
            Iterator<GameEventListener> var5 = this.listeners.iterator();
            while (var5.hasNext()) {
                GameEventListener var6 = var5.next();
                if (this.listenersToRemove.remove(var6)) {
                    var5.remove();
                    continue;
                }
                Optional<Vec3D> var7 = EuclideanGameEventListenerRegistry.getPostableListenerPosition(this.level, var1, var6);
                if (!var7.isPresent()) continue;
                var3.visit(var6, var7.get());
                var4 = true;
            }
        }
        finally {
            this.processing = false;
        }
        if (!this.listenersToAdd.isEmpty()) {
            this.listeners.addAll(this.listenersToAdd);
            this.listenersToAdd.clear();
        }
        if (!this.listenersToRemove.isEmpty()) {
            this.listeners.removeAll(this.listenersToRemove);
            this.listenersToRemove.clear();
        }
        return var4;
    }

    private static Optional<Vec3D> getPostableListenerPosition(WorldServer var0, Vec3D var1, GameEventListener var2) {
        int var6;
        Optional<Vec3D> var3 = var2.getListenerSource().getPosition(var0);
        if (var3.isEmpty()) {
            return Optional.empty();
        }
        double var4 = BlockPosition.containing(var3.get()).distSqr(BlockPosition.containing(var1));
        if (var4 > (double)(var6 = var2.getListenerRadius() * var2.getListenerRadius())) {
            return Optional.empty();
        }
        return var3;
    }

    @FunctionalInterface
    public static interface a {
        public void apply(int var1);
    }
}

