/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state.properties;

import com.google.common.base.MoreObjects;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.world.level.block.state.IBlockDataHolder;

public abstract class IBlockState<T extends Comparable<T>> {
    private final Class<T> clazz;
    private final String name;
    @Nullable
    private Integer hashCode;
    private final Codec<T> codec = Codec.STRING.comapFlatMap(var0 -> this.getValue((String)var0).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unable to read property: " + this + " with value: " + var0)), this::getName);
    private final Codec<a<T>> valueCodec = this.codec.xmap(this::value, a::value);

    protected IBlockState(String var02, Class<T> var1) {
        this.clazz = var1;
        this.name = var02;
    }

    public a<T> value(T var0) {
        return new a<T>(this, var0);
    }

    public a<T> value(IBlockDataHolder<?, ?> var0) {
        return new a(this, var0.getValue(this));
    }

    public Stream<a<T>> getAllValues() {
        return this.getPossibleValues().stream().map(this::value);
    }

    public Codec<T> codec() {
        return this.codec;
    }

    public Codec<a<T>> valueCodec() {
        return this.valueCodec;
    }

    public String getName() {
        return this.name;
    }

    public Class<T> getValueClass() {
        return this.clazz;
    }

    public abstract Collection<T> getPossibleValues();

    public abstract String getName(T var1);

    public abstract Optional<T> getValue(String var1);

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("clazz", this.clazz).add("values", this.getPossibleValues()).toString();
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 instanceof IBlockState) {
            IBlockState var1 = (IBlockState)var0;
            return this.clazz.equals(var1.clazz) && this.name.equals(var1.name);
        }
        return false;
    }

    public final int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = this.generateHashCode();
        }
        return this.hashCode;
    }

    public int generateHashCode() {
        return 31 * this.clazz.hashCode() + this.name.hashCode();
    }

    public <U, S extends IBlockDataHolder<?, S>> DataResult<S> parseValue(DynamicOps<U> var0, S var12, U var2) {
        DataResult var3 = this.codec.parse(var0, var2);
        return var3.map(var1 -> (IBlockDataHolder)var12.setValue(this, var1)).setPartial(var12);
    }

    public record a<T extends Comparable<T>>(IBlockState<T> property, T value) {
        public a {
            if (!var0.getPossibleValues().contains(var1)) {
                throw new IllegalArgumentException("Value " + var1 + " does not belong to property " + var0);
            }
        }

        @Override
        public String toString() {
            return this.property.getName() + "=" + this.property.getName(this.value);
        }
    }
}

