/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ResourceKeyInvalidException;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.UtilColor;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.block.BlockStructure;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyStructureMode;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorRotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class TileEntityStructure
extends TileEntity {
    private static final int SCAN_CORNER_BLOCKS_RANGE = 5;
    public static final int MAX_OFFSET_PER_AXIS = 48;
    public static final int MAX_SIZE_PER_AXIS = 48;
    public static final String AUTHOR_TAG = "author";
    private MinecraftKey structureName;
    public String author = "";
    public String metaData = "";
    public BlockPosition structurePos = new BlockPosition(0, 1, 0);
    public BaseBlockPosition structureSize = BaseBlockPosition.ZERO;
    public EnumBlockMirror mirror = EnumBlockMirror.NONE;
    public EnumBlockRotation rotation = EnumBlockRotation.NONE;
    public BlockPropertyStructureMode mode;
    public boolean ignoreEntities = true;
    private boolean powered;
    public boolean showAir;
    public boolean showBoundingBox = true;
    public float integrity = 1.0f;
    public long seed;

    public TileEntityStructure(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.STRUCTURE_BLOCK, var0, var1);
        this.mode = var1.getValue(BlockStructure.MODE);
    }

    @Override
    protected void saveAdditional(NBTTagCompound var0) {
        super.saveAdditional(var0);
        var0.putString("name", this.getStructureName());
        var0.putString(AUTHOR_TAG, this.author);
        var0.putString("metadata", this.metaData);
        var0.putInt("posX", this.structurePos.getX());
        var0.putInt("posY", this.structurePos.getY());
        var0.putInt("posZ", this.structurePos.getZ());
        var0.putInt("sizeX", this.structureSize.getX());
        var0.putInt("sizeY", this.structureSize.getY());
        var0.putInt("sizeZ", this.structureSize.getZ());
        var0.putString("rotation", this.rotation.toString());
        var0.putString("mirror", this.mirror.toString());
        var0.putString("mode", this.mode.toString());
        var0.putBoolean("ignoreEntities", this.ignoreEntities);
        var0.putBoolean("powered", this.powered);
        var0.putBoolean("showair", this.showAir);
        var0.putBoolean("showboundingbox", this.showBoundingBox);
        var0.putFloat("integrity", this.integrity);
        var0.putLong("seed", this.seed);
    }

    @Override
    public void load(NBTTagCompound var0) {
        super.load(var0);
        this.setStructureName(var0.getString("name"));
        this.author = var0.getString(AUTHOR_TAG);
        this.metaData = var0.getString("metadata");
        int var1 = MathHelper.clamp(var0.getInt("posX"), -48, 48);
        int var2 = MathHelper.clamp(var0.getInt("posY"), -48, 48);
        int var3 = MathHelper.clamp(var0.getInt("posZ"), -48, 48);
        this.structurePos = new BlockPosition(var1, var2, var3);
        int var4 = MathHelper.clamp(var0.getInt("sizeX"), 0, 48);
        int var5 = MathHelper.clamp(var0.getInt("sizeY"), 0, 48);
        int var6 = MathHelper.clamp(var0.getInt("sizeZ"), 0, 48);
        this.structureSize = new BaseBlockPosition(var4, var5, var6);
        try {
            this.rotation = EnumBlockRotation.valueOf(var0.getString("rotation"));
        }
        catch (IllegalArgumentException var7) {
            this.rotation = EnumBlockRotation.NONE;
        }
        try {
            this.mirror = EnumBlockMirror.valueOf(var0.getString("mirror"));
        }
        catch (IllegalArgumentException var7) {
            this.mirror = EnumBlockMirror.NONE;
        }
        try {
            this.mode = BlockPropertyStructureMode.valueOf(var0.getString("mode"));
        }
        catch (IllegalArgumentException var7) {
            this.mode = BlockPropertyStructureMode.DATA;
        }
        this.ignoreEntities = var0.getBoolean("ignoreEntities");
        this.powered = var0.getBoolean("powered");
        this.showAir = var0.getBoolean("showair");
        this.showBoundingBox = var0.getBoolean("showboundingbox");
        this.integrity = var0.contains("integrity") ? var0.getFloat("integrity") : 1.0f;
        this.seed = var0.getLong("seed");
        this.updateBlockState();
    }

    private void updateBlockState() {
        if (this.level == null) {
            return;
        }
        BlockPosition var0 = this.getBlockPos();
        IBlockData var1 = this.level.getBlockState(var0);
        if (var1.is(Blocks.STRUCTURE_BLOCK)) {
            this.level.setBlock(var0, (IBlockData)var1.setValue(BlockStructure.MODE, this.mode), 2);
        }
    }

    public PacketPlayOutTileEntityData getUpdatePacket() {
        return PacketPlayOutTileEntityData.create(this);
    }

    @Override
    public NBTTagCompound getUpdateTag() {
        return this.saveWithoutMetadata();
    }

    public boolean usedBy(EntityHuman var0) {
        if (!var0.canUseGameMasterBlocks()) {
            return false;
        }
        if (var0.getCommandSenderWorld().isClientSide) {
            var0.openStructureBlock(this);
        }
        return true;
    }

    public String getStructureName() {
        return this.structureName == null ? "" : this.structureName.toString();
    }

    public String getStructurePath() {
        return this.structureName == null ? "" : this.structureName.getPath();
    }

    public boolean hasStructureName() {
        return this.structureName != null;
    }

    public void setStructureName(@Nullable String var0) {
        this.setStructureName(UtilColor.isNullOrEmpty(var0) ? null : MinecraftKey.tryParse(var0));
    }

    public void setStructureName(@Nullable MinecraftKey var0) {
        this.structureName = var0;
    }

    public void createdBy(EntityLiving var0) {
        this.author = var0.getName().getString();
    }

    public BlockPosition getStructurePos() {
        return this.structurePos;
    }

    public void setStructurePos(BlockPosition var0) {
        this.structurePos = var0;
    }

    public BaseBlockPosition getStructureSize() {
        return this.structureSize;
    }

    public void setStructureSize(BaseBlockPosition var0) {
        this.structureSize = var0;
    }

    public EnumBlockMirror getMirror() {
        return this.mirror;
    }

    public void setMirror(EnumBlockMirror var0) {
        this.mirror = var0;
    }

    public EnumBlockRotation getRotation() {
        return this.rotation;
    }

    public void setRotation(EnumBlockRotation var0) {
        this.rotation = var0;
    }

    public String getMetaData() {
        return this.metaData;
    }

    public void setMetaData(String var0) {
        this.metaData = var0;
    }

    public BlockPropertyStructureMode getMode() {
        return this.mode;
    }

    public void setMode(BlockPropertyStructureMode var0) {
        this.mode = var0;
        IBlockData var1 = this.level.getBlockState(this.getBlockPos());
        if (var1.is(Blocks.STRUCTURE_BLOCK)) {
            this.level.setBlock(this.getBlockPos(), (IBlockData)var1.setValue(BlockStructure.MODE, var0), 2);
        }
    }

    public boolean isIgnoreEntities() {
        return this.ignoreEntities;
    }

    public void setIgnoreEntities(boolean var0) {
        this.ignoreEntities = var0;
    }

    public float getIntegrity() {
        return this.integrity;
    }

    public void setIntegrity(float var0) {
        this.integrity = var0;
    }

    public long getSeed() {
        return this.seed;
    }

    public void setSeed(long var0) {
        this.seed = var0;
    }

    public boolean detectSize() {
        if (this.mode != BlockPropertyStructureMode.SAVE) {
            return false;
        }
        BlockPosition var0 = this.getBlockPos();
        int var12 = 80;
        BlockPosition var2 = new BlockPosition(var0.getX() - 80, this.level.getMinBuildHeight(), var0.getZ() - 80);
        BlockPosition var3 = new BlockPosition(var0.getX() + 80, this.level.getMaxBuildHeight() - 1, var0.getZ() + 80);
        Stream<BlockPosition> var4 = this.getRelatedCorners(var2, var3);
        return TileEntityStructure.calculateEnclosingBoundingBox(var0, var4).filter(var1 -> {
            int var2 = var1.maxX() - var1.minX();
            int var3 = var1.maxY() - var1.minY();
            int var4 = var1.maxZ() - var1.minZ();
            if (var2 > 1 && var3 > 1 && var4 > 1) {
                this.structurePos = new BlockPosition(var1.minX() - var0.getX() + 1, var1.minY() - var0.getY() + 1, var1.minZ() - var0.getZ() + 1);
                this.structureSize = new BaseBlockPosition(var2 - 1, var3 - 1, var4 - 1);
                this.setChanged();
                IBlockData var5 = this.level.getBlockState(var0);
                this.level.sendBlockUpdated(var0, var5, var5, 3);
                return true;
            }
            return false;
        }).isPresent();
    }

    private Stream<BlockPosition> getRelatedCorners(BlockPosition var02, BlockPosition var1) {
        return BlockPosition.betweenClosedStream(var02, var1).filter(var0 -> this.level.getBlockState((BlockPosition)var0).is(Blocks.STRUCTURE_BLOCK)).map(this.level::getBlockEntity).filter(var0 -> var0 instanceof TileEntityStructure).map(var0 -> (TileEntityStructure)var0).filter(var0 -> var0.mode == BlockPropertyStructureMode.CORNER && Objects.equals(this.structureName, var0.structureName)).map(TileEntity::getBlockPos);
    }

    private static Optional<StructureBoundingBox> calculateEnclosingBoundingBox(BlockPosition var0, Stream<BlockPosition> var1) {
        Iterator var2 = var1.iterator();
        if (!var2.hasNext()) {
            return Optional.empty();
        }
        BlockPosition var3 = (BlockPosition)var2.next();
        StructureBoundingBox var4 = new StructureBoundingBox(var3);
        if (var2.hasNext()) {
            var2.forEachRemaining(var4::encapsulate);
        } else {
            var4.encapsulate(var0);
        }
        return Optional.of(var4);
    }

    public boolean saveStructure() {
        return this.saveStructure(true);
    }

    public boolean saveStructure(boolean var0) {
        DefinedStructure var4;
        if (this.mode != BlockPropertyStructureMode.SAVE || this.level.isClientSide || this.structureName == null) {
            return false;
        }
        BlockPosition var1 = this.getBlockPos().offset(this.structurePos);
        WorldServer var2 = (WorldServer)this.level;
        StructureTemplateManager var3 = var2.getStructureManager();
        try {
            var4 = var3.getOrCreate(this.structureName);
        }
        catch (ResourceKeyInvalidException var5) {
            return false;
        }
        var4.fillFromWorld(this.level, var1, this.structureSize, !this.ignoreEntities, Blocks.STRUCTURE_VOID);
        var4.setAuthor(this.author);
        if (var0) {
            try {
                return var3.save(this.structureName);
            }
            catch (ResourceKeyInvalidException var5) {
                return false;
            }
        }
        return true;
    }

    public boolean loadStructure(WorldServer var0) {
        return this.loadStructure(var0, true);
    }

    public static RandomSource createRandom(long var0) {
        if (var0 == 0L) {
            return RandomSource.create(SystemUtils.getMillis());
        }
        return RandomSource.create(var0);
    }

    public boolean loadStructure(WorldServer var0, boolean var1) {
        Optional<DefinedStructure> var3;
        if (this.mode != BlockPropertyStructureMode.LOAD || this.structureName == null) {
            return false;
        }
        StructureTemplateManager var2 = var0.getStructureManager();
        try {
            var3 = var2.get(this.structureName);
        }
        catch (ResourceKeyInvalidException var4) {
            return false;
        }
        if (var3.isEmpty()) {
            return false;
        }
        return this.loadStructure(var0, var1, var3.get());
    }

    public boolean loadStructure(WorldServer var0, boolean var1, DefinedStructure var2) {
        Object var6;
        BaseBlockPosition var4;
        boolean var5;
        BlockPosition var3 = this.getBlockPos();
        if (!UtilColor.isNullOrEmpty(var2.getAuthor())) {
            this.author = var2.getAuthor();
        }
        if (!(var5 = this.structureSize.equals(var4 = var2.getSize()))) {
            this.structureSize = var4;
            this.setChanged();
            var6 = var0.getBlockState(var3);
            var0.sendBlockUpdated(var3, (IBlockData)var6, (IBlockData)var6, 3);
        }
        if (!var1 || var5) {
            var6 = new DefinedStructureInfo().setMirror(this.mirror).setRotation(this.rotation).setIgnoreEntities(this.ignoreEntities);
            if (this.integrity < 1.0f) {
                ((DefinedStructureInfo)var6).clearProcessors().addProcessor(new DefinedStructureProcessorRotation(MathHelper.clamp(this.integrity, 0.0f, 1.0f))).setRandom(TileEntityStructure.createRandom(this.seed));
            }
            BlockPosition var7 = var3.offset(this.structurePos);
            var2.placeInWorld(var0, var7, var7, (DefinedStructureInfo)var6, TileEntityStructure.createRandom(this.seed), 2);
            return true;
        }
        return false;
    }

    public void unloadStructure() {
        if (this.structureName == null) {
            return;
        }
        WorldServer var0 = (WorldServer)this.level;
        StructureTemplateManager var1 = var0.getStructureManager();
        var1.remove(this.structureName);
    }

    public boolean isStructureLoadable() {
        if (this.mode != BlockPropertyStructureMode.LOAD || this.level.isClientSide || this.structureName == null) {
            return false;
        }
        WorldServer var0 = (WorldServer)this.level;
        StructureTemplateManager var1 = var0.getStructureManager();
        try {
            return var1.get(this.structureName).isPresent();
        }
        catch (ResourceKeyInvalidException var2) {
            return false;
        }
    }

    public boolean isPowered() {
        return this.powered;
    }

    public void setPowered(boolean var0) {
        this.powered = var0;
    }

    public boolean getShowAir() {
        return this.showAir;
    }

    public void setShowAir(boolean var0) {
        this.showAir = var0;
    }

    public boolean getShowBoundingBox() {
        return this.showBoundingBox;
    }

    public void setShowBoundingBox(boolean var0) {
        this.showBoundingBox = var0;
    }

    public /* synthetic */ Packet getUpdatePacket() {
        return this.getUpdatePacket();
    }

    private static /* synthetic */ void a(WorldServer var0, BlockPosition var1) {
        var0.setBlock(var1, Blocks.STRUCTURE_VOID.defaultBlockState(), 2);
    }

    public static final class UpdateType
    extends Enum<UpdateType> {
        public static final /* enum */ UpdateType UPDATE_DATA = new UpdateType();
        public static final /* enum */ UpdateType SAVE_AREA = new UpdateType();
        public static final /* enum */ UpdateType LOAD_AREA = new UpdateType();
        public static final /* enum */ UpdateType SCAN_AREA = new UpdateType();
        private static final /* synthetic */ UpdateType[] e;

        public static UpdateType[] values() {
            return (UpdateType[])e.clone();
        }

        public static UpdateType valueOf(String var0) {
            return Enum.valueOf(UpdateType.class, var0);
        }

        private static /* synthetic */ UpdateType[] a() {
            return new UpdateType[]{UPDATE_DATA, SAVE_AREA, LOAD_AREA, SCAN_AREA};
        }

        static {
            e = UpdateType.a();
        }
    }
}

