/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.Clearable;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemRecord;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockJukeBox;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.ticks.ContainerSingleItem;

public class TileEntityJukeBox
extends TileEntity
implements Clearable,
ContainerSingleItem {
    private static final int SONG_END_PADDING = 20;
    private final NonNullList<ItemStack> items = NonNullList.withSize(this.getContainerSize(), ItemStack.EMPTY);
    private int ticksSinceLastEvent;
    public long tickCount;
    public long recordStartedTick;
    public boolean isPlaying;

    public TileEntityJukeBox(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.JUKEBOX, var0, var1);
    }

    @Override
    public void load(NBTTagCompound var0) {
        super.load(var0);
        if (var0.contains("RecordItem", 10)) {
            this.items.set(0, ItemStack.of(var0.getCompound("RecordItem")));
        }
        this.isPlaying = var0.getBoolean("IsPlaying");
        this.recordStartedTick = var0.getLong("RecordStartTick");
        this.tickCount = var0.getLong("TickCount");
    }

    @Override
    protected void saveAdditional(NBTTagCompound var0) {
        super.saveAdditional(var0);
        if (!this.getFirstItem().isEmpty()) {
            var0.put("RecordItem", this.getFirstItem().save(new NBTTagCompound()));
        }
        var0.putBoolean("IsPlaying", this.isPlaying);
        var0.putLong("RecordStartTick", this.recordStartedTick);
        var0.putLong("TickCount", this.tickCount);
    }

    public boolean isRecordPlaying() {
        return !this.getFirstItem().isEmpty() && this.isPlaying;
    }

    private void setHasRecordBlockState(@Nullable Entity var0, boolean var1) {
        if (this.level.getBlockState(this.getBlockPos()) == this.getBlockState()) {
            this.level.setBlock(this.getBlockPos(), (IBlockData)this.getBlockState().setValue(BlockJukeBox.HAS_RECORD, var1), 2);
            this.level.gameEvent(GameEvent.BLOCK_CHANGE, this.getBlockPos(), GameEvent.a.of(var0, this.getBlockState()));
        }
    }

    @VisibleForTesting
    public void startPlaying() {
        this.recordStartedTick = this.tickCount;
        this.isPlaying = true;
        this.level.updateNeighborsAt(this.getBlockPos(), this.getBlockState().getBlock());
        this.level.levelEvent(null, 1010, this.getBlockPos(), Item.getId(this.getFirstItem().getItem()));
        this.setChanged();
    }

    private void stopPlaying() {
        this.isPlaying = false;
        this.level.gameEvent(GameEvent.JUKEBOX_STOP_PLAY, this.getBlockPos(), GameEvent.a.of(this.getBlockState()));
        this.level.updateNeighborsAt(this.getBlockPos(), this.getBlockState().getBlock());
        this.level.levelEvent(1011, this.getBlockPos(), 0);
        this.setChanged();
    }

    private void tick(World var0, BlockPosition var1, IBlockData var2) {
        Item item;
        ++this.ticksSinceLastEvent;
        if (this.isRecordPlaying() && (item = this.getFirstItem().getItem()) instanceof ItemRecord) {
            ItemRecord var3 = (ItemRecord)item;
            if (this.shouldRecordStopPlaying(var3)) {
                this.stopPlaying();
            } else if (this.shouldSendJukeboxPlayingEvent()) {
                this.ticksSinceLastEvent = 0;
                var0.gameEvent(GameEvent.JUKEBOX_PLAY, var1, GameEvent.a.of(var2));
                this.spawnMusicParticles(var0, var1);
            }
        }
        ++this.tickCount;
    }

    private boolean shouldRecordStopPlaying(ItemRecord var0) {
        return this.tickCount >= this.recordStartedTick + (long)var0.getLengthInTicks() + 20L;
    }

    private boolean shouldSendJukeboxPlayingEvent() {
        return this.ticksSinceLastEvent >= 20;
    }

    @Override
    public ItemStack getItem(int var0) {
        return this.items.get(var0);
    }

    @Override
    public ItemStack removeItem(int var0, int var1) {
        ItemStack var2 = Objects.requireNonNullElse(this.items.get(var0), ItemStack.EMPTY);
        this.items.set(var0, ItemStack.EMPTY);
        if (!var2.isEmpty()) {
            this.setHasRecordBlockState(null, false);
            this.stopPlaying();
        }
        return var2;
    }

    @Override
    public void setItem(int var0, ItemStack var1) {
        if (var1.is(TagsItem.MUSIC_DISCS) && this.level != null) {
            this.items.set(var0, var1);
            this.setHasRecordBlockState(null, true);
            this.startPlaying();
        } else if (var1.isEmpty()) {
            this.removeItem(var0, 1);
        }
    }

    @Override
    public int getMaxStackSize() {
        return 1;
    }

    @Override
    public boolean stillValid(EntityHuman var0) {
        return IInventory.stillValidBlockEntity(this, var0);
    }

    @Override
    public boolean canPlaceItem(int var0, ItemStack var1) {
        return var1.is(TagsItem.MUSIC_DISCS) && this.getItem(var0).isEmpty();
    }

    @Override
    public boolean canTakeItem(IInventory var0, int var1, ItemStack var2) {
        return var0.hasAnyMatching(ItemStack::isEmpty);
    }

    private void spawnMusicParticles(World var0, BlockPosition var1) {
        if (var0 instanceof WorldServer) {
            WorldServer var2 = (WorldServer)var0;
            Vec3D var3 = Vec3D.atBottomCenterOf(var1).add(0.0, 1.2f, 0.0);
            float var4 = (float)var0.getRandom().nextInt(4) / 24.0f;
            var2.sendParticles(Particles.NOTE, var3.x(), var3.y(), var3.z(), 0, var4, 0.0, 0.0, 1.0);
        }
    }

    public void popOutRecord() {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        BlockPosition var0 = this.getBlockPos();
        ItemStack var1 = this.getFirstItem();
        if (var1.isEmpty()) {
            return;
        }
        this.removeFirstItem();
        Vec3D var2 = Vec3D.atLowerCornerWithOffset(var0, 0.5, 1.01, 0.5).offsetRandom(this.level.random, 0.7f);
        ItemStack var3 = var1.copy();
        EntityItem var4 = new EntityItem(this.level, var2.x(), var2.y(), var2.z(), var3);
        var4.setDefaultPickUpDelay();
        this.level.addFreshEntity(var4);
    }

    public static void playRecordTick(World var0, BlockPosition var1, IBlockData var2, TileEntityJukeBox var3) {
        var3.tick(var0, var1, var2);
    }

    @VisibleForTesting
    public void setRecordWithoutPlaying(ItemStack var0) {
        this.items.set(0, var0);
        this.level.updateNeighborsAt(this.getBlockPos(), this.getBlockState().getBlock());
        this.setChanged();
    }
}

