/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IInventory;
import net.minecraft.world.IInventoryHolder;
import net.minecraft.world.IWorldInventory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerHopper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.BlockHopper;
import net.minecraft.world.level.block.entity.IHopper;
import net.minecraft.world.level.block.entity.TileEntityChest;
import net.minecraft.world.level.block.entity.TileEntityLootable;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class TileEntityHopper
extends TileEntityLootable
implements IHopper {
    public static final int MOVE_ITEM_SPEED = 8;
    public static final int HOPPER_CONTAINER_SIZE = 5;
    private NonNullList<ItemStack> items = NonNullList.withSize(5, ItemStack.EMPTY);
    private int cooldownTime = -1;
    private long tickedGameTime;

    public TileEntityHopper(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.HOPPER, var0, var1);
    }

    @Override
    public void load(NBTTagCompound var0) {
        super.load(var0);
        this.items = NonNullList.withSize(this.getContainerSize(), ItemStack.EMPTY);
        if (!this.tryLoadLootTable(var0)) {
            ContainerUtil.loadAllItems(var0, this.items);
        }
        this.cooldownTime = var0.getInt("TransferCooldown");
    }

    @Override
    protected void saveAdditional(NBTTagCompound var0) {
        super.saveAdditional(var0);
        if (!this.trySaveLootTable(var0)) {
            ContainerUtil.saveAllItems(var0, this.items);
        }
        var0.putInt("TransferCooldown", this.cooldownTime);
    }

    @Override
    public int getContainerSize() {
        return this.items.size();
    }

    @Override
    public ItemStack removeItem(int var0, int var1) {
        this.unpackLootTable(null);
        return ContainerUtil.removeItem(this.getItems(), var0, var1);
    }

    @Override
    public void setItem(int var0, ItemStack var1) {
        this.unpackLootTable(null);
        this.getItems().set(var0, var1);
        if (var1.getCount() > this.getMaxStackSize()) {
            var1.setCount(this.getMaxStackSize());
        }
    }

    @Override
    protected IChatBaseComponent getDefaultName() {
        return IChatBaseComponent.translatable("container.hopper");
    }

    public static void pushItemsTick(World var0, BlockPosition var1, IBlockData var2, TileEntityHopper var3) {
        --var3.cooldownTime;
        var3.tickedGameTime = var0.getGameTime();
        if (!var3.isOnCooldown()) {
            var3.setCooldown(0);
            TileEntityHopper.tryMoveItems(var0, var1, var2, var3, () -> TileEntityHopper.suckInItems(var0, var3));
        }
    }

    private static boolean tryMoveItems(World var0, BlockPosition var1, IBlockData var2, TileEntityHopper var3, BooleanSupplier var4) {
        if (var0.isClientSide) {
            return false;
        }
        if (!var3.isOnCooldown() && var2.getValue(BlockHopper.ENABLED).booleanValue()) {
            boolean var5 = false;
            if (!var3.isEmpty()) {
                var5 = TileEntityHopper.ejectItems(var0, var1, var2, var3);
            }
            if (!var3.inventoryFull()) {
                var5 |= var4.getAsBoolean();
            }
            if (var5) {
                var3.setCooldown(8);
                TileEntityHopper.setChanged(var0, var1, var2);
                return true;
            }
        }
        return false;
    }

    private boolean inventoryFull() {
        for (ItemStack var1 : this.items) {
            if (!var1.isEmpty() && var1.getCount() == var1.getMaxStackSize()) continue;
            return false;
        }
        return true;
    }

    private static boolean ejectItems(World var0, BlockPosition var1, IBlockData var2, IInventory var3) {
        IInventory var4 = TileEntityHopper.getAttachedContainer(var0, var1, var2);
        if (var4 == null) {
            return false;
        }
        EnumDirection var5 = var2.getValue(BlockHopper.FACING).getOpposite();
        if (TileEntityHopper.isFullContainer(var4, var5)) {
            return false;
        }
        for (int var6 = 0; var6 < var3.getContainerSize(); ++var6) {
            if (var3.getItem(var6).isEmpty()) continue;
            ItemStack var7 = var3.getItem(var6).copy();
            ItemStack var8 = TileEntityHopper.addItem(var3, var4, var3.removeItem(var6, 1), var5);
            if (var8.isEmpty()) {
                var4.setChanged();
                return true;
            }
            var3.setItem(var6, var7);
        }
        return false;
    }

    private static IntStream getSlots(IInventory var0, EnumDirection var1) {
        if (var0 instanceof IWorldInventory) {
            return IntStream.of(((IWorldInventory)var0).getSlotsForFace(var1));
        }
        return IntStream.range(0, var0.getContainerSize());
    }

    private static boolean isFullContainer(IInventory var0, EnumDirection var12) {
        return TileEntityHopper.getSlots(var0, var12).allMatch(var1 -> {
            ItemStack var2 = var0.getItem(var1);
            return var2.getCount() >= var2.getMaxStackSize();
        });
    }

    private static boolean isEmptyContainer(IInventory var0, EnumDirection var12) {
        return TileEntityHopper.getSlots(var0, var12).allMatch(var1 -> var0.getItem(var1).isEmpty());
    }

    public static boolean suckInItems(World var0, IHopper var1) {
        IInventory var2 = TileEntityHopper.getSourceContainer(var0, var1);
        if (var2 != null) {
            EnumDirection var32 = EnumDirection.DOWN;
            if (TileEntityHopper.isEmptyContainer(var2, var32)) {
                return false;
            }
            return TileEntityHopper.getSlots(var2, var32).anyMatch(var3 -> TileEntityHopper.tryTakeInItemFromSlot(var1, var2, var3, var32));
        }
        for (EntityItem var4 : TileEntityHopper.getItemsAtAndAbove(var0, var1)) {
            if (!TileEntityHopper.addItem(var1, var4)) continue;
            return true;
        }
        return false;
    }

    private static boolean tryTakeInItemFromSlot(IHopper var0, IInventory var1, int var2, EnumDirection var3) {
        ItemStack var4 = var1.getItem(var2);
        if (!var4.isEmpty() && TileEntityHopper.canTakeItemFromContainer(var0, var1, var4, var2, var3)) {
            ItemStack var5 = var4.copy();
            ItemStack var6 = TileEntityHopper.addItem(var1, var0, var1.removeItem(var2, 1), null);
            if (var6.isEmpty()) {
                var1.setChanged();
                return true;
            }
            var1.setItem(var2, var5);
        }
        return false;
    }

    public static boolean addItem(IInventory var0, EntityItem var1) {
        boolean var2 = false;
        ItemStack var3 = var1.getItem().copy();
        ItemStack var4 = TileEntityHopper.addItem(null, var0, var3, null);
        if (var4.isEmpty()) {
            var2 = true;
            var1.setItem(ItemStack.EMPTY);
            var1.discard();
        } else {
            var1.setItem(var4);
        }
        return var2;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public static ItemStack addItem(@Nullable IInventory var0, IInventory var1, ItemStack var2, @Nullable EnumDirection var3) {
        if (var1 instanceof IWorldInventory) {
            IWorldInventory var4 = (IWorldInventory)var1;
            if (var3 != null) {
                int[] var5 = var4.getSlotsForFace(var3);
                int var6 = 0;
                while (var6 < var5.length) {
                    if (var2.isEmpty()) return var2;
                    var2 = TileEntityHopper.tryMoveInItem(var0, var1, var2, var5[var6], var3);
                    ++var6;
                }
                return var2;
            }
        }
        int var5 = var1.getContainerSize();
        int var6 = 0;
        while (var6 < var5) {
            if (var2.isEmpty()) return var2;
            var2 = TileEntityHopper.tryMoveInItem(var0, var1, var2, var6, var3);
            ++var6;
        }
        return var2;
    }

    private static boolean canPlaceItemInContainer(IInventory var0, ItemStack var1, int var2, @Nullable EnumDirection var3) {
        IWorldInventory var4;
        if (!var0.canPlaceItem(var2, var1)) {
            return false;
        }
        return !(var0 instanceof IWorldInventory) || (var4 = (IWorldInventory)var0).canPlaceItemThroughFace(var2, var1, var3);
    }

    private static boolean canTakeItemFromContainer(IInventory var0, IInventory var1, ItemStack var2, int var3, EnumDirection var4) {
        IWorldInventory var5;
        if (!var1.canTakeItem(var0, var3, var2)) {
            return false;
        }
        return !(var1 instanceof IWorldInventory) || (var5 = (IWorldInventory)var1).canTakeItemThroughFace(var3, var2, var4);
    }

    private static ItemStack tryMoveInItem(@Nullable IInventory var0, IInventory var1, ItemStack var2, int var3, @Nullable EnumDirection var4) {
        ItemStack var5 = var1.getItem(var3);
        if (TileEntityHopper.canPlaceItemInContainer(var1, var2, var3, var4)) {
            int var9;
            boolean var6 = false;
            boolean var7 = var1.isEmpty();
            if (var5.isEmpty()) {
                var1.setItem(var3, var2);
                var2 = ItemStack.EMPTY;
                var6 = true;
            } else if (TileEntityHopper.canMergeItems(var5, var2)) {
                int var8 = var2.getMaxStackSize() - var5.getCount();
                var9 = Math.min(var2.getCount(), var8);
                var2.shrink(var9);
                var5.grow(var9);
                boolean bl = var6 = var9 > 0;
            }
            if (var6) {
                TileEntityHopper var8;
                if (var7 && var1 instanceof TileEntityHopper && !(var8 = (TileEntityHopper)var1).isOnCustomCooldown()) {
                    var9 = 0;
                    if (var0 instanceof TileEntityHopper) {
                        TileEntityHopper var10 = (TileEntityHopper)var0;
                        if (var8.tickedGameTime >= var10.tickedGameTime) {
                            var9 = 1;
                        }
                    }
                    var8.setCooldown(8 - var9);
                }
                var1.setChanged();
            }
        }
        return var2;
    }

    @Nullable
    private static IInventory getAttachedContainer(World var0, BlockPosition var1, IBlockData var2) {
        EnumDirection var3 = var2.getValue(BlockHopper.FACING);
        return TileEntityHopper.getContainerAt(var0, var1.relative(var3));
    }

    @Nullable
    private static IInventory getSourceContainer(World var0, IHopper var1) {
        return TileEntityHopper.getContainerAt(var0, var1.getLevelX(), var1.getLevelY() + 1.0, var1.getLevelZ());
    }

    public static List<EntityItem> getItemsAtAndAbove(World var0, IHopper var1) {
        return var1.getSuckShape().toAabbs().stream().flatMap(var2 -> var0.getEntitiesOfClass(EntityItem.class, var2.move(var1.getLevelX() - 0.5, var1.getLevelY() - 0.5, var1.getLevelZ() - 0.5), IEntitySelector.ENTITY_STILL_ALIVE).stream()).collect(Collectors.toList());
    }

    @Nullable
    public static IInventory getContainerAt(World var0, BlockPosition var1) {
        return TileEntityHopper.getContainerAt(var0, (double)var1.getX() + 0.5, (double)var1.getY() + 0.5, (double)var1.getZ() + 0.5);
    }

    @Nullable
    private static IInventory getContainerAt(World var0, double var1, double var3, double var5) {
        Object var11;
        IInventory var7 = null;
        BlockPosition var8 = BlockPosition.containing(var1, var3, var5);
        IBlockData var9 = var0.getBlockState(var8);
        Block var10 = var9.getBlock();
        if (var10 instanceof IInventoryHolder) {
            var7 = ((IInventoryHolder)((Object)var10)).getContainer(var9, var0, var8);
        } else if (var9.hasBlockEntity() && (var11 = var0.getBlockEntity(var8)) instanceof IInventory && (var7 = (IInventory)var11) instanceof TileEntityChest && var10 instanceof BlockChest) {
            var7 = BlockChest.getContainer((BlockChest)var10, var9, var0, var8, true);
        }
        if (var7 == null && !(var11 = var0.getEntities((Entity)null, new AxisAlignedBB(var1 - 0.5, var3 - 0.5, var5 - 0.5, var1 + 0.5, var3 + 0.5, var5 + 0.5), IEntitySelector.CONTAINER_ENTITY_SELECTOR)).isEmpty()) {
            var7 = (IInventory)var11.get(var0.random.nextInt(var11.size()));
        }
        return var7;
    }

    private static boolean canMergeItems(ItemStack var0, ItemStack var1) {
        return var0.getCount() <= var0.getMaxStackSize() && ItemStack.isSameItemSameTags(var0, var1);
    }

    @Override
    public double getLevelX() {
        return (double)this.worldPosition.getX() + 0.5;
    }

    @Override
    public double getLevelY() {
        return (double)this.worldPosition.getY() + 0.5;
    }

    @Override
    public double getLevelZ() {
        return (double)this.worldPosition.getZ() + 0.5;
    }

    private void setCooldown(int var0) {
        this.cooldownTime = var0;
    }

    private boolean isOnCooldown() {
        return this.cooldownTime > 0;
    }

    private boolean isOnCustomCooldown() {
        return this.cooldownTime > 8;
    }

    @Override
    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @Override
    protected void setItems(NonNullList<ItemStack> var0) {
        this.items = var0;
    }

    public static void entityInside(World var0, BlockPosition var1, IBlockData var2, Entity var3, TileEntityHopper var4) {
        EntityItem var5;
        if (var3 instanceof EntityItem && !(var5 = (EntityItem)var3).getItem().isEmpty() && VoxelShapes.joinIsNotEmpty(VoxelShapes.create(var3.getBoundingBox().move(-var1.getX(), -var1.getY(), -var1.getZ())), var4.getSuckShape(), OperatorBoolean.AND)) {
            TileEntityHopper.tryMoveItems(var0, var1, var2, var4, () -> TileEntityHopper.addItem(var4, var5));
        }
    }

    @Override
    protected Container createMenu(int var0, PlayerInventory var1) {
        return new ContainerHopper(var0, var1, this);
    }
}

