/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.annotations.VisibleForTesting;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.SculkCatalystBlock;
import net.minecraft.world.level.block.SculkSpreader;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec3D;

public class SculkCatalystBlockEntity
extends TileEntity
implements GameEventListener.b<CatalystListener> {
    private final CatalystListener catalystListener;

    public SculkCatalystBlockEntity(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.SCULK_CATALYST, var0, var1);
        this.catalystListener = new CatalystListener(var1, new BlockPositionSource(var0));
    }

    public static void serverTick(World var0, BlockPosition var1, IBlockData var2, SculkCatalystBlockEntity var3) {
        var3.catalystListener.getSculkSpreader().updateCursors(var0, var1, var0.getRandom(), true);
    }

    @Override
    public void load(NBTTagCompound var0) {
        this.catalystListener.sculkSpreader.load(var0);
    }

    @Override
    protected void saveAdditional(NBTTagCompound var0) {
        this.catalystListener.sculkSpreader.save(var0);
        super.saveAdditional(var0);
    }

    @Override
    public CatalystListener getListener() {
        return this.catalystListener;
    }

    @Override
    public /* synthetic */ GameEventListener getListener() {
        return this.getListener();
    }

    public static class CatalystListener
    implements GameEventListener {
        public static final int PULSE_TICKS = 8;
        final SculkSpreader sculkSpreader;
        private final IBlockData blockState;
        private final PositionSource positionSource;

        public CatalystListener(IBlockData var0, PositionSource var1) {
            this.blockState = var0;
            this.positionSource = var1;
            this.sculkSpreader = SculkSpreader.createLevelSpreader();
        }

        @Override
        public PositionSource getListenerSource() {
            return this.positionSource;
        }

        @Override
        public int getListenerRadius() {
            return 8;
        }

        @Override
        public GameEventListener.a getDeliveryMode() {
            return GameEventListener.a.BY_DISTANCE;
        }

        @Override
        public boolean handleGameEvent(WorldServer var0, GameEvent var12, GameEvent.a var2, Vec3D var3) {
            Entity entity;
            if (var12 == GameEvent.ENTITY_DIE && (entity = var2.sourceEntity()) instanceof EntityLiving) {
                EntityLiving var4 = (EntityLiving)entity;
                if (!var4.wasExperienceConsumed()) {
                    int var5 = var4.getExperienceReward();
                    if (var4.shouldDropExperience() && var5 > 0) {
                        this.sculkSpreader.addCursors(BlockPosition.containing(var3.relative(EnumDirection.UP, 0.5)), var5);
                        this.tryAwardItSpreadsAdvancement(var0, var4);
                    }
                    var4.skipDropExperience();
                    this.positionSource.getPosition(var0).ifPresent(var1 -> this.bloom(var0, BlockPosition.containing(var1), this.blockState, var0.getRandom()));
                }
                return true;
            }
            return false;
        }

        @VisibleForTesting
        public SculkSpreader getSculkSpreader() {
            return this.sculkSpreader;
        }

        public void bloom(WorldServer var0, BlockPosition var1, IBlockData var2, RandomSource var3) {
            var0.setBlock(var1, (IBlockData)var2.setValue(SculkCatalystBlock.PULSE, true), 3);
            var0.scheduleTick(var1, var2.getBlock(), 8);
            var0.sendParticles(Particles.SCULK_SOUL, (double)var1.getX() + 0.5, (double)var1.getY() + 1.15, (double)var1.getZ() + 0.5, 2, 0.2, 0.0, 0.2, 0.0);
            var0.playSound(null, var1, SoundEffects.SCULK_CATALYST_BLOOM, SoundCategory.BLOCKS, 2.0f, 0.6f + var3.nextFloat() * 0.4f);
        }

        private void tryAwardItSpreadsAdvancement(World var0, EntityLiving var1) {
            EntityLiving var2 = var1.getLastHurtByMob();
            if (var2 instanceof EntityPlayer) {
                EntityPlayer var3 = (EntityPlayer)var2;
                DamageSource var4 = var1.getLastDamageSource() == null ? var0.damageSources().playerAttack(var3) : var1.getLastDamageSource();
                CriterionTriggers.KILL_MOB_NEAR_SCULK_CATALYST.trigger(var3, var1, var4);
            }
        }
    }
}

