/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;

public class DecoratedPotBlockEntity
extends TileEntity {
    public static final String TAG_SHERDS = "sherds";
    public Decoration decorations = Decoration.EMPTY;

    public DecoratedPotBlockEntity(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.DECORATED_POT, var0, var1);
    }

    @Override
    protected void saveAdditional(NBTTagCompound var0) {
        super.saveAdditional(var0);
        this.decorations.save(var0);
    }

    @Override
    public void load(NBTTagCompound var0) {
        super.load(var0);
        this.decorations = Decoration.load(var0);
    }

    public PacketPlayOutTileEntityData getUpdatePacket() {
        return PacketPlayOutTileEntityData.create(this);
    }

    @Override
    public NBTTagCompound getUpdateTag() {
        return this.saveWithoutMetadata();
    }

    public EnumDirection getDirection() {
        return this.getBlockState().getValue(BlockProperties.HORIZONTAL_FACING);
    }

    public Decoration getDecorations() {
        return this.decorations;
    }

    public void setFromItem(ItemStack var0) {
        this.decorations = Decoration.load(ItemBlock.getBlockEntityData(var0));
    }

    public ItemStack getItem() {
        return DecoratedPotBlockEntity.createDecoratedPotItem(this.decorations);
    }

    public static ItemStack createDecoratedPotItem(Decoration var0) {
        ItemStack var1 = Items.DECORATED_POT.getDefaultInstance();
        NBTTagCompound var2 = var0.save(new NBTTagCompound());
        ItemBlock.setBlockEntityData(var1, TileEntityTypes.DECORATED_POT, var2);
        return var1;
    }

    public /* synthetic */ Packet getUpdatePacket() {
        return this.getUpdatePacket();
    }

    public record Decoration(Item back, Item left, Item right, Item front) {
        public static final Decoration EMPTY = new Decoration(Items.BRICK, Items.BRICK, Items.BRICK, Items.BRICK);

        public NBTTagCompound save(NBTTagCompound var0) {
            if (this.equals(EMPTY)) {
                return var0;
            }
            NBTTagList var12 = new NBTTagList();
            this.sorted().forEach(var1 -> var12.add(NBTTagString.valueOf(BuiltInRegistries.ITEM.getKey((Item)var1).toString())));
            var0.put(DecoratedPotBlockEntity.TAG_SHERDS, var12);
            return var0;
        }

        public Stream<Item> sorted() {
            return Stream.of(this.back, this.left, this.right, this.front);
        }

        public static Decoration load(@Nullable NBTTagCompound var0) {
            if (var0 == null || !var0.contains(DecoratedPotBlockEntity.TAG_SHERDS, 9)) {
                return EMPTY;
            }
            NBTTagList var1 = var0.getList(DecoratedPotBlockEntity.TAG_SHERDS, 8);
            return new Decoration(Decoration.itemFromTag(var1, 0), Decoration.itemFromTag(var1, 1), Decoration.itemFromTag(var1, 2), Decoration.itemFromTag(var1, 3));
        }

        private static Item itemFromTag(NBTTagList var0, int var1) {
            if (var1 >= var0.size()) {
                return Items.BRICK;
            }
            NBTBase var2 = var0.get(var1);
            return BuiltInRegistries.ITEM.get(MinecraftKey.tryParse(var2.getAsString()));
        }
    }
}

