/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.Vec3D;
import org.slf4j.Logger;

public class BrushableBlockEntity
extends TileEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String LOOT_TABLE_TAG = "LootTable";
    private static final String LOOT_TABLE_SEED_TAG = "LootTableSeed";
    private static final String HIT_DIRECTION_TAG = "hit_direction";
    private static final String ITEM_TAG = "item";
    private static final int BRUSH_COOLDOWN_TICKS = 10;
    private static final int BRUSH_RESET_TICKS = 40;
    private static final int REQUIRED_BRUSHES_TO_BREAK = 10;
    private int brushCount;
    private long brushCountResetsAtTick;
    private long coolDownEndsAtTick;
    public ItemStack item = ItemStack.EMPTY;
    @Nullable
    private EnumDirection hitDirection;
    @Nullable
    public MinecraftKey lootTable;
    public long lootTableSeed;

    public BrushableBlockEntity(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.BRUSHABLE_BLOCK, var0, var1);
    }

    public boolean brush(long var0, EntityHuman var2, EnumDirection var3) {
        if (this.hitDirection == null) {
            this.hitDirection = var3;
        }
        this.brushCountResetsAtTick = var0 + 40L;
        if (var0 < this.coolDownEndsAtTick || !(this.level instanceof WorldServer)) {
            return false;
        }
        this.coolDownEndsAtTick = var0 + 10L;
        this.unpackLootTable(var2);
        int var4 = this.getCompletionState();
        if (++this.brushCount >= 10) {
            this.brushingCompleted(var2);
            return true;
        }
        this.level.scheduleTick(this.getBlockPos(), this.getBlockState().getBlock(), 40);
        int var5 = this.getCompletionState();
        if (var4 != var5) {
            IBlockData var6 = this.getBlockState();
            IBlockData var7 = (IBlockData)var6.setValue(BlockProperties.DUSTED, var5);
            this.level.setBlock(this.getBlockPos(), var7, 3);
        }
        return false;
    }

    public void unpackLootTable(EntityHuman var0) {
        Object var2;
        if (this.lootTable == null || this.level == null || this.level.isClientSide() || this.level.getServer() == null) {
            return;
        }
        LootTable var1 = this.level.getServer().getLootData().getLootTable(this.lootTable);
        if (var0 instanceof EntityPlayer) {
            var2 = (EntityPlayer)var0;
            CriterionTriggers.GENERATE_LOOT.trigger((EntityPlayer)var2, this.lootTable);
        }
        var2 = new LootParams.a((WorldServer)this.level).withParameter(LootContextParameters.ORIGIN, Vec3D.atCenterOf(this.worldPosition)).withLuck(var0.getLuck()).withParameter(LootContextParameters.THIS_ENTITY, var0).create(LootContextParameterSets.CHEST);
        ObjectArrayList<ItemStack> var3 = var1.getRandomItems((LootParams)var2, this.lootTableSeed);
        this.item = switch (var3.size()) {
            case 0 -> ItemStack.EMPTY;
            case 1 -> (ItemStack)var3.get(0);
            default -> {
                LOGGER.warn("Expected max 1 loot from loot table " + this.lootTable + " got " + var3.size());
                yield (ItemStack)var3.get(0);
            }
        };
        this.lootTable = null;
        this.setChanged();
    }

    private void brushingCompleted(EntityHuman var0) {
        Block var3;
        if (this.level == null || this.level.getServer() == null) {
            return;
        }
        this.dropContent(var0);
        IBlockData var1 = this.getBlockState();
        this.level.levelEvent(3008, this.getBlockPos(), Block.getId(var1));
        Block var2 = this.getBlockState().getBlock();
        if (var2 instanceof BrushableBlock) {
            BrushableBlock var4 = (BrushableBlock)var2;
            var3 = var4.getTurnsInto();
        } else {
            var3 = Blocks.AIR;
        }
        this.level.setBlock(this.worldPosition, var3.defaultBlockState(), 3);
    }

    private void dropContent(EntityHuman var0) {
        if (this.level == null || this.level.getServer() == null) {
            return;
        }
        this.unpackLootTable(var0);
        if (!this.item.isEmpty()) {
            double var1 = EntityTypes.ITEM.getWidth();
            double var3 = 1.0 - var1;
            double var5 = var1 / 2.0;
            EnumDirection var7 = Objects.requireNonNullElse(this.hitDirection, EnumDirection.UP);
            BlockPosition var8 = this.worldPosition.relative(var7, 1);
            double var9 = (double)var8.getX() + 0.5 * var3 + var5;
            double var11 = (double)var8.getY() + 0.5 + (double)(EntityTypes.ITEM.getHeight() / 2.0f);
            double var13 = (double)var8.getZ() + 0.5 * var3 + var5;
            EntityItem var15 = new EntityItem(this.level, var9, var11, var13, this.item.split(this.level.random.nextInt(21) + 10));
            var15.setDeltaMovement(Vec3D.ZERO);
            this.level.addFreshEntity(var15);
            this.item = ItemStack.EMPTY;
        }
    }

    public void checkReset() {
        if (this.level == null) {
            return;
        }
        if (this.brushCount != 0 && this.level.getGameTime() >= this.brushCountResetsAtTick) {
            int var0 = this.getCompletionState();
            this.brushCount = Math.max(0, this.brushCount - 2);
            int var1 = this.getCompletionState();
            if (var0 != var1) {
                this.level.setBlock(this.getBlockPos(), (IBlockData)this.getBlockState().setValue(BlockProperties.DUSTED, var1), 3);
            }
            int var2 = 4;
            this.brushCountResetsAtTick = this.level.getGameTime() + 4L;
        }
        if (this.brushCount == 0) {
            this.hitDirection = null;
            this.brushCountResetsAtTick = 0L;
            this.coolDownEndsAtTick = 0L;
        } else {
            this.level.scheduleTick(this.getBlockPos(), this.getBlockState().getBlock(), (int)(this.brushCountResetsAtTick - this.level.getGameTime()));
        }
    }

    private boolean tryLoadLootTable(NBTTagCompound var0) {
        if (var0.contains(LOOT_TABLE_TAG, 8)) {
            this.lootTable = new MinecraftKey(var0.getString(LOOT_TABLE_TAG));
            this.lootTableSeed = var0.getLong(LOOT_TABLE_SEED_TAG);
            return true;
        }
        return false;
    }

    private boolean trySaveLootTable(NBTTagCompound var0) {
        if (this.lootTable == null) {
            return false;
        }
        var0.putString(LOOT_TABLE_TAG, this.lootTable.toString());
        if (this.lootTableSeed != 0L) {
            var0.putLong(LOOT_TABLE_SEED_TAG, this.lootTableSeed);
        }
        return true;
    }

    @Override
    public NBTTagCompound getUpdateTag() {
        NBTTagCompound var0 = super.getUpdateTag();
        if (this.hitDirection != null) {
            var0.putInt(HIT_DIRECTION_TAG, this.hitDirection.ordinal());
        }
        var0.put(ITEM_TAG, this.item.save(new NBTTagCompound()));
        return var0;
    }

    public PacketPlayOutTileEntityData getUpdatePacket() {
        return PacketPlayOutTileEntityData.create(this);
    }

    @Override
    public void load(NBTTagCompound var0) {
        if (!this.tryLoadLootTable(var0) && var0.contains(ITEM_TAG)) {
            this.item = ItemStack.of(var0.getCompound(ITEM_TAG));
        }
        if (var0.contains(HIT_DIRECTION_TAG)) {
            this.hitDirection = EnumDirection.values()[var0.getInt(HIT_DIRECTION_TAG)];
        }
    }

    @Override
    protected void saveAdditional(NBTTagCompound var0) {
        if (!this.trySaveLootTable(var0)) {
            var0.put(ITEM_TAG, this.item.save(new NBTTagCompound()));
        }
    }

    public void setLootTable(MinecraftKey var0, long var1) {
        this.lootTable = var0;
        this.lootTableSeed = var1;
    }

    private int getCompletionState() {
        if (this.brushCount == 0) {
            return 0;
        }
        if (this.brushCount < 3) {
            return 1;
        }
        if (this.brushCount < 6) {
            return 2;
        }
        return 3;
    }

    @Nullable
    public EnumDirection getHitDirection() {
        return this.hitDirection;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public /* synthetic */ Packet getUpdatePacket() {
        return this.getUpdatePacket();
    }
}

