/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockSign;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumBlockSupport;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.HangingSignBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyWood;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class WallHangingSignBlock
extends BlockSign {
    public static final BlockStateDirection FACING = BlockFacingHorizontal.FACING;
    public static final VoxelShape PLANK_NORTHSOUTH = Block.box(0.0, 14.0, 6.0, 16.0, 16.0, 10.0);
    public static final VoxelShape PLANK_EASTWEST = Block.box(6.0, 14.0, 0.0, 10.0, 16.0, 16.0);
    public static final VoxelShape SHAPE_NORTHSOUTH = VoxelShapes.or(PLANK_NORTHSOUTH, Block.box(1.0, 0.0, 7.0, 15.0, 10.0, 9.0));
    public static final VoxelShape SHAPE_EASTWEST = VoxelShapes.or(PLANK_EASTWEST, Block.box(7.0, 0.0, 1.0, 9.0, 10.0, 15.0));
    private static final Map<EnumDirection, VoxelShape> AABBS = Maps.newEnumMap((Map)ImmutableMap.of((Object)EnumDirection.NORTH, (Object)SHAPE_NORTHSOUTH, (Object)EnumDirection.SOUTH, (Object)SHAPE_NORTHSOUTH, (Object)EnumDirection.EAST, (Object)SHAPE_EASTWEST, (Object)EnumDirection.WEST, (Object)SHAPE_EASTWEST));

    public WallHangingSignBlock(BlockBase.Info var0, BlockPropertyWood var1) {
        super(var0.sound(var1.hangingSignSoundType()), var1);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.NORTH)).setValue(WATERLOGGED, false));
    }

    @Override
    public EnumInteractionResult use(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, EnumHand var4, MovingObjectPositionBlock var5) {
        ItemStack var7;
        TileEntitySign var6;
        TileEntity tileEntity = var1.getBlockEntity(var2);
        if (tileEntity instanceof TileEntitySign && this.shouldTryToChainAnotherHangingSign(var0, var3, var5, var6 = (TileEntitySign)tileEntity, var7 = var3.getItemInHand(var4))) {
            return EnumInteractionResult.PASS;
        }
        return super.use(var0, var1, var2, var3, var4, var5);
    }

    private boolean shouldTryToChainAnotherHangingSign(IBlockData var0, EntityHuman var1, MovingObjectPositionBlock var2, TileEntitySign var3, ItemStack var4) {
        return !var3.canExecuteClickCommands(var3.isFacingFrontText(var1), var1) && var4.getItem() instanceof HangingSignItem && !this.isHittingEditableSide(var2, var0);
    }

    private boolean isHittingEditableSide(MovingObjectPositionBlock var0, IBlockData var1) {
        return var0.getDirection().getAxis() == var1.getValue(FACING).getAxis();
    }

    @Override
    public String getDescriptionId() {
        return this.asItem().getDescriptionId();
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return AABBS.get(var0.getValue(FACING));
    }

    @Override
    public VoxelShape getBlockSupportShape(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return this.getShape(var0, var1, var2, VoxelShapeCollision.empty());
    }

    @Override
    public VoxelShape getCollisionShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        switch (var0.getValue(FACING)) {
            case EAST: 
            case WEST: {
                return PLANK_EASTWEST;
            }
        }
        return PLANK_NORTHSOUTH;
    }

    public boolean canPlace(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        EnumDirection var3 = var0.getValue(FACING).getClockWise();
        EnumDirection var4 = var0.getValue(FACING).getCounterClockWise();
        return this.canAttachTo(var1, var0, var2.relative(var3), var4) || this.canAttachTo(var1, var0, var2.relative(var4), var3);
    }

    public boolean canAttachTo(IWorldReader var0, IBlockData var1, BlockPosition var2, EnumDirection var3) {
        IBlockData var4 = var0.getBlockState(var2);
        if (var4.is(TagsBlock.WALL_HANGING_SIGNS)) {
            return var4.getValue(FACING).getAxis().test(var1.getValue(FACING));
        }
        return var4.isFaceSturdy(var0, var2, var3, EnumBlockSupport.FULL);
    }

    @Override
    @Nullable
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        IBlockData var1 = this.defaultBlockState();
        Fluid var2 = var0.getLevel().getFluidState(var0.getClickedPos());
        World var3 = var0.getLevel();
        BlockPosition var4 = var0.getClickedPos();
        for (EnumDirection var8 : var0.getNearestLookingDirections()) {
            EnumDirection var9;
            if (!var8.getAxis().isHorizontal() || var8.getAxis().test(var0.getClickedFace()) || !(var1 = (IBlockData)var1.setValue(FACING, var9 = var8.getOpposite())).canSurvive(var3, var4) || !this.canPlace(var1, var3, var4)) continue;
            return (IBlockData)var1.setValue(WATERLOGGED, var2.getType() == FluidTypes.WATER);
        }
        return null;
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (var1.getAxis() == var0.getValue(FACING).getClockWise().getAxis() && !var0.canSurvive(var3, var4)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    @Override
    public float getYRotationDegrees(IBlockData var0) {
        return var0.getValue(FACING).toYRot();
    }

    @Override
    public IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return (IBlockData)var0.setValue(FACING, var1.rotate(var0.getValue(FACING)));
    }

    @Override
    public IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        return var0.rotate(var1.getRotation(var0.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(FACING, WATERLOGGED);
    }

    @Override
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new HangingSignBlockEntity(var0, var1);
    }

    @Override
    public boolean isPathfindable(IBlockData var0, IBlockAccess var1, BlockPosition var2, PathMode var3) {
        return false;
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> getTicker(World var0, IBlockData var1, TileEntityTypes<T> var2) {
        return WallHangingSignBlock.createTickerHelper(var2, TileEntityTypes.HANGING_SIGN, TileEntitySign::tick);
    }
}

