/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.level.IMaterial;

public interface SuspiciousEffectHolder {
    public List<a> getSuspiciousEffects();

    public static List<SuspiciousEffectHolder> getAllEffectHolders() {
        return BuiltInRegistries.ITEM.stream().map(SuspiciousEffectHolder::tryGet).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    public static SuspiciousEffectHolder tryGet(IMaterial var0) {
        Object var1;
        IMaterial iMaterial = var0.asItem();
        if (iMaterial instanceof ItemBlock && (iMaterial = ((ItemBlock)(var1 = (ItemBlock)iMaterial)).getBlock()) instanceof SuspiciousEffectHolder) {
            SuspiciousEffectHolder var2 = (SuspiciousEffectHolder)((Object)iMaterial);
            return var2;
        }
        Item item = var0.asItem();
        if (item instanceof SuspiciousEffectHolder) {
            var1 = (SuspiciousEffectHolder)((Object)item);
            return var1;
        }
        return null;
    }

    public record a(MobEffectList effect, int duration) {
        public static final Codec<a> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)BuiltInRegistries.MOB_EFFECT.byNameCodec().fieldOf("id").forGetter(a::effect), (App)Codec.INT.optionalFieldOf("duration", (Object)160).forGetter(a::duration)).apply((Applicative)var0, a::new));
        public static final Codec<List<a>> LIST_CODEC = CODEC.listOf();

        public MobEffect createEffectInstance() {
            return new MobEffect(this.effect, this.duration);
        }
    }
}

