/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.function.BiFunction;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockPlant;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class PinkPetalsBlock
extends BlockPlant
implements IBlockFragilePlantElement {
    public static final int MIN_FLOWERS = 1;
    public static final int MAX_FLOWERS = 4;
    public static final BlockStateDirection FACING = BlockProperties.HORIZONTAL_FACING;
    public static final BlockStateInteger AMOUNT = BlockProperties.FLOWER_AMOUNT;
    private static final BiFunction<EnumDirection, Integer, VoxelShape> SHAPE_BY_PROPERTIES = SystemUtils.memoize((var0, var1) -> {
        VoxelShape[] var2 = new VoxelShape[]{Block.box(8.0, 0.0, 8.0, 16.0, 3.0, 16.0), Block.box(8.0, 0.0, 0.0, 16.0, 3.0, 8.0), Block.box(0.0, 0.0, 0.0, 8.0, 3.0, 8.0), Block.box(0.0, 0.0, 8.0, 8.0, 3.0, 16.0)};
        VoxelShape var3 = VoxelShapes.empty();
        for (int var4 = 0; var4 < var1; ++var4) {
            int var5 = Math.floorMod(var4 - var0.get2DDataValue(), 4);
            var3 = VoxelShapes.or(var3, var2[var5]);
        }
        return var3.singleEncompassing();
    });

    protected PinkPetalsBlock(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.NORTH)).setValue(AMOUNT, 1));
    }

    @Override
    public IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return (IBlockData)var0.setValue(FACING, var1.rotate(var0.getValue(FACING)));
    }

    @Override
    public IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        return var0.rotate(var1.getRotation(var0.getValue(FACING)));
    }

    @Override
    public boolean canBeReplaced(IBlockData var0, BlockActionContext var1) {
        if (!var1.isSecondaryUseActive() && var1.getItemInHand().is(this.asItem()) && var0.getValue(AMOUNT) < 4) {
            return true;
        }
        return super.canBeReplaced(var0, var1);
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPE_BY_PROPERTIES.apply(var0.getValue(FACING), var0.getValue(AMOUNT));
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        IBlockData var1 = var0.getLevel().getBlockState(var0.getClickedPos());
        if (var1.is(this)) {
            return (IBlockData)var1.setValue(AMOUNT, Math.min(4, var1.getValue(AMOUNT) + 1));
        }
        return (IBlockData)this.defaultBlockState().setValue(FACING, var0.getHorizontalDirection().getOpposite());
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(FACING, AMOUNT);
    }

    @Override
    public boolean isValidBonemealTarget(IWorldReader var0, BlockPosition var1, IBlockData var2) {
        return true;
    }

    @Override
    public boolean isBonemealSuccess(World var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        return true;
    }

    @Override
    public void performBonemeal(WorldServer var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        int var4 = var3.getValue(AMOUNT);
        if (var4 < 4) {
            var0.setBlock(var2, (IBlockData)var3.setValue(AMOUNT, var4 + 1), 2);
        } else {
            PinkPetalsBlock.popResource((World)var0, var2, new ItemStack(this));
        }
    }
}

