/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class DecoratedPotBlock
extends BlockTileEntity
implements IBlockWaterlogged {
    public static final MinecraftKey SHERDS_DYNAMIC_DROP_ID = new MinecraftKey("sherds");
    private static final VoxelShape BOUNDING_BOX = Block.box(1.0, 0.0, 1.0, 15.0, 16.0, 15.0);
    private static final BlockStateDirection HORIZONTAL_FACING = BlockProperties.HORIZONTAL_FACING;
    private static final BlockStateBoolean CRACKED = BlockProperties.CRACKED;
    private static final BlockStateBoolean WATERLOGGED = BlockProperties.WATERLOGGED;

    protected DecoratedPotBlock(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(HORIZONTAL_FACING, EnumDirection.NORTH)).setValue(WATERLOGGED, false)).setValue(CRACKED, false));
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var3.scheduleTick(var4, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var3));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        Fluid var1 = var0.getLevel().getFluidState(var0.getClickedPos());
        return (IBlockData)((IBlockData)((IBlockData)this.defaultBlockState().setValue(HORIZONTAL_FACING, var0.getHorizontalDirection())).setValue(WATERLOGGED, var1.getType() == FluidTypes.WATER)).setValue(CRACKED, false);
    }

    @Override
    public void setPlacedBy(World var0, BlockPosition var12, IBlockData var2, @Nullable EntityLiving var3, ItemStack var4) {
        if (var0.isClientSide) {
            var0.getBlockEntity(var12, TileEntityTypes.DECORATED_POT).ifPresent(var1 -> var1.setFromItem(var4));
        }
    }

    @Override
    public boolean isPathfindable(IBlockData var0, IBlockAccess var1, BlockPosition var2, PathMode var3) {
        return false;
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return BOUNDING_BOX;
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(HORIZONTAL_FACING, WATERLOGGED, CRACKED);
    }

    @Override
    @Nullable
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new DecoratedPotBlockEntity(var0, var1);
    }

    @Override
    public List<ItemStack> getDrops(IBlockData var0, LootParams.a var12) {
        TileEntity var2 = var12.getOptionalParameter(LootContextParameters.BLOCK_ENTITY);
        if (var2 instanceof DecoratedPotBlockEntity) {
            DecoratedPotBlockEntity var3 = (DecoratedPotBlockEntity)var2;
            var12.withDynamicDrop(SHERDS_DYNAMIC_DROP_ID, var1 -> var3.getDecorations().sorted().map(Item::getDefaultInstance).forEach(var1));
        }
        return super.getDrops(var0, var12);
    }

    @Override
    public void playerWillDestroy(World var0, BlockPosition var1, IBlockData var2, EntityHuman var3) {
        ItemStack var4 = var3.getMainHandItem();
        IBlockData var5 = var2;
        if (var4.is(TagsItem.BREAKS_DECORATED_POTS) && !EnchantmentManager.hasSilkTouch(var4)) {
            var5 = (IBlockData)var2.setValue(CRACKED, true);
            var0.setBlock(var1, var5, 4);
        }
        super.playerWillDestroy(var0, var1, var5, var3);
    }

    @Override
    public Fluid getFluidState(IBlockData var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return FluidTypes.WATER.getSource(false);
        }
        return super.getFluidState(var0);
    }

    @Override
    public SoundEffectType getSoundType(IBlockData var0) {
        if (var0.getValue(CRACKED).booleanValue()) {
            return SoundEffectType.DECORATED_POT_CRACKED;
        }
        return SoundEffectType.DECORATED_POT;
    }

    @Override
    public void appendHoverText(ItemStack var0, @Nullable IBlockAccess var12, List<IChatBaseComponent> var2, TooltipFlag var3) {
        super.appendHoverText(var0, var12, var2, var3);
        DecoratedPotBlockEntity.Decoration var4 = DecoratedPotBlockEntity.Decoration.load(ItemBlock.getBlockEntityData(var0));
        if (var4.equals(DecoratedPotBlockEntity.Decoration.EMPTY)) {
            return;
        }
        var2.add(CommonComponents.EMPTY);
        Stream.of(var4.front(), var4.left(), var4.right(), var4.back()).forEach(var1 -> var2.add(new ItemStack((IMaterial)var1, 1).getHoverName().plainCopy().withStyle(EnumChatFormat.GRAY)));
    }

    @Override
    public ItemStack getCloneItemStack(IBlockAccess var0, BlockPosition var1, IBlockData var2) {
        TileEntity tileEntity = var0.getBlockEntity(var1);
        if (tileEntity instanceof DecoratedPotBlockEntity) {
            DecoratedPotBlockEntity var3 = (DecoratedPotBlockEntity)tileEntity;
            return var3.getItem();
        }
        return super.getCloneItemStack(var0, var1, var2);
    }
}

