/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockHalfTransparent;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;

public class BlockSlime
extends BlockHalfTransparent {
    public BlockSlime(BlockBase.Info var0) {
        super(var0);
    }

    @Override
    public void fallOn(World var0, IBlockData var1, BlockPosition var2, Entity var3, float var4) {
        if (var3.isSuppressingBounce()) {
            super.fallOn(var0, var1, var2, var3, var4);
        } else {
            var3.causeFallDamage(var4, 0.0f, var0.damageSources().fall());
        }
    }

    @Override
    public void updateEntityAfterFallOn(IBlockAccess var0, Entity var1) {
        if (var1.isSuppressingBounce()) {
            super.updateEntityAfterFallOn(var0, var1);
        } else {
            this.bounceUp(var1);
        }
    }

    private void bounceUp(Entity var0) {
        Vec3D var1 = var0.getDeltaMovement();
        if (var1.y < 0.0) {
            double var2 = var0 instanceof EntityLiving ? 1.0 : 0.8;
            var0.setDeltaMovement(var1.x, -var1.y * var2, var1.z);
        }
    }

    @Override
    public void stepOn(World var0, BlockPosition var1, IBlockData var2, Entity var3) {
        double var4 = Math.abs(var3.getDeltaMovement().y);
        if (var4 < 0.1 && !var3.isSteppingCarefully()) {
            double var6 = 0.4 + var4 * 0.2;
            var3.setDeltaMovement(var3.getDeltaMovement().multiply(var6, 1.0, var6));
        }
        super.stepOn(var0, var1, var2, var3);
    }
}

