/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleParamRedstone;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTorch;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;

public class BlockRedstoneTorch
extends BlockTorch {
    public static final BlockStateBoolean LIT = BlockProperties.LIT;
    private static final Map<IBlockAccess, List<RedstoneUpdateInfo>> RECENT_TOGGLES = new WeakHashMap<IBlockAccess, List<RedstoneUpdateInfo>>();
    public static final int RECENT_TOGGLE_TIMER = 60;
    public static final int MAX_RECENT_TOGGLES = 8;
    public static final int RESTART_DELAY = 160;
    private static final int TOGGLE_DELAY = 2;

    protected BlockRedstoneTorch(BlockBase.Info var0) {
        super(var0, ParticleParamRedstone.REDSTONE);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(LIT, true));
    }

    @Override
    public void onPlace(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        for (EnumDirection var8 : EnumDirection.values()) {
            var1.updateNeighborsAt(var2.relative(var8), this);
        }
    }

    @Override
    public void onRemove(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (var4) {
            return;
        }
        for (EnumDirection var8 : EnumDirection.values()) {
            var1.updateNeighborsAt(var2.relative(var8), this);
        }
    }

    @Override
    public int getSignal(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
        if (var0.getValue(LIT).booleanValue() && EnumDirection.UP != var3) {
            return 15;
        }
        return 0;
    }

    protected boolean hasNeighborSignal(World var0, BlockPosition var1, IBlockData var2) {
        return var0.hasSignal(var1.below(), EnumDirection.DOWN);
    }

    @Override
    public void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        boolean var4 = this.hasNeighborSignal(var1, var2, var0);
        List<RedstoneUpdateInfo> var5 = RECENT_TOGGLES.get(var1);
        while (var5 != null && !var5.isEmpty() && var1.getGameTime() - var5.get((int)0).when > 60L) {
            var5.remove(0);
        }
        if (var0.getValue(LIT).booleanValue()) {
            if (var4) {
                var1.setBlock(var2, (IBlockData)var0.setValue(LIT, false), 3);
                if (BlockRedstoneTorch.isToggledTooFrequently(var1, var2, true)) {
                    var1.levelEvent(1502, var2, 0);
                    var1.scheduleTick(var2, var1.getBlockState(var2).getBlock(), 160);
                }
            }
        } else if (!var4 && !BlockRedstoneTorch.isToggledTooFrequently(var1, var2, false)) {
            var1.setBlock(var2, (IBlockData)var0.setValue(LIT, true), 3);
        }
    }

    @Override
    public void neighborChanged(IBlockData var0, World var1, BlockPosition var2, Block var3, BlockPosition var4, boolean var5) {
        if (var0.getValue(LIT).booleanValue() == this.hasNeighborSignal(var1, var2, var0) && !var1.getBlockTicks().willTickThisTick(var2, this)) {
            var1.scheduleTick(var2, this, 2);
        }
    }

    @Override
    public int getDirectSignal(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
        if (var3 == EnumDirection.DOWN) {
            return var0.getSignal(var1, var2, var3);
        }
        return 0;
    }

    @Override
    public boolean isSignalSource(IBlockData var0) {
        return true;
    }

    @Override
    public void animateTick(IBlockData var0, World var1, BlockPosition var2, RandomSource var3) {
        if (!var0.getValue(LIT).booleanValue()) {
            return;
        }
        double var4 = (double)var2.getX() + 0.5 + (var3.nextDouble() - 0.5) * 0.2;
        double var6 = (double)var2.getY() + 0.7 + (var3.nextDouble() - 0.5) * 0.2;
        double var8 = (double)var2.getZ() + 0.5 + (var3.nextDouble() - 0.5) * 0.2;
        var1.addParticle(this.flameParticle, var4, var6, var8, 0.0, 0.0, 0.0);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(LIT);
    }

    private static boolean isToggledTooFrequently(World var02, BlockPosition var1, boolean var2) {
        List var3 = RECENT_TOGGLES.computeIfAbsent(var02, var0 -> Lists.newArrayList());
        if (var2) {
            var3.add(new RedstoneUpdateInfo(var1.immutable(), var02.getGameTime()));
        }
        int var4 = 0;
        for (RedstoneUpdateInfo var6 : var3) {
            if (!var6.pos.equals(var1) || ++var4 < 8) continue;
            return true;
        }
        return false;
    }

    public static class RedstoneUpdateInfo {
        final BlockPosition pos;
        final long when;

        public RedstoneUpdateInfo(BlockPosition var0, long var1) {
            this.pos = var0;
            this.when = var1;
        }
    }
}

