/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.crafting.RecipeCampfire;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityCampfire;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockCampfire
extends BlockTileEntity
implements IBlockWaterlogged {
    protected static final VoxelShape SHAPE = Block.box(0.0, 0.0, 0.0, 16.0, 7.0, 16.0);
    public static final BlockStateBoolean LIT = BlockProperties.LIT;
    public static final BlockStateBoolean SIGNAL_FIRE = BlockProperties.SIGNAL_FIRE;
    public static final BlockStateBoolean WATERLOGGED = BlockProperties.WATERLOGGED;
    public static final BlockStateDirection FACING = BlockProperties.HORIZONTAL_FACING;
    private static final VoxelShape VIRTUAL_FENCE_POST = Block.box(6.0, 0.0, 6.0, 10.0, 16.0, 10.0);
    private static final int SMOKE_DISTANCE = 5;
    private final boolean spawnParticles;
    private final int fireDamage;

    public BlockCampfire(boolean var0, int var1, BlockBase.Info var2) {
        super(var2);
        this.spawnParticles = var0;
        this.fireDamage = var1;
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(LIT, true)).setValue(SIGNAL_FIRE, false)).setValue(WATERLOGGED, false)).setValue(FACING, EnumDirection.NORTH));
    }

    @Override
    public EnumInteractionResult use(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, EnumHand var4, MovingObjectPositionBlock var5) {
        ItemStack var8;
        TileEntityCampfire var7;
        Optional<RecipeHolder<RecipeCampfire>> var9;
        TileEntity var6 = var1.getBlockEntity(var2);
        if (var6 instanceof TileEntityCampfire && (var9 = (var7 = (TileEntityCampfire)var6).getCookableRecipe(var8 = var3.getItemInHand(var4))).isPresent()) {
            if (!var1.isClientSide && var7.placeFood(var3, var3.getAbilities().instabuild ? var8.copy() : var8, var9.get().value().getCookingTime())) {
                var3.awardStat(StatisticList.INTERACT_WITH_CAMPFIRE);
                return EnumInteractionResult.SUCCESS;
            }
            return EnumInteractionResult.CONSUME;
        }
        return EnumInteractionResult.PASS;
    }

    @Override
    public void entityInside(IBlockData var0, World var1, BlockPosition var2, Entity var3) {
        if (var0.getValue(LIT).booleanValue() && var3 instanceof EntityLiving && !EnchantmentManager.hasFrostWalker((EntityLiving)var3)) {
            var3.hurt(var1.damageSources().inFire(), this.fireDamage);
        }
        super.entityInside(var0, var1, var2, var3);
    }

    @Override
    public void onRemove(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (var0.is(var3.getBlock())) {
            return;
        }
        TileEntity var5 = var1.getBlockEntity(var2);
        if (var5 instanceof TileEntityCampfire) {
            InventoryUtils.dropContents(var1, var2, ((TileEntityCampfire)var5).getItems());
        }
        super.onRemove(var0, var1, var2, var3, var4);
    }

    @Override
    @Nullable
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        BlockPosition var2;
        World var1 = var0.getLevel();
        boolean var3 = var1.getFluidState(var2 = var0.getClickedPos()).getType() == FluidTypes.WATER;
        return (IBlockData)((IBlockData)((IBlockData)((IBlockData)this.defaultBlockState().setValue(WATERLOGGED, var3)).setValue(SIGNAL_FIRE, this.isSmokeSource(var1.getBlockState(var2.below())))).setValue(LIT, !var3)).setValue(FACING, var0.getHorizontalDirection());
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var3.scheduleTick(var4, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var3));
        }
        if (var1 == EnumDirection.DOWN) {
            return (IBlockData)var0.setValue(SIGNAL_FIRE, this.isSmokeSource(var2));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    private boolean isSmokeSource(IBlockData var0) {
        return var0.is(Blocks.HAY_BLOCK);
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPE;
    }

    @Override
    public EnumRenderType getRenderShape(IBlockData var0) {
        return EnumRenderType.MODEL;
    }

    @Override
    public void animateTick(IBlockData var0, World var1, BlockPosition var2, RandomSource var3) {
        if (!var0.getValue(LIT).booleanValue()) {
            return;
        }
        if (var3.nextInt(10) == 0) {
            var1.playLocalSound((double)var2.getX() + 0.5, (double)var2.getY() + 0.5, (double)var2.getZ() + 0.5, SoundEffects.CAMPFIRE_CRACKLE, SoundCategory.BLOCKS, 0.5f + var3.nextFloat(), var3.nextFloat() * 0.7f + 0.6f, false);
        }
        if (this.spawnParticles && var3.nextInt(5) == 0) {
            for (int var4 = 0; var4 < var3.nextInt(1) + 1; ++var4) {
                var1.addParticle(Particles.LAVA, (double)var2.getX() + 0.5, (double)var2.getY() + 0.5, (double)var2.getZ() + 0.5, var3.nextFloat() / 2.0f, 5.0E-5, var3.nextFloat() / 2.0f);
            }
        }
    }

    public static void dowse(@Nullable Entity var0, GeneratorAccess var1, BlockPosition var2, IBlockData var3) {
        TileEntity var4;
        if (var1.isClientSide()) {
            for (int var42 = 0; var42 < 20; ++var42) {
                BlockCampfire.makeParticles((World)var1, var2, var3.getValue(SIGNAL_FIRE), true);
            }
        }
        if ((var4 = var1.getBlockEntity(var2)) instanceof TileEntityCampfire) {
            ((TileEntityCampfire)var4).dowse();
        }
        var1.gameEvent(var0, GameEvent.BLOCK_CHANGE, var2);
    }

    @Override
    public boolean placeLiquid(GeneratorAccess var0, BlockPosition var1, IBlockData var2, Fluid var3) {
        if (!var2.getValue(BlockProperties.WATERLOGGED).booleanValue() && var3.getType() == FluidTypes.WATER) {
            boolean var4 = var2.getValue(LIT);
            if (var4) {
                if (!var0.isClientSide()) {
                    var0.playSound(null, var1, SoundEffects.GENERIC_EXTINGUISH_FIRE, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                BlockCampfire.dowse(null, var0, var1, var2);
            }
            var0.setBlock(var1, (IBlockData)((IBlockData)var2.setValue(WATERLOGGED, true)).setValue(LIT, false), 3);
            var0.scheduleTick(var1, var3.getType(), var3.getType().getTickDelay(var0));
            return true;
        }
        return false;
    }

    @Override
    public void onProjectileHit(World var0, IBlockData var1, MovingObjectPositionBlock var2, IProjectile var3) {
        BlockPosition var4 = var2.getBlockPos();
        if (!var0.isClientSide && var3.isOnFire() && var3.mayInteract(var0, var4) && !var1.getValue(LIT).booleanValue() && !var1.getValue(WATERLOGGED).booleanValue()) {
            var0.setBlock(var4, (IBlockData)var1.setValue(BlockProperties.LIT, true), 11);
        }
    }

    public static void makeParticles(World var0, BlockPosition var1, boolean var2, boolean var3) {
        RandomSource var4 = var0.getRandom();
        ParticleType var5 = var2 ? Particles.CAMPFIRE_SIGNAL_SMOKE : Particles.CAMPFIRE_COSY_SMOKE;
        var0.addAlwaysVisibleParticle(var5, true, (double)var1.getX() + 0.5 + var4.nextDouble() / 3.0 * (double)(var4.nextBoolean() ? 1 : -1), (double)var1.getY() + var4.nextDouble() + var4.nextDouble(), (double)var1.getZ() + 0.5 + var4.nextDouble() / 3.0 * (double)(var4.nextBoolean() ? 1 : -1), 0.0, 0.07, 0.0);
        if (var3) {
            var0.addParticle(Particles.SMOKE, (double)var1.getX() + 0.5 + var4.nextDouble() / 4.0 * (double)(var4.nextBoolean() ? 1 : -1), (double)var1.getY() + 0.4, (double)var1.getZ() + 0.5 + var4.nextDouble() / 4.0 * (double)(var4.nextBoolean() ? 1 : -1), 0.0, 0.005, 0.0);
        }
    }

    public static boolean isSmokeyPos(World var0, BlockPosition var1) {
        for (int var2 = 1; var2 <= 5; ++var2) {
            BlockPosition var3 = var1.below(var2);
            IBlockData var4 = var0.getBlockState(var3);
            if (BlockCampfire.isLitCampfire(var4)) {
                return true;
            }
            boolean var5 = VoxelShapes.joinIsNotEmpty(VIRTUAL_FENCE_POST, var4.getCollisionShape(var0, var1, VoxelShapeCollision.empty()), OperatorBoolean.AND);
            if (!var5) continue;
            IBlockData var6 = var0.getBlockState(var3.below());
            return BlockCampfire.isLitCampfire(var6);
        }
        return false;
    }

    public static boolean isLitCampfire(IBlockData var0) {
        return var0.hasProperty(LIT) && var0.is(TagsBlock.CAMPFIRES) && var0.getValue(LIT) != false;
    }

    @Override
    public Fluid getFluidState(IBlockData var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return FluidTypes.WATER.getSource(false);
        }
        return super.getFluidState(var0);
    }

    @Override
    public IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return (IBlockData)var0.setValue(FACING, var1.rotate(var0.getValue(FACING)));
    }

    @Override
    public IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        return var0.rotate(var1.getRotation(var0.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(LIT, SIGNAL_FIRE, WATERLOGGED, FACING);
    }

    @Override
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new TileEntityCampfire(var0, var1);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> getTicker(World var0, IBlockData var1, TileEntityTypes<T> var2) {
        if (var0.isClientSide) {
            if (var1.getValue(LIT).booleanValue()) {
                return BlockCampfire.createTickerHelper(var2, TileEntityTypes.CAMPFIRE, TileEntityCampfire::particleTick);
            }
        } else {
            if (var1.getValue(LIT).booleanValue()) {
                return BlockCampfire.createTickerHelper(var2, TileEntityTypes.CAMPFIRE, TileEntityCampfire::cookTick);
            }
            return BlockCampfire.createTickerHelper(var2, TileEntityTypes.CAMPFIRE, TileEntityCampfire::cooldownTick);
        }
        return null;
    }

    @Override
    public boolean isPathfindable(IBlockData var0, IBlockAccess var1, BlockPosition var2, PathMode var3) {
        return false;
    }

    public static boolean canLight(IBlockData var02) {
        return var02.is(TagsBlock.CAMPFIRES, var0 -> var0.hasProperty(WATERLOGGED) && var0.hasProperty(LIT)) && var02.getValue(WATERLOGGED) == false && var02.getValue(LIT) == false;
    }
}

