/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.IFluidSource;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockBubbleColumn
extends Block
implements IFluidSource {
    public static final BlockStateBoolean DRAG_DOWN = BlockProperties.DRAG;
    private static final int CHECK_PERIOD = 5;

    public BlockBubbleColumn(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(DRAG_DOWN, true));
    }

    @Override
    public void entityInside(IBlockData var0, World var1, BlockPosition var2, Entity var3) {
        IBlockData var4 = var1.getBlockState(var2.above());
        if (var4.isAir()) {
            var3.onAboveBubbleCol(var0.getValue(DRAG_DOWN));
            if (!var1.isClientSide) {
                WorldServer var5 = (WorldServer)var1;
                for (int var6 = 0; var6 < 2; ++var6) {
                    var5.sendParticles(Particles.SPLASH, (double)var2.getX() + var1.random.nextDouble(), var2.getY() + 1, (double)var2.getZ() + var1.random.nextDouble(), 1, 0.0, 0.0, 0.0, 1.0);
                    var5.sendParticles(Particles.BUBBLE, (double)var2.getX() + var1.random.nextDouble(), var2.getY() + 1, (double)var2.getZ() + var1.random.nextDouble(), 1, 0.0, 0.01, 0.0, 0.2);
                }
            }
        } else {
            var3.onInsideBubbleColumn(var0.getValue(DRAG_DOWN));
        }
    }

    @Override
    public void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        BlockBubbleColumn.updateColumn(var1, var2, var0, var1.getBlockState(var2.below()));
    }

    @Override
    public Fluid getFluidState(IBlockData var0) {
        return FluidTypes.WATER.getSource(false);
    }

    public static void updateColumn(GeneratorAccess var0, BlockPosition var1, IBlockData var2) {
        BlockBubbleColumn.updateColumn(var0, var1, var0.getBlockState(var1), var2);
    }

    public static void updateColumn(GeneratorAccess var0, BlockPosition var1, IBlockData var2, IBlockData var3) {
        if (!BlockBubbleColumn.canExistIn(var2)) {
            return;
        }
        IBlockData var4 = BlockBubbleColumn.getColumnState(var3);
        var0.setBlock(var1, var4, 2);
        BlockPosition.MutableBlockPosition var5 = var1.mutable().move(EnumDirection.UP);
        while (BlockBubbleColumn.canExistIn(var0.getBlockState(var5))) {
            if (!var0.setBlock(var5, var4, 2)) {
                return;
            }
            var5.move(EnumDirection.UP);
        }
    }

    private static boolean canExistIn(IBlockData var0) {
        return var0.is(Blocks.BUBBLE_COLUMN) || var0.is(Blocks.WATER) && var0.getFluidState().getAmount() >= 8 && var0.getFluidState().isSource();
    }

    private static IBlockData getColumnState(IBlockData var0) {
        if (var0.is(Blocks.BUBBLE_COLUMN)) {
            return var0;
        }
        if (var0.is(Blocks.SOUL_SAND)) {
            return (IBlockData)Blocks.BUBBLE_COLUMN.defaultBlockState().setValue(DRAG_DOWN, false);
        }
        if (var0.is(Blocks.MAGMA_BLOCK)) {
            return (IBlockData)Blocks.BUBBLE_COLUMN.defaultBlockState().setValue(DRAG_DOWN, true);
        }
        return Blocks.WATER.defaultBlockState();
    }

    @Override
    public void animateTick(IBlockData var0, World var1, BlockPosition var2, RandomSource var3) {
        double var4 = var2.getX();
        double var6 = var2.getY();
        double var8 = var2.getZ();
        if (var0.getValue(DRAG_DOWN).booleanValue()) {
            var1.addAlwaysVisibleParticle(Particles.CURRENT_DOWN, var4 + 0.5, var6 + 0.8, var8, 0.0, 0.0, 0.0);
            if (var3.nextInt(200) == 0) {
                var1.playLocalSound(var4, var6, var8, SoundEffects.BUBBLE_COLUMN_WHIRLPOOL_AMBIENT, SoundCategory.BLOCKS, 0.2f + var3.nextFloat() * 0.2f, 0.9f + var3.nextFloat() * 0.15f, false);
            }
        } else {
            var1.addAlwaysVisibleParticle(Particles.BUBBLE_COLUMN_UP, var4 + 0.5, var6, var8 + 0.5, 0.0, 0.04, 0.0);
            var1.addAlwaysVisibleParticle(Particles.BUBBLE_COLUMN_UP, var4 + (double)var3.nextFloat(), var6 + (double)var3.nextFloat(), var8 + (double)var3.nextFloat(), 0.0, 0.04, 0.0);
            if (var3.nextInt(200) == 0) {
                var1.playLocalSound(var4, var6, var8, SoundEffects.BUBBLE_COLUMN_UPWARDS_AMBIENT, SoundCategory.BLOCKS, 0.2f + var3.nextFloat() * 0.2f, 0.9f + var3.nextFloat() * 0.15f, false);
            }
        }
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        var3.scheduleTick(var4, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var3));
        if (!var0.canSurvive(var3, var4) || var1 == EnumDirection.DOWN || var1 == EnumDirection.UP && !var2.is(Blocks.BUBBLE_COLUMN) && BlockBubbleColumn.canExistIn(var2)) {
            var3.scheduleTick(var4, this, 5);
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    @Override
    public boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        IBlockData var3 = var1.getBlockState(var2.below());
        return var3.is(Blocks.BUBBLE_COLUMN) || var3.is(Blocks.MAGMA_BLOCK) || var3.is(Blocks.SOUL_SAND);
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return VoxelShapes.empty();
    }

    @Override
    public EnumRenderType getRenderShape(IBlockData var0) {
        return EnumRenderType.INVISIBLE;
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(DRAG_DOWN);
    }

    @Override
    public ItemStack pickupBlock(@Nullable EntityHuman var0, GeneratorAccess var1, BlockPosition var2, IBlockData var3) {
        var1.setBlock(var2, Blocks.AIR.defaultBlockState(), 11);
        return new ItemStack(Items.WATER_BUCKET);
    }

    @Override
    public Optional<SoundEffect> getPickupSound() {
        return FluidTypes.WATER.getPickupSound();
    }
}

