/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;

public class BlockBarrier
extends Block
implements IBlockWaterlogged {
    public static final BlockStateBoolean WATERLOGGED = BlockProperties.WATERLOGGED;

    protected BlockBarrier(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)this.defaultBlockState().setValue(WATERLOGGED, false));
    }

    @Override
    public boolean propagatesSkylightDown(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return true;
    }

    @Override
    public EnumRenderType getRenderShape(IBlockData var0) {
        return EnumRenderType.INVISIBLE;
    }

    @Override
    public float getShadeBrightness(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return 1.0f;
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var3.scheduleTick(var4, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var3));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    @Override
    public Fluid getFluidState(IBlockData var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return FluidTypes.WATER.getSource(false);
        }
        return super.getFluidState(var0);
    }

    @Override
    @Nullable
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        return (IBlockData)this.defaultBlockState().setValue(WATERLOGGED, var0.getLevel().getFluidState(var0.getClickedPos()).getType() == FluidTypes.WATER);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(WATERLOGGED);
    }

    @Override
    public ItemStack pickupBlock(@Nullable EntityHuman var0, GeneratorAccess var1, BlockPosition var2, IBlockData var3) {
        if (var0 == null || !var0.isCreative()) {
            return ItemStack.EMPTY;
        }
        return IBlockWaterlogged.super.pickupBlock(var0, var1, var2, var3);
    }

    @Override
    public boolean canPlaceLiquid(@Nullable EntityHuman var0, IBlockAccess var1, BlockPosition var2, IBlockData var3, FluidType var4) {
        if (var0 == null || !var0.isCreative()) {
            return false;
        }
        return IBlockWaterlogged.super.canPlaceLiquid(var0, var1, var2, var3, var4);
    }
}

