/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import java.util.Map;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.item.ItemArmor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.EnchantmentSlotType;
import net.minecraft.world.item.enchantment.Enchantments;

public class EnchantmentThorns
extends Enchantment {
    private static final float CHANCE_PER_LEVEL = 0.15f;

    public EnchantmentThorns(Enchantment.Rarity var0, EnumItemSlot ... var1) {
        super(var0, EnchantmentSlotType.ARMOR_CHEST, var1);
    }

    @Override
    public int getMinCost(int var0) {
        return 10 + 20 * (var0 - 1);
    }

    @Override
    public int getMaxCost(int var0) {
        return super.getMinCost(var0) + 50;
    }

    @Override
    public int getMaxLevel() {
        return 3;
    }

    @Override
    public boolean canEnchant(ItemStack var0) {
        if (var0.getItem() instanceof ItemArmor) {
            return true;
        }
        return super.canEnchant(var0);
    }

    @Override
    public void doPostHurt(EntityLiving var0, Entity var12, int var2) {
        RandomSource var3 = var0.getRandom();
        Map.Entry<EnumItemSlot, ItemStack> var4 = EnchantmentManager.getRandomItemWith(Enchantments.THORNS, var0);
        if (EnchantmentThorns.shouldHit(var2, var3)) {
            if (var12 != null) {
                var12.hurt(var0.damageSources().thorns(var0), EnchantmentThorns.getDamage(var2, var3));
            }
            if (var4 != null) {
                var4.getValue().hurtAndBreak(2, var0, var1 -> var1.broadcastBreakEvent((EnumItemSlot)var4.getKey()));
            }
        }
    }

    public static boolean shouldHit(int var0, RandomSource var1) {
        if (var0 <= 0) {
            return false;
        }
        return var1.nextFloat() < 0.15f * (float)var0;
    }

    public static int getDamage(int var0, RandomSource var1) {
        if (var0 > 10) {
            return var0 - 10;
        }
        return 1 + var1.nextInt(4);
    }
}

