/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.world.IInventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipeCodecs;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.level.World;

public class SmithingTransformRecipe
implements SmithingRecipe {
    final RecipeItemStack template;
    final RecipeItemStack base;
    final RecipeItemStack addition;
    final ItemStack result;

    public SmithingTransformRecipe(RecipeItemStack var0, RecipeItemStack var1, RecipeItemStack var2, ItemStack var3) {
        this.template = var0;
        this.base = var1;
        this.addition = var2;
        this.result = var3;
    }

    @Override
    public boolean matches(IInventory var0, World var1) {
        return this.template.test(var0.getItem(0)) && this.base.test(var0.getItem(1)) && this.addition.test(var0.getItem(2));
    }

    @Override
    public ItemStack assemble(IInventory var0, IRegistryCustom var1) {
        ItemStack var2 = this.result.copy();
        NBTTagCompound var3 = var0.getItem(1).getTag();
        if (var3 != null) {
            var2.setTag(var3.copy());
        }
        return var2;
    }

    @Override
    public ItemStack getResultItem(IRegistryCustom var0) {
        return this.result;
    }

    @Override
    public boolean isTemplateIngredient(ItemStack var0) {
        return this.template.test(var0);
    }

    @Override
    public boolean isBaseIngredient(ItemStack var0) {
        return this.base.test(var0);
    }

    @Override
    public boolean isAdditionIngredient(ItemStack var0) {
        return this.addition.test(var0);
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.SMITHING_TRANSFORM;
    }

    @Override
    public boolean isIncomplete() {
        return Stream.of(this.template, this.base, this.addition).anyMatch(RecipeItemStack::isEmpty);
    }

    public static class a
    implements RecipeSerializer<SmithingTransformRecipe> {
        private static final Codec<SmithingTransformRecipe> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)RecipeItemStack.CODEC.fieldOf("template").forGetter(var0 -> var0.template), (App)RecipeItemStack.CODEC.fieldOf("base").forGetter(var0 -> var0.base), (App)RecipeItemStack.CODEC.fieldOf("addition").forGetter(var0 -> var0.addition), (App)CraftingRecipeCodecs.ITEMSTACK_OBJECT_CODEC.fieldOf("result").forGetter(var0 -> var0.result)).apply((Applicative)var02, SmithingTransformRecipe::new));

        @Override
        public Codec<SmithingTransformRecipe> codec() {
            return CODEC;
        }

        @Override
        public SmithingTransformRecipe fromNetwork(PacketDataSerializer var0) {
            RecipeItemStack var1 = RecipeItemStack.fromNetwork(var0);
            RecipeItemStack var2 = RecipeItemStack.fromNetwork(var0);
            RecipeItemStack var3 = RecipeItemStack.fromNetwork(var0);
            ItemStack var4 = var0.readItem();
            return new SmithingTransformRecipe(var1, var2, var3, var4);
        }

        @Override
        public void toNetwork(PacketDataSerializer var0, SmithingTransformRecipe var1) {
            var1.template.toNetwork(var0);
            var1.base.toNetwork(var0);
            var1.addition.toNetwork(var0);
            var0.writeItem(var1.result);
        }

        @Override
        public /* synthetic */ IRecipe fromNetwork(PacketDataSerializer packetDataSerializer) {
            return this.fromNetwork(packetDataSerializer);
        }
    }
}

