/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.NonNullList;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.AutoRecipeStackManager;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipeCodecs;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeCrafting;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.World;

public class ShapelessRecipes
implements RecipeCrafting {
    final String group;
    final CraftingBookCategory category;
    final ItemStack result;
    final NonNullList<RecipeItemStack> ingredients;

    public ShapelessRecipes(String var0, CraftingBookCategory var1, ItemStack var2, NonNullList<RecipeItemStack> var3) {
        this.group = var0;
        this.category = var1;
        this.result = var2;
        this.ingredients = var3;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.SHAPELESS_RECIPE;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public CraftingBookCategory category() {
        return this.category;
    }

    @Override
    public ItemStack getResultItem(IRegistryCustom var0) {
        return this.result;
    }

    @Override
    public NonNullList<RecipeItemStack> getIngredients() {
        return this.ingredients;
    }

    @Override
    public boolean matches(InventoryCrafting var0, World var1) {
        AutoRecipeStackManager var2 = new AutoRecipeStackManager();
        int var3 = 0;
        for (int var4 = 0; var4 < var0.getContainerSize(); ++var4) {
            ItemStack var5 = var0.getItem(var4);
            if (var5.isEmpty()) continue;
            ++var3;
            var2.accountStack(var5, 1);
        }
        return var3 == this.ingredients.size() && var2.canCraft(this, null);
    }

    @Override
    public ItemStack assemble(InventoryCrafting var0, IRegistryCustom var1) {
        return this.result.copy();
    }

    @Override
    public boolean canCraftInDimensions(int var0, int var1) {
        return var0 * var1 >= this.ingredients.size();
    }

    public static class a
    implements RecipeSerializer<ShapelessRecipes> {
        private static final Codec<ShapelessRecipes> CODEC = RecordCodecBuilder.create(var03 -> var03.group((App)ExtraCodecs.strictOptionalField(Codec.STRING, "group", "").forGetter(var0 -> var0.group), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(var0 -> var0.category), (App)CraftingRecipeCodecs.ITEMSTACK_OBJECT_CODEC.fieldOf("result").forGetter(var0 -> var0.result), (App)RecipeItemStack.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(var02 -> {
            RecipeItemStack[] var1 = (RecipeItemStack[])var02.stream().filter(var0 -> !var0.isEmpty()).toArray(RecipeItemStack[]::new);
            if (var1.length == 0) {
                return DataResult.error(() -> "No ingredients for shapeless recipe");
            }
            if (var1.length > 9) {
                return DataResult.error(() -> "Too many ingredients for shapeless recipe");
            }
            return DataResult.success(NonNullList.of(RecipeItemStack.EMPTY, var1));
        }, DataResult::success).forGetter(var0 -> var0.ingredients)).apply((Applicative)var03, ShapelessRecipes::new));

        @Override
        public Codec<ShapelessRecipes> codec() {
            return CODEC;
        }

        @Override
        public ShapelessRecipes fromNetwork(PacketDataSerializer var0) {
            String var1 = var0.readUtf();
            CraftingBookCategory var2 = var0.readEnum(CraftingBookCategory.class);
            int var3 = var0.readVarInt();
            NonNullList<RecipeItemStack> var4 = NonNullList.withSize(var3, RecipeItemStack.EMPTY);
            for (int var5 = 0; var5 < var4.size(); ++var5) {
                var4.set(var5, RecipeItemStack.fromNetwork(var0));
            }
            ItemStack var5 = var0.readItem();
            return new ShapelessRecipes(var1, var2, var5, var4);
        }

        @Override
        public void toNetwork(PacketDataSerializer var0, ShapelessRecipes var1) {
            var0.writeUtf(var1.group);
            var0.writeEnum(var1.category);
            var0.writeVarInt(var1.ingredients.size());
            for (RecipeItemStack var3 : var1.ingredients) {
                var3.toNetwork(var0);
            }
            var0.writeItem(var1.result);
        }

        @Override
        public /* synthetic */ IRecipe fromNetwork(PacketDataSerializer packetDataSerializer) {
            return this.fromNetwork(packetDataSerializer);
        }
    }
}

