/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.NonNullList;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipeCodecs;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeCrafting;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.World;
import org.apache.commons.lang3.NotImplementedException;

public class ShapedRecipes
implements RecipeCrafting {
    final int width;
    final int height;
    final NonNullList<RecipeItemStack> recipeItems;
    final ItemStack result;
    final String group;
    final CraftingBookCategory category;
    final boolean showNotification;

    public ShapedRecipes(String var0, CraftingBookCategory var1, int var2, int var3, NonNullList<RecipeItemStack> var4, ItemStack var5, boolean var6) {
        this.group = var0;
        this.category = var1;
        this.width = var2;
        this.height = var3;
        this.recipeItems = var4;
        this.result = var5;
        this.showNotification = var6;
    }

    public ShapedRecipes(String var0, CraftingBookCategory var1, int var2, int var3, NonNullList<RecipeItemStack> var4, ItemStack var5) {
        this(var0, var1, var2, var3, var4, var5, true);
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.SHAPED_RECIPE;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public CraftingBookCategory category() {
        return this.category;
    }

    @Override
    public ItemStack getResultItem(IRegistryCustom var0) {
        return this.result;
    }

    @Override
    public NonNullList<RecipeItemStack> getIngredients() {
        return this.recipeItems;
    }

    @Override
    public boolean showNotification() {
        return this.showNotification;
    }

    @Override
    public boolean canCraftInDimensions(int var0, int var1) {
        return var0 >= this.width && var1 >= this.height;
    }

    @Override
    public boolean matches(InventoryCrafting var0, World var1) {
        for (int var2 = 0; var2 <= var0.getWidth() - this.width; ++var2) {
            for (int var3 = 0; var3 <= var0.getHeight() - this.height; ++var3) {
                if (this.matches(var0, var2, var3, true)) {
                    return true;
                }
                if (!this.matches(var0, var2, var3, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matches(InventoryCrafting var0, int var1, int var2, boolean var3) {
        for (int var4 = 0; var4 < var0.getWidth(); ++var4) {
            for (int var5 = 0; var5 < var0.getHeight(); ++var5) {
                int var6 = var4 - var1;
                int var7 = var5 - var2;
                RecipeItemStack var8 = RecipeItemStack.EMPTY;
                if (var6 >= 0 && var7 >= 0 && var6 < this.width && var7 < this.height) {
                    var8 = var3 ? this.recipeItems.get(this.width - var6 - 1 + var7 * this.width) : this.recipeItems.get(var6 + var7 * this.width);
                }
                if (var8.test(var0.getItem(var4 + var5 * var0.getWidth()))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public ItemStack assemble(InventoryCrafting var0, IRegistryCustom var1) {
        return this.getResultItem(var1).copy();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    @VisibleForTesting
    static String[] shrink(List<String> var0) {
        int var1 = Integer.MAX_VALUE;
        int var2 = 0;
        int var3 = 0;
        int var4 = 0;
        for (int var5 = 0; var5 < var0.size(); ++var5) {
            String var6 = var0.get(var5);
            var1 = Math.min(var1, ShapedRecipes.firstNonSpace(var6));
            int var7 = ShapedRecipes.lastNonSpace(var6);
            var2 = Math.max(var2, var7);
            if (var7 < 0) {
                if (var3 == var5) {
                    ++var3;
                }
                ++var4;
                continue;
            }
            var4 = 0;
        }
        if (var0.size() == var4) {
            return new String[0];
        }
        String[] var5 = new String[var0.size() - var4 - var3];
        for (int var6 = 0; var6 < var5.length; ++var6) {
            var5[var6] = var0.get(var6 + var3).substring(var1, var2 + 1);
        }
        return var5;
    }

    @Override
    public boolean isIncomplete() {
        NonNullList<RecipeItemStack> var02 = this.getIngredients();
        return var02.isEmpty() || var02.stream().filter(var0 -> !var0.isEmpty()).anyMatch(var0 -> var0.getItems().length == 0);
    }

    private static int firstNonSpace(String var0) {
        int var1;
        for (var1 = 0; var1 < var0.length() && var0.charAt(var1) == ' '; ++var1) {
        }
        return var1;
    }

    private static int lastNonSpace(String var0) {
        int var1;
        for (var1 = var0.length() - 1; var1 >= 0 && var0.charAt(var1) == ' '; --var1) {
        }
        return var1;
    }

    public static class Serializer
    implements RecipeSerializer<ShapedRecipes> {
        static final Codec<List<String>> PATTERN_CODEC = Codec.STRING.listOf().flatXmap(var0 -> {
            if (var0.size() > 3) {
                return DataResult.error(() -> "Invalid pattern: too many rows, 3 is maximum");
            }
            if (var0.isEmpty()) {
                return DataResult.error(() -> "Invalid pattern: empty pattern not allowed");
            }
            int var1 = ((String)var0.get(0)).length();
            for (String var3 : var0) {
                if (var3.length() > 3) {
                    return DataResult.error(() -> "Invalid pattern: too many columns, 3 is maximum");
                }
                if (var1 == var3.length()) continue;
                return DataResult.error(() -> "Invalid pattern: each row must be the same width");
            }
            return DataResult.success((Object)var0);
        }, DataResult::success);
        static final Codec<String> SINGLE_CHARACTER_STRING_CODEC = Codec.STRING.flatXmap(var0 -> {
            if (var0.length() != 1) {
                return DataResult.error(() -> "Invalid key entry: '" + var0 + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(var0)) {
                return DataResult.error(() -> "Invalid key entry: ' ' is a reserved symbol.");
            }
            return DataResult.success((Object)var0);
        }, DataResult::success);
        private static final Codec<ShapedRecipes> CODEC = RawShapedRecipe.CODEC.flatXmap(var0 -> {
            String[] var1 = ShapedRecipes.shrink(var0.pattern);
            int var2 = var1[0].length();
            int var3 = var1.length;
            NonNullList<RecipeItemStack> var4 = NonNullList.withSize(var2 * var3, RecipeItemStack.EMPTY);
            HashSet var5 = Sets.newHashSet(var0.key.keySet());
            for (int var6 = 0; var6 < var1.length; ++var6) {
                String var7 = var1[var6];
                for (int var8 = 0; var8 < var7.length(); ++var8) {
                    RecipeItemStack var10;
                    String var9 = var7.substring(var8, var8 + 1);
                    RecipeItemStack recipeItemStack = var10 = var9.equals(" ") ? RecipeItemStack.EMPTY : var0.key.get(var9);
                    if (var10 == null) {
                        return DataResult.error(() -> "Pattern references symbol '" + var9 + "' but it's not defined in the key");
                    }
                    var5.remove(var9);
                    var4.set(var8 + var2 * var6, var10);
                }
            }
            if (!var5.isEmpty()) {
                return DataResult.error(() -> "Key defines symbols that aren't used in pattern: " + var5);
            }
            ShapedRecipes var6 = new ShapedRecipes(var0.group, var0.category, var2, var3, var4, var0.result, var0.showNotification);
            return DataResult.success((Object)var6);
        }, var0 -> {
            throw new NotImplementedException("Serializing ShapedRecipe is not implemented yet.");
        });

        @Override
        public Codec<ShapedRecipes> codec() {
            return CODEC;
        }

        @Override
        public ShapedRecipes fromNetwork(PacketDataSerializer var0) {
            int var1 = var0.readVarInt();
            int var2 = var0.readVarInt();
            String var3 = var0.readUtf();
            CraftingBookCategory var4 = var0.readEnum(CraftingBookCategory.class);
            NonNullList<RecipeItemStack> var5 = NonNullList.withSize(var1 * var2, RecipeItemStack.EMPTY);
            for (int var6 = 0; var6 < var5.size(); ++var6) {
                var5.set(var6, RecipeItemStack.fromNetwork(var0));
            }
            ItemStack var6 = var0.readItem();
            boolean var7 = var0.readBoolean();
            return new ShapedRecipes(var3, var4, var1, var2, var5, var6, var7);
        }

        @Override
        public void toNetwork(PacketDataSerializer var0, ShapedRecipes var1) {
            var0.writeVarInt(var1.width);
            var0.writeVarInt(var1.height);
            var0.writeUtf(var1.group);
            var0.writeEnum(var1.category);
            for (RecipeItemStack var3 : var1.recipeItems) {
                var3.toNetwork(var0);
            }
            var0.writeItem(var1.result);
            var0.writeBoolean(var1.showNotification);
        }

        @Override
        public /* synthetic */ IRecipe fromNetwork(PacketDataSerializer packetDataSerializer) {
            return this.fromNetwork(packetDataSerializer);
        }

        static final class RawShapedRecipe
        extends Record {
            final String group;
            final CraftingBookCategory category;
            final Map<String, RecipeItemStack> key;
            final List<String> pattern;
            final ItemStack result;
            final boolean showNotification;
            public static final Codec<RawShapedRecipe> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)ExtraCodecs.strictOptionalField(Codec.STRING, "group", "").forGetter(var0 -> var0.group), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(var0 -> var0.category), (App)ExtraCodecs.strictUnboundedMap(SINGLE_CHARACTER_STRING_CODEC, RecipeItemStack.CODEC_NONEMPTY).fieldOf("key").forGetter(var0 -> var0.key), (App)PATTERN_CODEC.fieldOf("pattern").forGetter(var0 -> var0.pattern), (App)CraftingRecipeCodecs.ITEMSTACK_OBJECT_CODEC.fieldOf("result").forGetter(var0 -> var0.result), (App)ExtraCodecs.strictOptionalField(Codec.BOOL, "show_notification", true).forGetter(var0 -> var0.showNotification)).apply((Applicative)var02, RawShapedRecipe::new));

            private RawShapedRecipe(String var0, CraftingBookCategory var1, Map<String, RecipeItemStack> var2, List<String> var3, ItemStack var4, boolean var5) {
                this.group = var0;
                this.category = var1;
                this.key = var2;
                this.pattern = var3;
                this.result = var4;
                this.showNotification = var5;
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{RawShapedRecipe.class, "group;category;key;pattern;result;showNotification", "group", "category", "key", "pattern", "result", "showNotification"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RawShapedRecipe.class, "group;category;key;pattern;result;showNotification", "group", "category", "key", "pattern", "result", "showNotification"}, this);
            }

            @Override
            public final boolean equals(Object var0) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RawShapedRecipe.class, "group;category;key;pattern;result;showNotification", "group", "category", "key", "pattern", "result", "showNotification"}, this, var0);
            }

            public String group() {
                return this.group;
            }

            public CraftingBookCategory category() {
                return this.category;
            }

            public Map<String, RecipeItemStack> key() {
                return this.key;
            }

            public List<String> pattern() {
                return this.pattern;
            }

            public ItemStack result() {
                return this.result;
            }

            public boolean showNotification() {
                return this.showNotification;
            }
        }
    }
}

