/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.IRecipeComplex;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;

public class RecipeRepair
extends IRecipeComplex {
    public RecipeRepair(CraftingBookCategory var0) {
        super(var0);
    }

    @Override
    public boolean matches(InventoryCrafting var0, World var1) {
        ArrayList var2 = Lists.newArrayList();
        for (int var3 = 0; var3 < var0.getContainerSize(); ++var3) {
            ItemStack var5;
            ItemStack var4 = var0.getItem(var3);
            if (var4.isEmpty()) continue;
            var2.add(var4);
            if (var2.size() <= 1 || var4.is((var5 = (ItemStack)var2.get(0)).getItem()) && var5.getCount() == 1 && var4.getCount() == 1 && var5.getItem().canBeDepleted()) continue;
            return false;
        }
        return var2.size() == 2;
    }

    @Override
    public ItemStack assemble(InventoryCrafting var0, IRegistryCustom var1) {
        ItemStack var32;
        Object var5;
        ItemStack var4;
        ArrayList var2 = Lists.newArrayList();
        for (int var33 = 0; var33 < var0.getContainerSize(); ++var33) {
            var4 = var0.getItem(var33);
            if (var4.isEmpty()) continue;
            var2.add(var4);
            if (var2.size() <= 1 || var4.is(((ItemStack)(var5 = (ItemStack)var2.get(0))).getItem()) && ((ItemStack)var5).getCount() == 1 && var4.getCount() == 1 && ((ItemStack)var5).getItem().canBeDepleted()) continue;
            return ItemStack.EMPTY;
        }
        if (var2.size() == 2 && (var32 = (ItemStack)var2.get(0)).is((var4 = (ItemStack)var2.get(1)).getItem()) && var32.getCount() == 1 && var4.getCount() == 1 && var32.getItem().canBeDepleted()) {
            var5 = var32.getItem();
            int var6 = ((Item)var5).getMaxDamage() - var32.getDamageValue();
            int var7 = ((Item)var5).getMaxDamage() - var4.getDamageValue();
            int var8 = var6 + var7 + ((Item)var5).getMaxDamage() * 5 / 100;
            int var9 = ((Item)var5).getMaxDamage() - var8;
            if (var9 < 0) {
                var9 = 0;
            }
            ItemStack var10 = new ItemStack(var32.getItem());
            var10.setDamageValue(var9);
            HashMap var11 = Maps.newHashMap();
            Map<Enchantment, Integer> var12 = EnchantmentManager.getEnchantments(var32);
            Map<Enchantment, Integer> var13 = EnchantmentManager.getEnchantments(var4);
            BuiltInRegistries.ENCHANTMENT.stream().filter(Enchantment::isCurse).forEach(var3 -> {
                int var4 = Math.max(var12.getOrDefault(var3, 0), var13.getOrDefault(var3, 0));
                if (var4 > 0) {
                    var11.put(var3, var4);
                }
            });
            if (!var11.isEmpty()) {
                EnchantmentManager.setEnchantments(var11, var10);
            }
            return var10;
        }
        return ItemStack.EMPTY;
    }

    @Override
    public boolean canCraftInDimensions(int var0, int var1) {
        return var0 * var1 >= 2;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.REPAIR_ITEM;
    }
}

