/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import net.minecraft.core.IRegistryCustom;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.IRecipeComplex;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.World;

public class RecipeMapClone
extends IRecipeComplex {
    public RecipeMapClone(CraftingBookCategory var0) {
        super(var0);
    }

    @Override
    public boolean matches(InventoryCrafting var0, World var1) {
        int var2 = 0;
        ItemStack var3 = ItemStack.EMPTY;
        for (int var4 = 0; var4 < var0.getContainerSize(); ++var4) {
            ItemStack var5 = var0.getItem(var4);
            if (var5.isEmpty()) continue;
            if (var5.is(Items.FILLED_MAP)) {
                if (!var3.isEmpty()) {
                    return false;
                }
                var3 = var5;
                continue;
            }
            if (var5.is(Items.MAP)) {
                ++var2;
                continue;
            }
            return false;
        }
        return !var3.isEmpty() && var2 > 0;
    }

    @Override
    public ItemStack assemble(InventoryCrafting var0, IRegistryCustom var1) {
        int var2 = 0;
        ItemStack var3 = ItemStack.EMPTY;
        for (int var4 = 0; var4 < var0.getContainerSize(); ++var4) {
            ItemStack var5 = var0.getItem(var4);
            if (var5.isEmpty()) continue;
            if (var5.is(Items.FILLED_MAP)) {
                if (!var3.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                var3 = var5;
                continue;
            }
            if (var5.is(Items.MAP)) {
                ++var2;
                continue;
            }
            return ItemStack.EMPTY;
        }
        if (var3.isEmpty() || var2 < 1) {
            return ItemStack.EMPTY;
        }
        return var3.copyWithCount(var2 + 1);
    }

    @Override
    public boolean canCraftInDimensions(int var0, int var1) {
        return var0 >= 3 && var1 >= 3;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.MAP_CLONING;
    }
}

