/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.AutoRecipeStackManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipeCodecs;
import net.minecraft.world.level.IMaterial;

public final class RecipeItemStack
implements Predicate<ItemStack> {
    public static final RecipeItemStack EMPTY = new RecipeItemStack(Stream.empty());
    private final Provider[] values;
    @Nullable
    public ItemStack[] itemStacks;
    @Nullable
    private IntList stackingIds;
    public static final Codec<RecipeItemStack> CODEC = RecipeItemStack.codec(true);
    public static final Codec<RecipeItemStack> CODEC_NONEMPTY = RecipeItemStack.codec(false);

    public RecipeItemStack(Stream<? extends Provider> var0) {
        this.values = (Provider[])var0.toArray(Provider[]::new);
    }

    private RecipeItemStack(Provider[] var0) {
        this.values = var0;
    }

    public ItemStack[] getItems() {
        if (this.itemStacks == null) {
            this.itemStacks = (ItemStack[])Arrays.stream(this.values).flatMap(var0 -> var0.getItems().stream()).distinct().toArray(ItemStack[]::new);
        }
        return this.itemStacks;
    }

    @Override
    public boolean test(@Nullable ItemStack var0) {
        if (var0 == null) {
            return false;
        }
        if (this.isEmpty()) {
            return var0.isEmpty();
        }
        for (ItemStack var4 : this.getItems()) {
            if (!var4.is(var0.getItem())) continue;
            return true;
        }
        return false;
    }

    public IntList getStackingIds() {
        if (this.stackingIds == null) {
            ItemStack[] var0 = this.getItems();
            this.stackingIds = new IntArrayList(var0.length);
            for (ItemStack var4 : var0) {
                this.stackingIds.add(AutoRecipeStackManager.getStackingIndex(var4));
            }
            this.stackingIds.sort(IntComparators.NATURAL_COMPARATOR);
        }
        return this.stackingIds;
    }

    public void toNetwork(PacketDataSerializer var0) {
        var0.writeCollection(Arrays.asList(this.getItems()), PacketDataSerializer::writeItem);
    }

    public JsonElement toJson(boolean var0) {
        Codec<RecipeItemStack> var1 = var0 ? CODEC : CODEC_NONEMPTY;
        return (JsonElement)SystemUtils.getOrThrow(var1.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this), IllegalStateException::new);
    }

    public boolean isEmpty() {
        return this.values.length == 0;
    }

    public boolean equals(Object var0) {
        if (var0 instanceof RecipeItemStack) {
            RecipeItemStack var1 = (RecipeItemStack)var0;
            return Arrays.equals(this.values, var1.values);
        }
        return false;
    }

    private static RecipeItemStack fromValues(Stream<? extends Provider> var0) {
        RecipeItemStack var1 = new RecipeItemStack(var0);
        return var1.isEmpty() ? EMPTY : var1;
    }

    public static RecipeItemStack of() {
        return EMPTY;
    }

    public static RecipeItemStack of(IMaterial ... var0) {
        return RecipeItemStack.of(Arrays.stream(var0).map(ItemStack::new));
    }

    public static RecipeItemStack of(ItemStack ... var0) {
        return RecipeItemStack.of(Arrays.stream(var0));
    }

    public static RecipeItemStack of(Stream<ItemStack> var02) {
        return RecipeItemStack.fromValues(var02.filter(var0 -> !var0.isEmpty()).map(StackProvider::new));
    }

    public static RecipeItemStack of(TagKey<Item> var0) {
        return RecipeItemStack.fromValues(Stream.of(new b(var0)));
    }

    public static RecipeItemStack fromNetwork(PacketDataSerializer var0) {
        return RecipeItemStack.fromValues(var0.readList(PacketDataSerializer::readItem).stream().map(StackProvider::new));
    }

    private static Codec<RecipeItemStack> codec(boolean var0) {
        Codec var12 = Codec.list(Provider.CODEC).comapFlatMap(var1 -> {
            if (!var0 && var1.size() < 1) {
                return DataResult.error(() -> "Item array cannot be empty, at least one item must be defined");
            }
            return DataResult.success((Object)var1.toArray(new Provider[0]));
        }, List::of);
        return ExtraCodecs.either(var12, Provider.CODEC).flatComapMap(var02 -> (RecipeItemStack)var02.map(RecipeItemStack::new, var0 -> new RecipeItemStack(new Provider[]{var0})), var1 -> {
            if (var1.values.length == 1) {
                return DataResult.success((Object)Either.right((Object)var1.values[0]));
            }
            if (var1.values.length == 0 && !var0) {
                return DataResult.error(() -> "Item array cannot be empty, at least one item must be defined");
            }
            return DataResult.success((Object)Either.left((Object)var1.values));
        });
    }

    @Override
    public /* synthetic */ boolean test(@Nullable Object object) {
        return this.test((ItemStack)object);
    }

    public static interface Provider {
        public static final Codec<Provider> CODEC = ExtraCodecs.xor(StackProvider.CODEC, b.CODEC).xmap(var02 -> (Provider)var02.map(var0 -> var0, var0 -> var0), var0 -> {
            if (var0 instanceof b) {
                b var1 = (b)var0;
                return Either.right((Object)var1);
            }
            if (var0 instanceof StackProvider) {
                StackProvider var2 = (StackProvider)var0;
                return Either.left((Object)var2);
            }
            throw new UnsupportedOperationException("This is neither an item value nor a tag value.");
        });

        public Collection<ItemStack> getItems();
    }

    record b(TagKey<Item> tag) implements Provider
    {
        static final Codec<b> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)TagKey.codec(Registries.ITEM).fieldOf("tag").forGetter(var0 -> var0.tag)).apply((Applicative)var02, b::new));

        @Override
        public boolean equals(Object var0) {
            if (var0 instanceof b) {
                b var1 = (b)var0;
                return var1.tag.location().equals(this.tag.location());
            }
            return false;
        }

        @Override
        public Collection<ItemStack> getItems() {
            ArrayList var0 = Lists.newArrayList();
            for (Holder<Item> var2 : BuiltInRegistries.ITEM.getTagOrEmpty(this.tag)) {
                var0.add(new ItemStack(var2));
            }
            return var0;
        }
    }

    public record StackProvider(ItemStack item) implements Provider
    {
        static final Codec<StackProvider> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)CraftingRecipeCodecs.ITEMSTACK_NONAIR_CODEC.fieldOf("item").forGetter(var0 -> var0.item)).apply((Applicative)var02, StackProvider::new));

        @Override
        public boolean equals(Object var0) {
            if (var0 instanceof StackProvider) {
                StackProvider var1 = (StackProvider)var0;
                return var1.item.getItem().equals(this.item.getItem()) && var1.item.getCount() == this.item.getCount();
            }
            return false;
        }

        @Override
        public Collection<ItemStack> getItems() {
            return Collections.singleton(this.item);
        }
    }
}

