/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.armortrim;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.EnumChatFormat;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.EnumArmorMaterial;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import org.slf4j.Logger;

public class ArmorTrim {
    public static final Codec<ArmorTrim> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)TrimMaterial.CODEC.fieldOf("material").forGetter(ArmorTrim::material), (App)TrimPattern.CODEC.fieldOf("pattern").forGetter(ArmorTrim::pattern)).apply((Applicative)var0, ArmorTrim::new));
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String TAG_TRIM_ID = "Trim";
    private static final IChatBaseComponent UPGRADE_TITLE = IChatBaseComponent.translatable(SystemUtils.makeDescriptionId("item", new MinecraftKey("smithing_template.upgrade"))).withStyle(EnumChatFormat.GRAY);
    private final Holder<TrimMaterial> material;
    private final Holder<TrimPattern> pattern;
    private final Function<ArmorMaterial, MinecraftKey> innerTexture;
    private final Function<ArmorMaterial, MinecraftKey> outerTexture;

    public ArmorTrim(Holder<TrimMaterial> var0, Holder<TrimPattern> var1) {
        this.material = var0;
        this.pattern = var1;
        this.innerTexture = SystemUtils.memoize(var12 -> {
            MinecraftKey var2 = ((TrimPattern)var1.value()).assetId();
            String var3 = this.getColorPaletteSuffix((ArmorMaterial)var12);
            return var2.withPath(var1 -> "trims/models/armor/" + var1 + "_leggings_" + var3);
        });
        this.outerTexture = SystemUtils.memoize(var12 -> {
            MinecraftKey var2 = ((TrimPattern)var1.value()).assetId();
            String var3 = this.getColorPaletteSuffix((ArmorMaterial)var12);
            return var2.withPath(var1 -> "trims/models/armor/" + var1 + "_" + var3);
        });
    }

    private String getColorPaletteSuffix(ArmorMaterial var0) {
        Map<EnumArmorMaterial, String> var1 = this.material.value().overrideArmorMaterials();
        if (var0 instanceof EnumArmorMaterial && var1.containsKey(var0)) {
            return var1.get(var0);
        }
        return this.material.value().assetName();
    }

    public boolean hasPatternAndMaterial(Holder<TrimPattern> var0, Holder<TrimMaterial> var1) {
        return var0 == this.pattern && var1 == this.material;
    }

    public Holder<TrimPattern> pattern() {
        return this.pattern;
    }

    public Holder<TrimMaterial> material() {
        return this.material;
    }

    public MinecraftKey innerTexture(ArmorMaterial var0) {
        return this.innerTexture.apply(var0);
    }

    public MinecraftKey outerTexture(ArmorMaterial var0) {
        return this.outerTexture.apply(var0);
    }

    public boolean equals(Object var0) {
        if (!(var0 instanceof ArmorTrim)) {
            return false;
        }
        ArmorTrim var1 = (ArmorTrim)var0;
        return var1.pattern == this.pattern && var1.material == this.material;
    }

    public static boolean setTrim(IRegistryCustom var0, ItemStack var1, ArmorTrim var2) {
        if (var1.is(TagsItem.TRIMMABLE_ARMOR)) {
            var1.getOrCreateTag().put(TAG_TRIM_ID, (NBTBase)CODEC.encodeStart(RegistryOps.create(DynamicOpsNBT.INSTANCE, var0), (Object)var2).result().orElseThrow());
            return true;
        }
        return false;
    }

    public static Optional<ArmorTrim> getTrim(IRegistryCustom var0, ItemStack var12, boolean var2) {
        if (var12.is(TagsItem.TRIMMABLE_ARMOR) && var12.getTag() != null && var12.getTag().contains(TAG_TRIM_ID)) {
            NBTTagCompound var3 = var12.getTagElement(TAG_TRIM_ID);
            ArmorTrim var4 = CODEC.parse(RegistryOps.create(DynamicOpsNBT.INSTANCE, var0), (Object)var3).resultOrPartial(var1 -> {
                if (!var2) {
                    LOGGER.warn(var1);
                }
            }).orElse(null);
            return Optional.ofNullable(var4);
        }
        return Optional.empty();
    }

    public static void appendUpgradeHoverText(ItemStack var0, IRegistryCustom var1, List<IChatBaseComponent> var2) {
        Optional<ArmorTrim> var3 = ArmorTrim.getTrim(var1, var0, true);
        if (var3.isPresent()) {
            ArmorTrim var4 = var3.get();
            var2.add(UPGRADE_TITLE);
            var2.add(CommonComponents.space().append(var4.pattern().value().copyWithStyle(var4.material())));
            var2.add(CommonComponents.space().append(var4.material().value().description()));
        }
    }
}

