/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionUtil;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.SuspiciousEffectHolder;

public class ItemSuspiciousStew
extends Item {
    public static final String EFFECTS_TAG = "effects";
    public static final int DEFAULT_DURATION = 160;

    public ItemSuspiciousStew(Item.Info var0) {
        super(var0);
    }

    public static void saveMobEffects(ItemStack var0, List<SuspiciousEffectHolder.a> var12) {
        NBTTagCompound var2 = var0.getOrCreateTag();
        SuspiciousEffectHolder.a.LIST_CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, var12).result().ifPresent(var1 -> var2.put(EFFECTS_TAG, (NBTBase)var1));
    }

    public static void appendMobEffects(ItemStack var0, List<SuspiciousEffectHolder.a> var12) {
        NBTTagCompound var2 = var0.getOrCreateTag();
        ArrayList<SuspiciousEffectHolder.a> var3 = new ArrayList<SuspiciousEffectHolder.a>();
        ItemSuspiciousStew.listPotionEffects(var0, var3::add);
        var3.addAll(var12);
        SuspiciousEffectHolder.a.LIST_CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, var3).result().ifPresent(var1 -> var2.put(EFFECTS_TAG, (NBTBase)var1));
    }

    private static void listPotionEffects(ItemStack var0, Consumer<SuspiciousEffectHolder.a> var12) {
        NBTTagCompound var2 = var0.getTag();
        if (var2 != null && var2.contains(EFFECTS_TAG, 9)) {
            SuspiciousEffectHolder.a.LIST_CODEC.parse((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var2.getList(EFFECTS_TAG, 10)).result().ifPresent(var1 -> var1.forEach(var12));
        }
    }

    @Override
    public void appendHoverText(ItemStack var0, @Nullable World var12, List<IChatBaseComponent> var2, TooltipFlag var3) {
        super.appendHoverText(var0, var12, var2, var3);
        if (var3.isCreative()) {
            ArrayList<MobEffect> var4 = new ArrayList<MobEffect>();
            ItemSuspiciousStew.listPotionEffects(var0, var1 -> var4.add(var1.createEffectInstance()));
            PotionUtil.addPotionTooltip(var4, var2, 1.0f);
        }
    }

    @Override
    public ItemStack finishUsingItem(ItemStack var0, World var12, EntityLiving var2) {
        ItemStack var3 = super.finishUsingItem(var0, var12, var2);
        ItemSuspiciousStew.listPotionEffects(var3, var1 -> var2.addEffect(var1.createEffectInstance()));
        if (var2 instanceof EntityHuman && ((EntityHuman)var2).getAbilities().instabuild) {
            return var3;
        }
        return new ItemStack(Items.BOWL);
    }
}

