/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlockWallable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntitySkull;

public class ItemSkullPlayer
extends ItemBlockWallable {
    public static final String TAG_SKULL_OWNER = "SkullOwner";

    public ItemSkullPlayer(Block var0, Block var1, Item.Info var2) {
        super(var0, var1, var2, EnumDirection.DOWN);
    }

    @Override
    public IChatBaseComponent getName(ItemStack var0) {
        if (var0.is(Items.PLAYER_HEAD) && var0.hasTag()) {
            NBTTagCompound var3;
            String var1 = null;
            NBTTagCompound var2 = var0.getTag();
            if (var2.contains(TAG_SKULL_OWNER, 8)) {
                var1 = var2.getString(TAG_SKULL_OWNER);
            } else if (var2.contains(TAG_SKULL_OWNER, 10) && (var3 = var2.getCompound(TAG_SKULL_OWNER)).contains("Name", 8)) {
                var1 = var3.getString("Name");
            }
            if (var1 != null) {
                return IChatBaseComponent.translatable(this.getDescriptionId() + ".named", var1);
            }
        }
        return super.getName(var0);
    }

    @Override
    public void verifyTagAfterLoad(NBTTagCompound var0) {
        super.verifyTagAfterLoad(var0);
        TileEntitySkull.resolveGameProfile(var0);
    }
}

