/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.World;
import org.slf4j.Logger;

public class ItemKnowledgeBook
extends Item {
    private static final String RECIPE_TAG = "Recipes";
    private static final Logger LOGGER = LogUtils.getLogger();

    public ItemKnowledgeBook(Item.Info var0) {
        super(var0);
    }

    @Override
    public InteractionResultWrapper<ItemStack> use(World var0, EntityHuman var1, EnumHand var2) {
        ItemStack var3 = var1.getItemInHand(var2);
        NBTTagCompound var4 = var3.getTag();
        if (!var1.getAbilities().instabuild) {
            var1.setItemInHand(var2, ItemStack.EMPTY);
        }
        if (var4 == null || !var4.contains(RECIPE_TAG, 9)) {
            LOGGER.error("Tag not valid: {}", (Object)var4);
            return InteractionResultWrapper.fail(var3);
        }
        if (!var0.isClientSide) {
            NBTTagList var5 = var4.getList(RECIPE_TAG, 8);
            ArrayList var6 = Lists.newArrayList();
            CraftingManager var7 = var0.getServer().getRecipeManager();
            for (int var8 = 0; var8 < var5.size(); ++var8) {
                String var9 = var5.getString(var8);
                Optional<RecipeHolder<?>> var10 = var7.byKey(new MinecraftKey(var9));
                if (!var10.isPresent()) {
                    LOGGER.error("Invalid recipe: {}", (Object)var9);
                    return InteractionResultWrapper.fail(var3);
                }
                var6.add(var10.get());
            }
            var1.awardRecipes(var6);
            var1.awardStat(StatisticList.ITEM_USED.get(this));
        }
        return InteractionResultWrapper.sidedSuccess(var3, var0.isClientSide());
    }
}

