/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.monster.ICrossbow;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityFireworks;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.EnumAnimation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemArrow;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemVanishable;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class ItemCrossbow
extends ItemProjectileWeapon
implements ItemVanishable {
    private static final String TAG_CHARGED = "Charged";
    private static final String TAG_CHARGED_PROJECTILES = "ChargedProjectiles";
    private static final int MAX_CHARGE_DURATION = 25;
    public static final int DEFAULT_RANGE = 8;
    private boolean startSoundPlayed = false;
    private boolean midLoadSoundPlayed = false;
    private static final float START_SOUND_PERCENT = 0.2f;
    private static final float MID_SOUND_PERCENT = 0.5f;
    private static final float ARROW_POWER = 3.15f;
    private static final float FIREWORK_POWER = 1.6f;

    public ItemCrossbow(Item.Info var0) {
        super(var0);
    }

    @Override
    public Predicate<ItemStack> getSupportedHeldProjectiles() {
        return ARROW_OR_FIREWORK;
    }

    @Override
    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return ARROW_ONLY;
    }

    @Override
    public InteractionResultWrapper<ItemStack> use(World var0, EntityHuman var1, EnumHand var2) {
        ItemStack var3 = var1.getItemInHand(var2);
        if (ItemCrossbow.isCharged(var3)) {
            ItemCrossbow.performShooting(var0, var1, var2, var3, ItemCrossbow.getShootingPower(var3), 1.0f);
            ItemCrossbow.setCharged(var3, false);
            return InteractionResultWrapper.consume(var3);
        }
        if (!var1.getProjectile(var3).isEmpty()) {
            if (!ItemCrossbow.isCharged(var3)) {
                this.startSoundPlayed = false;
                this.midLoadSoundPlayed = false;
                var1.startUsingItem(var2);
            }
            return InteractionResultWrapper.consume(var3);
        }
        return InteractionResultWrapper.fail(var3);
    }

    private static float getShootingPower(ItemStack var0) {
        if (ItemCrossbow.containsChargedProjectile(var0, Items.FIREWORK_ROCKET)) {
            return 1.6f;
        }
        return 3.15f;
    }

    @Override
    public void releaseUsing(ItemStack var0, World var1, EntityLiving var2, int var3) {
        int var4 = this.getUseDuration(var0) - var3;
        float var5 = ItemCrossbow.getPowerForTime(var4, var0);
        if (var5 >= 1.0f && !ItemCrossbow.isCharged(var0) && ItemCrossbow.tryLoadProjectiles(var2, var0)) {
            ItemCrossbow.setCharged(var0, true);
            SoundCategory var6 = var2 instanceof EntityHuman ? SoundCategory.PLAYERS : SoundCategory.HOSTILE;
            var1.playSound(null, var2.getX(), var2.getY(), var2.getZ(), SoundEffects.CROSSBOW_LOADING_END, var6, 1.0f, 1.0f / (var1.getRandom().nextFloat() * 0.5f + 1.0f) + 0.2f);
        }
    }

    private static boolean tryLoadProjectiles(EntityLiving var0, ItemStack var1) {
        int var2 = EnchantmentManager.getItemEnchantmentLevel(Enchantments.MULTISHOT, var1);
        int var3 = var2 == 0 ? 1 : 3;
        boolean var4 = var0 instanceof EntityHuman && ((EntityHuman)var0).getAbilities().instabuild;
        ItemStack var5 = var0.getProjectile(var1);
        ItemStack var6 = var5.copy();
        for (int var7 = 0; var7 < var3; ++var7) {
            if (var7 > 0) {
                var5 = var6.copy();
            }
            if (var5.isEmpty() && var4) {
                var5 = new ItemStack(Items.ARROW);
                var6 = var5.copy();
            }
            if (ItemCrossbow.loadProjectile(var0, var1, var5, var7 > 0, var4)) continue;
            return false;
        }
        return true;
    }

    private static boolean loadProjectile(EntityLiving var0, ItemStack var1, ItemStack var2, boolean var3, boolean var4) {
        ItemStack var6;
        boolean var5;
        if (var2.isEmpty()) {
            return false;
        }
        boolean bl = var5 = var4 && var2.getItem() instanceof ItemArrow;
        if (!(var5 || var4 || var3)) {
            var6 = var2.split(1);
            if (var2.isEmpty() && var0 instanceof EntityHuman) {
                ((EntityHuman)var0).getInventory().removeItem(var2);
            }
        } else {
            var6 = var2.copy();
        }
        ItemCrossbow.addChargedProjectile(var1, var6);
        return true;
    }

    public static boolean isCharged(ItemStack var0) {
        NBTTagCompound var1 = var0.getTag();
        return var1 != null && var1.getBoolean(TAG_CHARGED);
    }

    public static void setCharged(ItemStack var0, boolean var1) {
        NBTTagCompound var2 = var0.getOrCreateTag();
        var2.putBoolean(TAG_CHARGED, var1);
    }

    private static void addChargedProjectile(ItemStack var0, ItemStack var1) {
        NBTTagCompound var2 = var0.getOrCreateTag();
        NBTTagList var3 = var2.contains(TAG_CHARGED_PROJECTILES, 9) ? var2.getList(TAG_CHARGED_PROJECTILES, 10) : new NBTTagList();
        NBTTagCompound var4 = new NBTTagCompound();
        var1.save(var4);
        var3.add(var4);
        var2.put(TAG_CHARGED_PROJECTILES, var3);
    }

    private static List<ItemStack> getChargedProjectiles(ItemStack var0) {
        NBTTagList var3;
        ArrayList var1 = Lists.newArrayList();
        NBTTagCompound var2 = var0.getTag();
        if (var2 != null && var2.contains(TAG_CHARGED_PROJECTILES, 9) && (var3 = var2.getList(TAG_CHARGED_PROJECTILES, 10)) != null) {
            for (int var4 = 0; var4 < var3.size(); ++var4) {
                NBTTagCompound var5 = var3.getCompound(var4);
                var1.add(ItemStack.of(var5));
            }
        }
        return var1;
    }

    private static void clearChargedProjectiles(ItemStack var0) {
        NBTTagCompound var1 = var0.getTag();
        if (var1 != null) {
            NBTTagList var2 = var1.getList(TAG_CHARGED_PROJECTILES, 9);
            var2.clear();
            var1.put(TAG_CHARGED_PROJECTILES, var2);
        }
    }

    public static boolean containsChargedProjectile(ItemStack var0, Item var12) {
        return ItemCrossbow.getChargedProjectiles(var0).stream().anyMatch(var1 -> var1.is(var12));
    }

    private static void shootProjectile(World var0, EntityLiving var12, EnumHand var2, ItemStack var3, ItemStack var4, float var5, boolean var6, float var7, float var8, float var9) {
        IProjectile var11;
        if (var0.isClientSide) {
            return;
        }
        boolean var10 = var4.is(Items.FIREWORK_ROCKET);
        if (var10) {
            var11 = new EntityFireworks(var0, var4, var12, var12.getX(), var12.getEyeY() - (double)0.15f, var12.getZ(), true);
        } else {
            var11 = ItemCrossbow.getArrow(var0, var12, var3, var4);
            if (var6 || var9 != 0.0f) {
                ((EntityArrow)var11).pickup = EntityArrow.PickupStatus.CREATIVE_ONLY;
            }
        }
        if (var12 instanceof ICrossbow) {
            ICrossbow var122 = (ICrossbow)((Object)var12);
            var122.shootCrossbowProjectile(var122.getTarget(), var3, var11, var9);
        } else {
            Vec3D var13 = var12.getUpVector(1.0f);
            Quaternionf var14 = new Quaternionf().setAngleAxis((double)(var9 * ((float)Math.PI / 180)), var13.x, var13.y, var13.z);
            Vec3D var15 = var12.getViewVector(1.0f);
            Vector3f var16 = var15.toVector3f().rotate((Quaternionfc)var14);
            var11.shoot(var16.x(), var16.y(), var16.z(), var7, var8);
        }
        var3.hurtAndBreak(var10 ? 3 : 1, var12, var1 -> var1.broadcastBreakEvent(var2));
        var0.addFreshEntity(var11);
        var0.playSound(null, var12.getX(), var12.getY(), var12.getZ(), SoundEffects.CROSSBOW_SHOOT, SoundCategory.PLAYERS, 1.0f, var5);
    }

    private static EntityArrow getArrow(World var0, EntityLiving var1, ItemStack var2, ItemStack var3) {
        ItemArrow var4 = (ItemArrow)(var3.getItem() instanceof ItemArrow ? var3.getItem() : Items.ARROW);
        EntityArrow var5 = var4.createArrow(var0, var3, var1);
        if (var1 instanceof EntityHuman) {
            var5.setCritArrow(true);
        }
        var5.setSoundEvent(SoundEffects.CROSSBOW_HIT);
        var5.setShotFromCrossbow(true);
        int var6 = EnchantmentManager.getItemEnchantmentLevel(Enchantments.PIERCING, var2);
        if (var6 > 0) {
            var5.setPierceLevel((byte)var6);
        }
        return var5;
    }

    public static void performShooting(World var0, EntityLiving var1, EnumHand var2, ItemStack var3, float var4, float var5) {
        List<ItemStack> var6 = ItemCrossbow.getChargedProjectiles(var3);
        float[] var7 = ItemCrossbow.getShotPitches(var1.getRandom());
        for (int var8 = 0; var8 < var6.size(); ++var8) {
            boolean var10;
            ItemStack var9 = var6.get(var8);
            boolean bl = var10 = var1 instanceof EntityHuman && ((EntityHuman)var1).getAbilities().instabuild;
            if (var9.isEmpty()) continue;
            if (var8 == 0) {
                ItemCrossbow.shootProjectile(var0, var1, var2, var3, var9, var7[var8], var10, var4, var5, 0.0f);
                continue;
            }
            if (var8 == 1) {
                ItemCrossbow.shootProjectile(var0, var1, var2, var3, var9, var7[var8], var10, var4, var5, -10.0f);
                continue;
            }
            if (var8 != 2) continue;
            ItemCrossbow.shootProjectile(var0, var1, var2, var3, var9, var7[var8], var10, var4, var5, 10.0f);
        }
        ItemCrossbow.onCrossbowShot(var0, var1, var3);
    }

    private static float[] getShotPitches(RandomSource var0) {
        boolean var1 = var0.nextBoolean();
        return new float[]{1.0f, ItemCrossbow.getRandomShotPitch(var1, var0), ItemCrossbow.getRandomShotPitch(!var1, var0)};
    }

    private static float getRandomShotPitch(boolean var0, RandomSource var1) {
        float var2 = var0 ? 0.63f : 0.43f;
        return 1.0f / (var1.nextFloat() * 0.5f + 1.8f) + var2;
    }

    private static void onCrossbowShot(World var0, EntityLiving var1, ItemStack var2) {
        if (var1 instanceof EntityPlayer) {
            EntityPlayer var3 = (EntityPlayer)var1;
            if (!var0.isClientSide) {
                CriterionTriggers.SHOT_CROSSBOW.trigger(var3, var2);
            }
            var3.awardStat(StatisticList.ITEM_USED.get(var2.getItem()));
        }
        ItemCrossbow.clearChargedProjectiles(var2);
    }

    @Override
    public void onUseTick(World var0, EntityLiving var1, ItemStack var2, int var3) {
        if (!var0.isClientSide) {
            int var4 = EnchantmentManager.getItemEnchantmentLevel(Enchantments.QUICK_CHARGE, var2);
            SoundEffect var5 = this.getStartSound(var4);
            SoundEffect var6 = var4 == 0 ? SoundEffects.CROSSBOW_LOADING_MIDDLE : null;
            float var7 = (float)(var2.getUseDuration() - var3) / (float)ItemCrossbow.getChargeDuration(var2);
            if (var7 < 0.2f) {
                this.startSoundPlayed = false;
                this.midLoadSoundPlayed = false;
            }
            if (var7 >= 0.2f && !this.startSoundPlayed) {
                this.startSoundPlayed = true;
                var0.playSound(null, var1.getX(), var1.getY(), var1.getZ(), var5, SoundCategory.PLAYERS, 0.5f, 1.0f);
            }
            if (var7 >= 0.5f && var6 != null && !this.midLoadSoundPlayed) {
                this.midLoadSoundPlayed = true;
                var0.playSound(null, var1.getX(), var1.getY(), var1.getZ(), var6, SoundCategory.PLAYERS, 0.5f, 1.0f);
            }
        }
    }

    @Override
    public int getUseDuration(ItemStack var0) {
        return ItemCrossbow.getChargeDuration(var0) + 3;
    }

    public static int getChargeDuration(ItemStack var0) {
        int var1 = EnchantmentManager.getItemEnchantmentLevel(Enchantments.QUICK_CHARGE, var0);
        return var1 == 0 ? 25 : 25 - 5 * var1;
    }

    @Override
    public EnumAnimation getUseAnimation(ItemStack var0) {
        return EnumAnimation.CROSSBOW;
    }

    private SoundEffect getStartSound(int var0) {
        switch (var0) {
            case 1: {
                return SoundEffects.CROSSBOW_QUICK_CHARGE_1;
            }
            case 2: {
                return SoundEffects.CROSSBOW_QUICK_CHARGE_2;
            }
            case 3: {
                return SoundEffects.CROSSBOW_QUICK_CHARGE_3;
            }
        }
        return SoundEffects.CROSSBOW_LOADING_START;
    }

    private static float getPowerForTime(int var0, ItemStack var1) {
        float var2 = (float)var0 / (float)ItemCrossbow.getChargeDuration(var1);
        if (var2 > 1.0f) {
            var2 = 1.0f;
        }
        return var2;
    }

    @Override
    public void appendHoverText(ItemStack var0, @Nullable World var1, List<IChatBaseComponent> var2, TooltipFlag var3) {
        List<ItemStack> var4 = ItemCrossbow.getChargedProjectiles(var0);
        if (!ItemCrossbow.isCharged(var0) || var4.isEmpty()) {
            return;
        }
        ItemStack var5 = var4.get(0);
        var2.add(IChatBaseComponent.translatable("item.minecraft.crossbow.projectile").append(CommonComponents.SPACE).append(var5.getDisplayName()));
        if (var3.isAdvanced() && var5.is(Items.FIREWORK_ROCKET)) {
            ArrayList var6 = Lists.newArrayList();
            Items.FIREWORK_ROCKET.appendHoverText(var5, var1, var6, var3);
            if (!var6.isEmpty()) {
                for (int var7 = 0; var7 < var6.size(); ++var7) {
                    var6.set(var7, IChatBaseComponent.literal("  ").append((IChatBaseComponent)var6.get(var7)).withStyle(EnumChatFormat.GRAY));
                }
                var2.addAll(var6);
            }
        }
    }

    @Override
    public boolean useOnRelease(ItemStack var0) {
        return var0.is(this);
    }

    @Override
    public int getDefaultProjectileRange() {
        return 8;
    }
}

