/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.animal.EntityFox;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;

public class ItemChorusFruit
extends Item {
    public ItemChorusFruit(Item.Info var0) {
        super(var0);
    }

    @Override
    public ItemStack finishUsingItem(ItemStack var0, World var1, EntityLiving var2) {
        ItemStack var3 = super.finishUsingItem(var0, var1, var2);
        if (!var1.isClientSide) {
            double var4 = var2.getX();
            double var6 = var2.getY();
            double var8 = var2.getZ();
            for (int var10 = 0; var10 < 16; ++var10) {
                double var11 = var2.getX() + (var2.getRandom().nextDouble() - 0.5) * 16.0;
                double var13 = MathHelper.clamp(var2.getY() + (double)(var2.getRandom().nextInt(16) - 8), (double)var1.getMinBuildHeight(), (double)(var1.getMinBuildHeight() + ((WorldServer)var1).getLogicalHeight() - 1));
                double var15 = var2.getZ() + (var2.getRandom().nextDouble() - 0.5) * 16.0;
                if (var2.isPassenger()) {
                    var2.stopRiding();
                }
                Vec3D var17 = var2.position();
                if (!var2.randomTeleport(var11, var13, var15, true)) continue;
                var1.gameEvent(GameEvent.TELEPORT, var17, GameEvent.a.of(var2));
                SoundEffect var18 = var2 instanceof EntityFox ? SoundEffects.FOX_TELEPORT : SoundEffects.CHORUS_FRUIT_TELEPORT;
                var1.playSound(null, var4, var6, var8, var18, SoundCategory.PLAYERS, 1.0f, 1.0f);
                var2.playSound(var18, 1.0f, 1.0f);
                var2.resetFallDistance();
                break;
            }
            if (var2 instanceof EntityHuman) {
                ((EntityHuman)var2).getCooldowns().addCooldown(this, 20);
            }
        }
        return var3;
    }
}

