/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.EnumMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.dispenser.DispenseBehaviorItem;
import net.minecraft.core.dispenser.IDispenseBehavior;
import net.minecraft.core.dispenser.SourceBlock;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.EnumHand;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.EnumArmorMaterial;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.phys.AxisAlignedBB;

public class ItemArmor
extends Item
implements Equipable {
    private static final EnumMap<a, UUID> ARMOR_MODIFIER_UUID_PER_TYPE = SystemUtils.make(new EnumMap(a.class), var0 -> {
        var0.put(a.BOOTS, UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"));
        var0.put(a.LEGGINGS, UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"));
        var0.put(a.CHESTPLATE, UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"));
        var0.put(a.HELMET, UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150"));
    });
    public static final IDispenseBehavior DISPENSE_ITEM_BEHAVIOR = new DispenseBehaviorItem(){

        @Override
        protected ItemStack execute(SourceBlock var0, ItemStack var1) {
            return ItemArmor.dispenseArmor(var0, var1) ? var1 : super.execute(var0, var1);
        }
    };
    protected final a type;
    private final int defense;
    private final float toughness;
    protected final float knockbackResistance;
    protected final ArmorMaterial material;
    private final Multimap<AttributeBase, AttributeModifier> defaultModifiers;

    public static boolean dispenseArmor(SourceBlock var0, ItemStack var1) {
        BlockPosition var2 = var0.pos().relative(var0.state().getValue(BlockDispenser.FACING));
        List<Entity> var3 = var0.level().getEntitiesOfClass(EntityLiving.class, new AxisAlignedBB(var2), IEntitySelector.NO_SPECTATORS.and(new IEntitySelector.EntitySelectorEquipable(var1)));
        if (var3.isEmpty()) {
            return false;
        }
        EntityLiving var4 = (EntityLiving)var3.get(0);
        EnumItemSlot var5 = EntityInsentient.getEquipmentSlotForItem(var1);
        ItemStack var6 = var1.split(1);
        var4.setItemSlot(var5, var6);
        if (var4 instanceof EntityInsentient) {
            ((EntityInsentient)var4).setDropChance(var5, 2.0f);
            ((EntityInsentient)var4).setPersistenceRequired();
        }
        return true;
    }

    public ItemArmor(ArmorMaterial var0, a var1, Item.Info var2) {
        super(var2.defaultDurability(var0.getDurabilityForType(var1)));
        this.material = var0;
        this.type = var1;
        this.defense = var0.getDefenseForType(var1);
        this.toughness = var0.getToughness();
        this.knockbackResistance = var0.getKnockbackResistance();
        BlockDispenser.registerBehavior(this, DISPENSE_ITEM_BEHAVIOR);
        ImmutableMultimap.Builder var3 = ImmutableMultimap.builder();
        UUID var4 = ARMOR_MODIFIER_UUID_PER_TYPE.get((Object)var1);
        var3.put((Object)GenericAttributes.ARMOR, (Object)new AttributeModifier(var4, "Armor modifier", (double)this.defense, AttributeModifier.Operation.ADDITION));
        var3.put((Object)GenericAttributes.ARMOR_TOUGHNESS, (Object)new AttributeModifier(var4, "Armor toughness", (double)this.toughness, AttributeModifier.Operation.ADDITION));
        if (var0 == EnumArmorMaterial.NETHERITE) {
            var3.put((Object)GenericAttributes.KNOCKBACK_RESISTANCE, (Object)new AttributeModifier(var4, "Armor knockback resistance", (double)this.knockbackResistance, AttributeModifier.Operation.ADDITION));
        }
        this.defaultModifiers = var3.build();
    }

    public a getType() {
        return this.type;
    }

    @Override
    public int getEnchantmentValue() {
        return this.material.getEnchantmentValue();
    }

    public ArmorMaterial getMaterial() {
        return this.material;
    }

    @Override
    public boolean isValidRepairItem(ItemStack var0, ItemStack var1) {
        return this.material.getRepairIngredient().test(var1) || super.isValidRepairItem(var0, var1);
    }

    @Override
    public InteractionResultWrapper<ItemStack> use(World var0, EntityHuman var1, EnumHand var2) {
        return this.swapWithEquipmentSlot(this, var0, var1, var2);
    }

    @Override
    public Multimap<AttributeBase, AttributeModifier> getDefaultAttributeModifiers(EnumItemSlot var0) {
        if (var0 == this.type.getSlot()) {
            return this.defaultModifiers;
        }
        return super.getDefaultAttributeModifiers(var0);
    }

    public int getDefense() {
        return this.defense;
    }

    public float getToughness() {
        return this.toughness;
    }

    @Override
    public EnumItemSlot getEquipmentSlot() {
        return this.type.getSlot();
    }

    @Override
    public SoundEffect getEquipSound() {
        return this.getMaterial().getEquipSound();
    }

    public static final class a
    extends Enum<a> {
        public static final /* enum */ a HELMET = new a(EnumItemSlot.HEAD, "helmet");
        public static final /* enum */ a CHESTPLATE = new a(EnumItemSlot.CHEST, "chestplate");
        public static final /* enum */ a LEGGINGS = new a(EnumItemSlot.LEGS, "leggings");
        public static final /* enum */ a BOOTS = new a(EnumItemSlot.FEET, "boots");
        private final EnumItemSlot slot;
        private final String name;
        private static final /* synthetic */ a[] g;

        public static a[] values() {
            return (a[])g.clone();
        }

        public static a valueOf(String var0) {
            return Enum.valueOf(a.class, var0);
        }

        private a(EnumItemSlot var2, String var3) {
            this.slot = var2;
            this.name = var3;
        }

        public EnumItemSlot getSlot() {
            return this.slot;
        }

        public String getName() {
            return this.name;
        }

        private static /* synthetic */ a[] c() {
            return new a[]{HELMET, CHESTPLATE, LEGGINGS, BOOTS};
        }

        static {
            g = a.c();
        }
    }
}

