/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.entity.player.AutoRecipeStackManager;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.item.ItemStack;

public class TransientCraftingContainer
implements InventoryCrafting {
    private final NonNullList<ItemStack> items;
    private final int width;
    private final int height;
    private final Container menu;

    public TransientCraftingContainer(Container var0, int var1, int var2) {
        this(var0, var1, var2, NonNullList.withSize(var1 * var2, ItemStack.EMPTY));
    }

    public TransientCraftingContainer(Container var0, int var1, int var2, NonNullList<ItemStack> var3) {
        this.items = var3;
        this.menu = var0;
        this.width = var1;
        this.height = var2;
    }

    @Override
    public int getContainerSize() {
        return this.items.size();
    }

    @Override
    public boolean isEmpty() {
        for (ItemStack var1 : this.items) {
            if (var1.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ItemStack getItem(int var0) {
        if (var0 >= this.getContainerSize()) {
            return ItemStack.EMPTY;
        }
        return this.items.get(var0);
    }

    @Override
    public ItemStack removeItemNoUpdate(int var0) {
        return ContainerUtil.takeItem(this.items, var0);
    }

    @Override
    public ItemStack removeItem(int var0, int var1) {
        ItemStack var2 = ContainerUtil.removeItem(this.items, var0, var1);
        if (!var2.isEmpty()) {
            this.menu.slotsChanged(this);
        }
        return var2;
    }

    @Override
    public void setItem(int var0, ItemStack var1) {
        this.items.set(var0, var1);
        this.menu.slotsChanged(this);
    }

    @Override
    public void setChanged() {
    }

    @Override
    public boolean stillValid(EntityHuman var0) {
        return true;
    }

    @Override
    public void clearContent() {
        this.items.clear();
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public List<ItemStack> getItems() {
        return List.copyOf(this.items);
    }

    @Override
    public void fillStackedContents(AutoRecipeStackManager var0) {
        for (ItemStack var2 : this.items) {
            var0.accountSimpleStack(var2);
        }
    }
}

