/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;

public interface RecipeCraftingHolder {
    public void setRecipeUsed(@Nullable RecipeHolder<?> var1);

    @Nullable
    public RecipeHolder<?> getRecipeUsed();

    default public void awardUsedRecipes(EntityHuman var0, List<ItemStack> var1) {
        RecipeHolder<?> var2 = this.getRecipeUsed();
        if (var2 != null) {
            var0.triggerRecipeCrafted(var2, var1);
            if (!var2.value().isSpecial()) {
                var0.awardRecipes(Collections.singleton(var2));
                this.setRecipeUsed(null);
            }
        }
    }

    default public boolean setRecipeUsed(World var0, EntityPlayer var1, RecipeHolder<?> var2) {
        if (var2.value().isSpecial() || !var0.getGameRules().getBoolean(GameRules.RULE_LIMITED_CRAFTING) || var1.getRecipeBook().contains(var2)) {
            this.setRecipeUsed(var2);
            return true;
        }
        return false;
    }
}

