/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAnvil;
import net.minecraft.world.inventory.ContainerBeacon;
import net.minecraft.world.inventory.ContainerBlastFurnace;
import net.minecraft.world.inventory.ContainerBrewingStand;
import net.minecraft.world.inventory.ContainerCartography;
import net.minecraft.world.inventory.ContainerChest;
import net.minecraft.world.inventory.ContainerDispenser;
import net.minecraft.world.inventory.ContainerEnchantTable;
import net.minecraft.world.inventory.ContainerFurnaceFurnace;
import net.minecraft.world.inventory.ContainerGrindstone;
import net.minecraft.world.inventory.ContainerHopper;
import net.minecraft.world.inventory.ContainerLectern;
import net.minecraft.world.inventory.ContainerLoom;
import net.minecraft.world.inventory.ContainerMerchant;
import net.minecraft.world.inventory.ContainerShulkerBox;
import net.minecraft.world.inventory.ContainerSmithing;
import net.minecraft.world.inventory.ContainerSmoker;
import net.minecraft.world.inventory.ContainerStonecutter;
import net.minecraft.world.inventory.ContainerWorkbench;

public class Containers<T extends Container>
implements FeatureElement {
    public static final Containers<ContainerChest> GENERIC_9x1 = Containers.register("generic_9x1", ContainerChest::oneRow);
    public static final Containers<ContainerChest> GENERIC_9x2 = Containers.register("generic_9x2", ContainerChest::twoRows);
    public static final Containers<ContainerChest> GENERIC_9x3 = Containers.register("generic_9x3", ContainerChest::threeRows);
    public static final Containers<ContainerChest> GENERIC_9x4 = Containers.register("generic_9x4", ContainerChest::fourRows);
    public static final Containers<ContainerChest> GENERIC_9x5 = Containers.register("generic_9x5", ContainerChest::fiveRows);
    public static final Containers<ContainerChest> GENERIC_9x6 = Containers.register("generic_9x6", ContainerChest::sixRows);
    public static final Containers<ContainerDispenser> GENERIC_3x3 = Containers.register("generic_3x3", ContainerDispenser::new);
    public static final Containers<ContainerAnvil> ANVIL = Containers.register("anvil", ContainerAnvil::new);
    public static final Containers<ContainerBeacon> BEACON = Containers.register("beacon", ContainerBeacon::new);
    public static final Containers<ContainerBlastFurnace> BLAST_FURNACE = Containers.register("blast_furnace", ContainerBlastFurnace::new);
    public static final Containers<ContainerBrewingStand> BREWING_STAND = Containers.register("brewing_stand", ContainerBrewingStand::new);
    public static final Containers<ContainerWorkbench> CRAFTING = Containers.register("crafting", ContainerWorkbench::new);
    public static final Containers<ContainerEnchantTable> ENCHANTMENT = Containers.register("enchantment", ContainerEnchantTable::new);
    public static final Containers<ContainerFurnaceFurnace> FURNACE = Containers.register("furnace", ContainerFurnaceFurnace::new);
    public static final Containers<ContainerGrindstone> GRINDSTONE = Containers.register("grindstone", ContainerGrindstone::new);
    public static final Containers<ContainerHopper> HOPPER = Containers.register("hopper", ContainerHopper::new);
    public static final Containers<ContainerLectern> LECTERN = Containers.register("lectern", (var0, var1) -> new ContainerLectern(var0));
    public static final Containers<ContainerLoom> LOOM = Containers.register("loom", ContainerLoom::new);
    public static final Containers<ContainerMerchant> MERCHANT = Containers.register("merchant", ContainerMerchant::new);
    public static final Containers<ContainerShulkerBox> SHULKER_BOX = Containers.register("shulker_box", ContainerShulkerBox::new);
    public static final Containers<ContainerSmithing> SMITHING = Containers.register("smithing", ContainerSmithing::new);
    public static final Containers<ContainerSmoker> SMOKER = Containers.register("smoker", ContainerSmoker::new);
    public static final Containers<ContainerCartography> CARTOGRAPHY_TABLE = Containers.register("cartography_table", ContainerCartography::new);
    public static final Containers<ContainerStonecutter> STONECUTTER = Containers.register("stonecutter", ContainerStonecutter::new);
    private final FeatureFlagSet requiredFeatures;
    private final Supplier<T> constructor;

    private static <T extends Container> Containers<T> register(String var0, Supplier<T> var1) {
        return IRegistry.register(BuiltInRegistries.MENU, var0, new Containers<T>(var1, FeatureFlags.VANILLA_SET));
    }

    private static <T extends Container> Containers<T> register(String var0, Supplier<T> var1, FeatureFlag ... var2) {
        return IRegistry.register(BuiltInRegistries.MENU, var0, new Containers<T>(var1, FeatureFlags.REGISTRY.subset(var2)));
    }

    private Containers(Supplier<T> var0, FeatureFlagSet var1) {
        this.constructor = var0;
        this.requiredFeatures = var1;
    }

    public T create(int var0, PlayerInventory var1) {
        return this.constructor.create(var0, var1);
    }

    @Override
    public FeatureFlagSet requiredFeatures() {
        return this.requiredFeatures;
    }

    static interface Supplier<T extends Container> {
        public T create(int var1, PlayerInventory var2);
    }
}

