/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.EntityVillagerTrader;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartChest;
import net.minecraft.world.entity.vehicle.EntityMinecartCommandBlock;
import net.minecraft.world.entity.vehicle.EntityMinecartFurnace;
import net.minecraft.world.entity.vehicle.EntityMinecartHopper;
import net.minecraft.world.entity.vehicle.EntityMinecartMobSpawner;
import net.minecraft.world.entity.vehicle.EntityMinecartRideable;
import net.minecraft.world.entity.vehicle.EntityMinecartTNT;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockMinecartTrackAbstract;
import net.minecraft.world.level.block.BlockPoweredRail;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyTrackPosition;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.joml.Vector3f;

public abstract class EntityMinecartAbstract
extends Entity {
    private static final float LOWERED_PASSENGER_ATTACHMENT_Y = 0.0f;
    private static final float PASSENGER_ATTACHMENT_Y = 0.1875f;
    private static final DataWatcherObject<Integer> DATA_ID_HURT = DataWatcher.defineId(EntityMinecartAbstract.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<Integer> DATA_ID_HURTDIR = DataWatcher.defineId(EntityMinecartAbstract.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<Float> DATA_ID_DAMAGE = DataWatcher.defineId(EntityMinecartAbstract.class, DataWatcherRegistry.FLOAT);
    private static final DataWatcherObject<Integer> DATA_ID_DISPLAY_BLOCK = DataWatcher.defineId(EntityMinecartAbstract.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<Integer> DATA_ID_DISPLAY_OFFSET = DataWatcher.defineId(EntityMinecartAbstract.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<Boolean> DATA_ID_CUSTOM_DISPLAY = DataWatcher.defineId(EntityMinecartAbstract.class, DataWatcherRegistry.BOOLEAN);
    private static final ImmutableMap<EntityPose, ImmutableList<Integer>> POSE_DISMOUNT_HEIGHTS = ImmutableMap.of((Object)((Object)EntityPose.STANDING), (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)((Object)EntityPose.CROUCHING), (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)((Object)EntityPose.SWIMMING), (Object)ImmutableList.of((Object)0, (Object)1));
    protected static final float WATER_SLOWDOWN_FACTOR = 0.95f;
    private boolean flipped;
    private boolean onRails;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYRot;
    private double lerpXRot;
    private Vec3D targetDeltaMovement = Vec3D.ZERO;
    private static final Map<BlockPropertyTrackPosition, Pair<BaseBlockPosition, BaseBlockPosition>> EXITS = SystemUtils.make(Maps.newEnumMap(BlockPropertyTrackPosition.class), var0 -> {
        BaseBlockPosition var1 = EnumDirection.WEST.getNormal();
        BaseBlockPosition var2 = EnumDirection.EAST.getNormal();
        BaseBlockPosition var3 = EnumDirection.NORTH.getNormal();
        BaseBlockPosition var4 = EnumDirection.SOUTH.getNormal();
        BaseBlockPosition var5 = var1.below();
        BaseBlockPosition var6 = var2.below();
        BaseBlockPosition var7 = var3.below();
        BaseBlockPosition var8 = var4.below();
        var0.put(BlockPropertyTrackPosition.NORTH_SOUTH, Pair.of((Object)var3, (Object)var4));
        var0.put(BlockPropertyTrackPosition.EAST_WEST, Pair.of((Object)var1, (Object)var2));
        var0.put(BlockPropertyTrackPosition.ASCENDING_EAST, Pair.of((Object)var5, (Object)var2));
        var0.put(BlockPropertyTrackPosition.ASCENDING_WEST, Pair.of((Object)var1, (Object)var6));
        var0.put(BlockPropertyTrackPosition.ASCENDING_NORTH, Pair.of((Object)var3, (Object)var8));
        var0.put(BlockPropertyTrackPosition.ASCENDING_SOUTH, Pair.of((Object)var7, (Object)var4));
        var0.put(BlockPropertyTrackPosition.SOUTH_EAST, Pair.of((Object)var4, (Object)var2));
        var0.put(BlockPropertyTrackPosition.SOUTH_WEST, Pair.of((Object)var4, (Object)var1));
        var0.put(BlockPropertyTrackPosition.NORTH_WEST, Pair.of((Object)var3, (Object)var1));
        var0.put(BlockPropertyTrackPosition.NORTH_EAST, Pair.of((Object)var3, (Object)var2));
    });

    protected EntityMinecartAbstract(EntityTypes<?> var0, World var1) {
        super(var0, var1);
        this.blocksBuilding = true;
    }

    protected EntityMinecartAbstract(EntityTypes<?> var0, World var1, double var2, double var4, double var6) {
        this(var0, var1);
        this.setPos(var2, var4, var6);
        this.xo = var2;
        this.yo = var4;
        this.zo = var6;
    }

    public static EntityMinecartAbstract createMinecart(World var0, double var1, double var3, double var5, EnumMinecartType var7) {
        if (var7 == EnumMinecartType.CHEST) {
            return new EntityMinecartChest(var0, var1, var3, var5);
        }
        if (var7 == EnumMinecartType.FURNACE) {
            return new EntityMinecartFurnace(var0, var1, var3, var5);
        }
        if (var7 == EnumMinecartType.TNT) {
            return new EntityMinecartTNT(var0, var1, var3, var5);
        }
        if (var7 == EnumMinecartType.SPAWNER) {
            return new EntityMinecartMobSpawner(var0, var1, var3, var5);
        }
        if (var7 == EnumMinecartType.HOPPER) {
            return new EntityMinecartHopper(var0, var1, var3, var5);
        }
        if (var7 == EnumMinecartType.COMMAND_BLOCK) {
            return new EntityMinecartCommandBlock(var0, var1, var3, var5);
        }
        return new EntityMinecartRideable(var0, var1, var3, var5);
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.EVENTS;
    }

    @Override
    protected void defineSynchedData() {
        this.entityData.define(DATA_ID_HURT, 0);
        this.entityData.define(DATA_ID_HURTDIR, 1);
        this.entityData.define(DATA_ID_DAMAGE, Float.valueOf(0.0f));
        this.entityData.define(DATA_ID_DISPLAY_BLOCK, Block.getId(Blocks.AIR.defaultBlockState()));
        this.entityData.define(DATA_ID_DISPLAY_OFFSET, 6);
        this.entityData.define(DATA_ID_CUSTOM_DISPLAY, false);
    }

    @Override
    public boolean canCollideWith(Entity var0) {
        return EntityBoat.canVehicleCollide(this, var0);
    }

    @Override
    public boolean isPushable() {
        return true;
    }

    @Override
    protected Vec3D getRelativePortalPosition(EnumDirection.EnumAxis var0, BlockUtil.Rectangle var1) {
        return EntityLiving.resetForwardDirectionOfRelativePortalPosition(super.getRelativePortalPosition(var0, var1));
    }

    @Override
    protected Vector3f getPassengerAttachmentPoint(Entity var0, EntitySize var1, float var2) {
        boolean var3 = var0 instanceof EntityVillager || var0 instanceof EntityVillagerTrader;
        return new Vector3f(0.0f, var3 ? 0.0f : 0.1875f, 0.0f);
    }

    @Override
    public Vec3D getDismountLocationForPassenger(EntityLiving var02) {
        EnumDirection var1 = this.getMotionDirection();
        if (var1.getAxis() == EnumDirection.EnumAxis.Y) {
            return super.getDismountLocationForPassenger(var02);
        }
        int[][] var2 = DismountUtil.offsetsForDirection(var1);
        BlockPosition var3 = this.blockPosition();
        BlockPosition.MutableBlockPosition var4 = new BlockPosition.MutableBlockPosition();
        ImmutableList<EntityPose> var5 = var02.getDismountPoses();
        for (EntityPose var7 : var5) {
            EntitySize var8 = var02.getDimensions(var7);
            float var9 = Math.min(var8.width, 1.0f) / 2.0f;
            UnmodifiableIterator unmodifiableIterator = ((ImmutableList)POSE_DISMOUNT_HEIGHTS.get((Object)var7)).iterator();
            while (unmodifiableIterator.hasNext()) {
                int var11 = (Integer)unmodifiableIterator.next();
                for (int[] var15 : var2) {
                    var4.set(var3.getX() + var15[0], var3.getY() + var11, var3.getZ() + var15[1]);
                    double var16 = this.level().getBlockFloorHeight(DismountUtil.nonClimbableShape(this.level(), var4), () -> DismountUtil.nonClimbableShape(this.level(), (BlockPosition)var4.below()));
                    if (!DismountUtil.isBlockFloorValid(var16)) continue;
                    AxisAlignedBB var18 = new AxisAlignedBB(-var9, 0.0, -var9, var9, var8.height, var9);
                    Vec3D var19 = Vec3D.upFromBottomCenterOf(var4, var16);
                    if (!DismountUtil.canDismountTo(this.level(), var02, var18.move(var19))) continue;
                    var02.setPose(var7);
                    return var19;
                }
            }
        }
        double var6 = this.getBoundingBox().maxY;
        var4.set((double)var3.getX(), var6, (double)var3.getZ());
        for (EntityPose var9 : var5) {
            double var10 = var02.getDimensions((EntityPose)var9).height;
            int var12 = MathHelper.ceil(var6 - (double)var4.getY() + var10);
            double var13 = DismountUtil.findCeilingFrom(var4, var12, var0 -> this.level().getBlockState((BlockPosition)var0).getCollisionShape(this.level(), (BlockPosition)var0));
            if (!(var6 + var10 <= var13)) continue;
            var02.setPose(var9);
            break;
        }
        return super.getDismountLocationForPassenger(var02);
    }

    @Override
    public boolean hurt(DamageSource var0, float var1) {
        boolean var2;
        if (this.level().isClientSide || this.isRemoved()) {
            return true;
        }
        if (this.isInvulnerableTo(var0)) {
            return false;
        }
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.markHurt();
        this.setDamage(this.getDamage() + var1 * 10.0f);
        this.gameEvent(GameEvent.ENTITY_DAMAGE, var0.getEntity());
        boolean bl = var2 = var0.getEntity() instanceof EntityHuman && ((EntityHuman)var0.getEntity()).getAbilities().instabuild;
        if (var2 || this.getDamage() > 40.0f) {
            this.ejectPassengers();
            if (!var2 || this.hasCustomName()) {
                this.destroy(var0);
            } else {
                this.discard();
            }
        }
        return true;
    }

    @Override
    protected float getBlockSpeedFactor() {
        IBlockData var0 = this.level().getBlockState(this.blockPosition());
        if (var0.is(TagsBlock.RAILS)) {
            return 1.0f;
        }
        return super.getBlockSpeedFactor();
    }

    public void destroy(DamageSource var0) {
        this.kill();
        if (this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            ItemStack var1 = new ItemStack(this.getDropItem());
            if (this.hasCustomName()) {
                var1.setHoverName(this.getCustomName());
            }
            this.spawnAtLocation(var1);
        }
    }

    abstract Item getDropItem();

    @Override
    public void animateHurt(float var0) {
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.setDamage(this.getDamage() + this.getDamage() * 10.0f);
    }

    @Override
    public boolean isPickable() {
        return !this.isRemoved();
    }

    private static Pair<BaseBlockPosition, BaseBlockPosition> exits(BlockPropertyTrackPosition var0) {
        return EXITS.get(var0);
    }

    @Override
    public EnumDirection getMotionDirection() {
        return this.flipped ? this.getDirection().getOpposite().getClockWise() : this.getDirection().getClockWise();
    }

    @Override
    public void tick() {
        double var9;
        if (this.getHurtTime() > 0) {
            this.setHurtTime(this.getHurtTime() - 1);
        }
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 1.0f);
        }
        this.checkBelowWorld();
        this.handleNetherPortal();
        if (this.level().isClientSide) {
            if (this.lerpSteps > 0) {
                this.lerpPositionAndRotationStep(this.lerpSteps, this.lerpX, this.lerpY, this.lerpZ, this.lerpYRot, this.lerpXRot);
                --this.lerpSteps;
            } else {
                this.reapplyPosition();
                this.setRot(this.getYRot(), this.getXRot());
            }
            return;
        }
        if (!this.isNoGravity()) {
            double var0 = this.isInWater() ? -0.005 : -0.04;
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, var0, 0.0));
        }
        int var0 = MathHelper.floor(this.getX());
        int var1 = MathHelper.floor(this.getY());
        int var2 = MathHelper.floor(this.getZ());
        if (this.level().getBlockState(new BlockPosition(var0, var1 - 1, var2)).is(TagsBlock.RAILS)) {
            --var1;
        }
        BlockPosition var3 = new BlockPosition(var0, var1, var2);
        IBlockData var4 = this.level().getBlockState(var3);
        this.onRails = BlockMinecartTrackAbstract.isRail(var4);
        if (this.onRails) {
            this.moveAlongTrack(var3, var4);
            if (var4.is(Blocks.ACTIVATOR_RAIL)) {
                this.activateMinecart(var0, var1, var2, var4.getValue(BlockPoweredRail.POWERED));
            }
        } else {
            this.comeOffTrack();
        }
        this.checkInsideBlocks();
        this.setXRot(0.0f);
        double var5 = this.xo - this.getX();
        double var7 = this.zo - this.getZ();
        if (var5 * var5 + var7 * var7 > 0.001) {
            this.setYRot((float)(MathHelper.atan2(var7, var5) * 180.0 / Math.PI));
            if (this.flipped) {
                this.setYRot(this.getYRot() + 180.0f);
            }
        }
        if ((var9 = (double)MathHelper.wrapDegrees(this.getYRot() - this.yRotO)) < -170.0 || var9 >= 170.0) {
            this.setYRot(this.getYRot() + 180.0f);
            this.flipped = !this.flipped;
        }
        this.setRot(this.getYRot(), this.getXRot());
        if (this.getMinecartType() == EnumMinecartType.RIDEABLE && this.getDeltaMovement().horizontalDistanceSqr() > 0.01) {
            List<Entity> var11 = this.level().getEntities(this, this.getBoundingBox().inflate(0.2f, 0.0, 0.2f), IEntitySelector.pushableBy(this));
            if (!var11.isEmpty()) {
                for (Entity var13 : var11) {
                    if (var13 instanceof EntityHuman || var13 instanceof EntityIronGolem || var13 instanceof EntityMinecartAbstract || this.isVehicle() || var13.isPassenger()) {
                        var13.push(this);
                        continue;
                    }
                    var13.startRiding(this);
                }
            }
        } else {
            for (Entity var12 : this.level().getEntities(this, this.getBoundingBox().inflate(0.2f, 0.0, 0.2f))) {
                if (this.hasPassenger(var12) || !var12.isPushable() || !(var12 instanceof EntityMinecartAbstract)) continue;
                var12.push(this);
            }
        }
        this.updateInWaterStateAndDoFluidPushing();
        if (this.isInLava()) {
            this.lavaHurt();
            this.fallDistance *= 0.5f;
        }
        this.firstTick = false;
    }

    protected double getMaxSpeed() {
        return (this.isInWater() ? 4.0 : 8.0) / 20.0;
    }

    public void activateMinecart(int var0, int var1, int var2, boolean var3) {
    }

    protected void comeOffTrack() {
        double var0 = this.getMaxSpeed();
        Vec3D var2 = this.getDeltaMovement();
        this.setDeltaMovement(MathHelper.clamp(var2.x, -var0, var0), var2.y, MathHelper.clamp(var2.z, -var0, var0));
        if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().scale(0.5));
        }
        this.move(EnumMoveType.SELF, this.getDeltaMovement());
        if (!this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().scale(0.95));
        }
    }

    protected void moveAlongTrack(BlockPosition var0, IBlockData var1) {
        double var47;
        Vec3D var46;
        double var41;
        double var39;
        double var37;
        this.resetFallDistance();
        double var2 = this.getX();
        double var4 = this.getY();
        double var6 = this.getZ();
        Vec3D var8 = this.getPos(var2, var4, var6);
        var4 = var0.getY();
        boolean var9 = false;
        boolean var10 = false;
        if (var1.is(Blocks.POWERED_RAIL)) {
            var9 = var1.getValue(BlockPoweredRail.POWERED);
            var10 = !var9;
        }
        double var11 = 0.0078125;
        if (this.isInWater()) {
            var11 *= 0.2;
        }
        Vec3D var13 = this.getDeltaMovement();
        BlockPropertyTrackPosition var14 = var1.getValue(((BlockMinecartTrackAbstract)var1.getBlock()).getShapeProperty());
        switch (var14) {
            case ASCENDING_EAST: {
                this.setDeltaMovement(var13.add(-var11, 0.0, 0.0));
                var4 += 1.0;
                break;
            }
            case ASCENDING_WEST: {
                this.setDeltaMovement(var13.add(var11, 0.0, 0.0));
                var4 += 1.0;
                break;
            }
            case ASCENDING_NORTH: {
                this.setDeltaMovement(var13.add(0.0, 0.0, var11));
                var4 += 1.0;
                break;
            }
            case ASCENDING_SOUTH: {
                this.setDeltaMovement(var13.add(0.0, 0.0, -var11));
                var4 += 1.0;
            }
        }
        var13 = this.getDeltaMovement();
        Pair<BaseBlockPosition, BaseBlockPosition> var15 = EntityMinecartAbstract.exits(var14);
        BaseBlockPosition var16 = (BaseBlockPosition)var15.getFirst();
        BaseBlockPosition var17 = (BaseBlockPosition)var15.getSecond();
        double var18 = var17.getX() - var16.getX();
        double var20 = var17.getZ() - var16.getZ();
        double var22 = Math.sqrt(var18 * var18 + var20 * var20);
        double var24 = var13.x * var18 + var13.z * var20;
        if (var24 < 0.0) {
            var18 = -var18;
            var20 = -var20;
        }
        double var26 = Math.min(2.0, var13.horizontalDistance());
        var13 = new Vec3D(var26 * var18 / var22, var13.y, var26 * var20 / var22);
        this.setDeltaMovement(var13);
        Entity var28 = this.getFirstPassenger();
        if (var28 instanceof EntityHuman) {
            Vec3D var29 = var28.getDeltaMovement();
            double var30 = var29.horizontalDistanceSqr();
            double var32 = this.getDeltaMovement().horizontalDistanceSqr();
            if (var30 > 1.0E-4 && var32 < 0.01) {
                this.setDeltaMovement(this.getDeltaMovement().add(var29.x * 0.1, 0.0, var29.z * 0.1));
                var10 = false;
            }
        }
        if (var10) {
            double var29 = this.getDeltaMovement().horizontalDistance();
            if (var29 < 0.03) {
                this.setDeltaMovement(Vec3D.ZERO);
            } else {
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.5, 0.0, 0.5));
            }
        }
        double var29 = (double)var0.getX() + 0.5 + (double)var16.getX() * 0.5;
        double var31 = (double)var0.getZ() + 0.5 + (double)var16.getZ() * 0.5;
        double var33 = (double)var0.getX() + 0.5 + (double)var17.getX() * 0.5;
        double var35 = (double)var0.getZ() + 0.5 + (double)var17.getZ() * 0.5;
        var18 = var33 - var29;
        var20 = var35 - var31;
        if (var18 == 0.0) {
            var37 = var6 - (double)var0.getZ();
        } else if (var20 == 0.0) {
            var37 = var2 - (double)var0.getX();
        } else {
            var39 = var2 - var29;
            var41 = var6 - var31;
            var37 = (var39 * var18 + var41 * var20) * 2.0;
        }
        var2 = var29 + var18 * var37;
        var6 = var31 + var20 * var37;
        this.setPos(var2, var4, var6);
        var39 = this.isVehicle() ? 0.75 : 1.0;
        var41 = this.getMaxSpeed();
        var13 = this.getDeltaMovement();
        this.move(EnumMoveType.SELF, new Vec3D(MathHelper.clamp(var39 * var13.x, -var41, var41), 0.0, MathHelper.clamp(var39 * var13.z, -var41, var41)));
        if (var16.getY() != 0 && MathHelper.floor(this.getX()) - var0.getX() == var16.getX() && MathHelper.floor(this.getZ()) - var0.getZ() == var16.getZ()) {
            this.setPos(this.getX(), this.getY() + (double)var16.getY(), this.getZ());
        } else if (var17.getY() != 0 && MathHelper.floor(this.getX()) - var0.getX() == var17.getX() && MathHelper.floor(this.getZ()) - var0.getZ() == var17.getZ()) {
            this.setPos(this.getX(), this.getY() + (double)var17.getY(), this.getZ());
        }
        this.applyNaturalSlowdown();
        Vec3D var43 = this.getPos(this.getX(), this.getY(), this.getZ());
        if (var43 != null && var8 != null) {
            double var44 = (var8.y - var43.y) * 0.05;
            var46 = this.getDeltaMovement();
            var47 = var46.horizontalDistance();
            if (var47 > 0.0) {
                this.setDeltaMovement(var46.multiply((var47 + var44) / var47, 1.0, (var47 + var44) / var47));
            }
            this.setPos(this.getX(), var43.y, this.getZ());
        }
        int var44 = MathHelper.floor(this.getX());
        int var45 = MathHelper.floor(this.getZ());
        if (var44 != var0.getX() || var45 != var0.getZ()) {
            var46 = this.getDeltaMovement();
            var47 = var46.horizontalDistance();
            this.setDeltaMovement(var47 * (double)(var44 - var0.getX()), var46.y, var47 * (double)(var45 - var0.getZ()));
        }
        if (var9) {
            var46 = this.getDeltaMovement();
            var47 = var46.horizontalDistance();
            if (var47 > 0.01) {
                double var49 = 0.06;
                this.setDeltaMovement(var46.add(var46.x / var47 * 0.06, 0.0, var46.z / var47 * 0.06));
            } else {
                Vec3D var49 = this.getDeltaMovement();
                double var50 = var49.x;
                double var52 = var49.z;
                if (var14 == BlockPropertyTrackPosition.EAST_WEST) {
                    if (this.isRedstoneConductor(var0.west())) {
                        var50 = 0.02;
                    } else if (this.isRedstoneConductor(var0.east())) {
                        var50 = -0.02;
                    }
                } else if (var14 == BlockPropertyTrackPosition.NORTH_SOUTH) {
                    if (this.isRedstoneConductor(var0.north())) {
                        var52 = 0.02;
                    } else if (this.isRedstoneConductor(var0.south())) {
                        var52 = -0.02;
                    }
                } else {
                    return;
                }
                this.setDeltaMovement(var50, var49.y, var52);
            }
        }
    }

    @Override
    public boolean isOnRails() {
        return this.onRails;
    }

    private boolean isRedstoneConductor(BlockPosition var0) {
        return this.level().getBlockState(var0).isRedstoneConductor(this.level(), var0);
    }

    protected void applyNaturalSlowdown() {
        double var0 = this.isVehicle() ? 0.997 : 0.96;
        Vec3D var2 = this.getDeltaMovement();
        var2 = var2.multiply(var0, 0.0, var0);
        if (this.isInWater()) {
            var2 = var2.scale(0.95f);
        }
        this.setDeltaMovement(var2);
    }

    @Nullable
    public Vec3D getPosOffs(double var0, double var2, double var4, double var6) {
        IBlockData var11;
        int var8 = MathHelper.floor(var0);
        int var9 = MathHelper.floor(var2);
        int var10 = MathHelper.floor(var4);
        if (this.level().getBlockState(new BlockPosition(var8, var9 - 1, var10)).is(TagsBlock.RAILS)) {
            --var9;
        }
        if (BlockMinecartTrackAbstract.isRail(var11 = this.level().getBlockState(new BlockPosition(var8, var9, var10)))) {
            BlockPropertyTrackPosition var12 = var11.getValue(((BlockMinecartTrackAbstract)var11.getBlock()).getShapeProperty());
            var2 = var9;
            if (var12.isAscending()) {
                var2 = var9 + 1;
            }
            Pair<BaseBlockPosition, BaseBlockPosition> var13 = EntityMinecartAbstract.exits(var12);
            BaseBlockPosition var14 = (BaseBlockPosition)var13.getFirst();
            BaseBlockPosition var15 = (BaseBlockPosition)var13.getSecond();
            double var16 = var15.getX() - var14.getX();
            double var18 = var15.getZ() - var14.getZ();
            double var20 = Math.sqrt(var16 * var16 + var18 * var18);
            if (var14.getY() != 0 && MathHelper.floor(var0 += (var16 /= var20) * var6) - var8 == var14.getX() && MathHelper.floor(var4 += (var18 /= var20) * var6) - var10 == var14.getZ()) {
                var2 += (double)var14.getY();
            } else if (var15.getY() != 0 && MathHelper.floor(var0) - var8 == var15.getX() && MathHelper.floor(var4) - var10 == var15.getZ()) {
                var2 += (double)var15.getY();
            }
            return this.getPos(var0, var2, var4);
        }
        return null;
    }

    @Nullable
    public Vec3D getPos(double var0, double var2, double var4) {
        IBlockData var9;
        int var6 = MathHelper.floor(var0);
        int var7 = MathHelper.floor(var2);
        int var8 = MathHelper.floor(var4);
        if (this.level().getBlockState(new BlockPosition(var6, var7 - 1, var8)).is(TagsBlock.RAILS)) {
            --var7;
        }
        if (BlockMinecartTrackAbstract.isRail(var9 = this.level().getBlockState(new BlockPosition(var6, var7, var8)))) {
            double var32;
            BlockPropertyTrackPosition var10 = var9.getValue(((BlockMinecartTrackAbstract)var9.getBlock()).getShapeProperty());
            Pair<BaseBlockPosition, BaseBlockPosition> var11 = EntityMinecartAbstract.exits(var10);
            BaseBlockPosition var12 = (BaseBlockPosition)var11.getFirst();
            BaseBlockPosition var13 = (BaseBlockPosition)var11.getSecond();
            double var14 = (double)var6 + 0.5 + (double)var12.getX() * 0.5;
            double var16 = (double)var7 + 0.0625 + (double)var12.getY() * 0.5;
            double var18 = (double)var8 + 0.5 + (double)var12.getZ() * 0.5;
            double var20 = (double)var6 + 0.5 + (double)var13.getX() * 0.5;
            double var22 = (double)var7 + 0.0625 + (double)var13.getY() * 0.5;
            double var24 = (double)var8 + 0.5 + (double)var13.getZ() * 0.5;
            double var26 = var20 - var14;
            double var28 = (var22 - var16) * 2.0;
            double var30 = var24 - var18;
            if (var26 == 0.0) {
                var32 = var4 - (double)var8;
            } else if (var30 == 0.0) {
                var32 = var0 - (double)var6;
            } else {
                double var34 = var0 - var14;
                double var36 = var4 - var18;
                var32 = (var34 * var26 + var36 * var30) * 2.0;
            }
            var0 = var14 + var26 * var32;
            var2 = var16 + var28 * var32;
            var4 = var18 + var30 * var32;
            if (var28 < 0.0) {
                var2 += 1.0;
            } else if (var28 > 0.0) {
                var2 += 0.5;
            }
            return new Vec3D(var0, var2, var4);
        }
        return null;
    }

    @Override
    public AxisAlignedBB getBoundingBoxForCulling() {
        AxisAlignedBB var0 = this.getBoundingBox();
        if (this.hasCustomDisplay()) {
            return var0.inflate((double)Math.abs(this.getDisplayOffset()) / 16.0);
        }
        return var0;
    }

    @Override
    protected void readAdditionalSaveData(NBTTagCompound var0) {
        if (var0.getBoolean("CustomDisplayTile")) {
            this.setDisplayBlockState(GameProfileSerializer.readBlockState(this.level().holderLookup(Registries.BLOCK), var0.getCompound("DisplayState")));
            this.setDisplayOffset(var0.getInt("DisplayOffset"));
        }
    }

    @Override
    protected void addAdditionalSaveData(NBTTagCompound var0) {
        if (this.hasCustomDisplay()) {
            var0.putBoolean("CustomDisplayTile", true);
            var0.put("DisplayState", GameProfileSerializer.writeBlockState(this.getDisplayBlockState()));
            var0.putInt("DisplayOffset", this.getDisplayOffset());
        }
    }

    @Override
    public void push(Entity var0) {
        double var3;
        if (this.level().isClientSide) {
            return;
        }
        if (var0.noPhysics || this.noPhysics) {
            return;
        }
        if (this.hasPassenger(var0)) {
            return;
        }
        double var1 = var0.getX() - this.getX();
        double var5 = var1 * var1 + (var3 = var0.getZ() - this.getZ()) * var3;
        if (var5 >= (double)1.0E-4f) {
            var5 = Math.sqrt(var5);
            var1 /= var5;
            var3 /= var5;
            double var7 = 1.0 / var5;
            if (var7 > 1.0) {
                var7 = 1.0;
            }
            var1 *= var7;
            var3 *= var7;
            var1 *= (double)0.1f;
            var3 *= (double)0.1f;
            var1 *= 0.5;
            var3 *= 0.5;
            if (var0 instanceof EntityMinecartAbstract) {
                Vec3D var14;
                double var11;
                double var9 = var0.getX() - this.getX();
                Vec3D var13 = new Vec3D(var9, 0.0, var11 = var0.getZ() - this.getZ()).normalize();
                double var15 = Math.abs(var13.dot(var14 = new Vec3D(MathHelper.cos(this.getYRot() * ((float)Math.PI / 180)), 0.0, MathHelper.sin(this.getYRot() * ((float)Math.PI / 180))).normalize()));
                if (var15 < (double)0.8f) {
                    return;
                }
                Vec3D var17 = this.getDeltaMovement();
                Vec3D var18 = var0.getDeltaMovement();
                if (((EntityMinecartAbstract)var0).getMinecartType() == EnumMinecartType.FURNACE && this.getMinecartType() != EnumMinecartType.FURNACE) {
                    this.setDeltaMovement(var17.multiply(0.2, 1.0, 0.2));
                    this.push(var18.x - var1, 0.0, var18.z - var3);
                    var0.setDeltaMovement(var18.multiply(0.95, 1.0, 0.95));
                } else if (((EntityMinecartAbstract)var0).getMinecartType() != EnumMinecartType.FURNACE && this.getMinecartType() == EnumMinecartType.FURNACE) {
                    var0.setDeltaMovement(var18.multiply(0.2, 1.0, 0.2));
                    var0.push(var17.x + var1, 0.0, var17.z + var3);
                    this.setDeltaMovement(var17.multiply(0.95, 1.0, 0.95));
                } else {
                    double var19 = (var18.x + var17.x) / 2.0;
                    double var21 = (var18.z + var17.z) / 2.0;
                    this.setDeltaMovement(var17.multiply(0.2, 1.0, 0.2));
                    this.push(var19 - var1, 0.0, var21 - var3);
                    var0.setDeltaMovement(var18.multiply(0.2, 1.0, 0.2));
                    var0.push(var19 + var1, 0.0, var21 + var3);
                }
            } else {
                this.push(-var1, 0.0, -var3);
                var0.push(var1 / 4.0, 0.0, var3 / 4.0);
            }
        }
    }

    @Override
    public void lerpTo(double var0, double var2, double var4, float var6, float var7, int var8) {
        this.lerpX = var0;
        this.lerpY = var2;
        this.lerpZ = var4;
        this.lerpYRot = var6;
        this.lerpXRot = var7;
        this.lerpSteps = var8 + 2;
        this.setDeltaMovement(this.targetDeltaMovement);
    }

    @Override
    public double lerpTargetX() {
        return this.lerpSteps > 0 ? this.lerpX : this.getX();
    }

    @Override
    public double lerpTargetY() {
        return this.lerpSteps > 0 ? this.lerpY : this.getY();
    }

    @Override
    public double lerpTargetZ() {
        return this.lerpSteps > 0 ? this.lerpZ : this.getZ();
    }

    @Override
    public float lerpTargetXRot() {
        return this.lerpSteps > 0 ? (float)this.lerpXRot : this.getXRot();
    }

    @Override
    public float lerpTargetYRot() {
        return this.lerpSteps > 0 ? (float)this.lerpYRot : this.getYRot();
    }

    @Override
    public void lerpMotion(double var0, double var2, double var4) {
        this.targetDeltaMovement = new Vec3D(var0, var2, var4);
        this.setDeltaMovement(this.targetDeltaMovement);
    }

    public void setDamage(float var0) {
        this.entityData.set(DATA_ID_DAMAGE, Float.valueOf(var0));
    }

    public float getDamage() {
        return this.entityData.get(DATA_ID_DAMAGE).floatValue();
    }

    public void setHurtTime(int var0) {
        this.entityData.set(DATA_ID_HURT, var0);
    }

    public int getHurtTime() {
        return this.entityData.get(DATA_ID_HURT);
    }

    public void setHurtDir(int var0) {
        this.entityData.set(DATA_ID_HURTDIR, var0);
    }

    public int getHurtDir() {
        return this.entityData.get(DATA_ID_HURTDIR);
    }

    public abstract EnumMinecartType getMinecartType();

    public IBlockData getDisplayBlockState() {
        if (!this.hasCustomDisplay()) {
            return this.getDefaultDisplayBlockState();
        }
        return Block.stateById(this.getEntityData().get(DATA_ID_DISPLAY_BLOCK));
    }

    public IBlockData getDefaultDisplayBlockState() {
        return Blocks.AIR.defaultBlockState();
    }

    public int getDisplayOffset() {
        if (!this.hasCustomDisplay()) {
            return this.getDefaultDisplayOffset();
        }
        return this.getEntityData().get(DATA_ID_DISPLAY_OFFSET);
    }

    public int getDefaultDisplayOffset() {
        return 6;
    }

    public void setDisplayBlockState(IBlockData var0) {
        this.getEntityData().set(DATA_ID_DISPLAY_BLOCK, Block.getId(var0));
        this.setCustomDisplay(true);
    }

    public void setDisplayOffset(int var0) {
        this.getEntityData().set(DATA_ID_DISPLAY_OFFSET, var0);
        this.setCustomDisplay(true);
    }

    public boolean hasCustomDisplay() {
        return this.getEntityData().get(DATA_ID_CUSTOM_DISPLAY);
    }

    public void setCustomDisplay(boolean var0) {
        this.getEntityData().set(DATA_ID_CUSTOM_DISPLAY, var0);
    }

    @Override
    public ItemStack getPickResult() {
        return new ItemStack(switch (this.getMinecartType()) {
            case EnumMinecartType.FURNACE -> Items.FURNACE_MINECART;
            case EnumMinecartType.CHEST -> Items.CHEST_MINECART;
            case EnumMinecartType.TNT -> Items.TNT_MINECART;
            case EnumMinecartType.HOPPER -> Items.HOPPER_MINECART;
            case EnumMinecartType.COMMAND_BLOCK -> Items.COMMAND_BLOCK_MINECART;
            default -> Items.MINECART;
        });
    }

    public static final class EnumMinecartType
    extends Enum<EnumMinecartType> {
        public static final /* enum */ EnumMinecartType RIDEABLE = new EnumMinecartType();
        public static final /* enum */ EnumMinecartType CHEST = new EnumMinecartType();
        public static final /* enum */ EnumMinecartType FURNACE = new EnumMinecartType();
        public static final /* enum */ EnumMinecartType TNT = new EnumMinecartType();
        public static final /* enum */ EnumMinecartType SPAWNER = new EnumMinecartType();
        public static final /* enum */ EnumMinecartType HOPPER = new EnumMinecartType();
        public static final /* enum */ EnumMinecartType COMMAND_BLOCK = new EnumMinecartType();
        private static final /* synthetic */ EnumMinecartType[] h;

        public static EnumMinecartType[] values() {
            return (EnumMinecartType[])h.clone();
        }

        public static EnumMinecartType valueOf(String var0) {
            return Enum.valueOf(EnumMinecartType.class, var0);
        }

        private static /* synthetic */ EnumMinecartType[] a() {
            return new EnumMinecartType[]{RIDEABLE, CHEST, FURNACE, TNT, SPAWNER, HOPPER, COMMAND_BLOCK};
        }

        static {
            h = EnumMinecartType.a();
        }
    }
}

