/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.google.common.base.MoreObjects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;

public abstract class IProjectile
extends Entity
implements TraceableEntity {
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private Entity cachedOwner;
    private boolean leftOwner;
    private boolean hasBeenShot;

    IProjectile(EntityTypes<? extends IProjectile> var0, World var1) {
        super(var0, var1);
    }

    public void setOwner(@Nullable Entity var0) {
        if (var0 != null) {
            this.ownerUUID = var0.getUUID();
            this.cachedOwner = var0;
        }
    }

    @Override
    @Nullable
    public Entity getOwner() {
        if (this.cachedOwner != null && !this.cachedOwner.isRemoved()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null && this.level() instanceof WorldServer) {
            this.cachedOwner = ((WorldServer)this.level()).getEntity(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }

    public Entity getEffectSource() {
        return (Entity)MoreObjects.firstNonNull((Object)this.getOwner(), (Object)this);
    }

    @Override
    protected void addAdditionalSaveData(NBTTagCompound var0) {
        if (this.ownerUUID != null) {
            var0.putUUID("Owner", this.ownerUUID);
        }
        if (this.leftOwner) {
            var0.putBoolean("LeftOwner", true);
        }
        var0.putBoolean("HasBeenShot", this.hasBeenShot);
    }

    protected boolean ownedBy(Entity var0) {
        return var0.getUUID().equals(this.ownerUUID);
    }

    @Override
    protected void readAdditionalSaveData(NBTTagCompound var0) {
        if (var0.hasUUID("Owner")) {
            this.ownerUUID = var0.getUUID("Owner");
            this.cachedOwner = null;
        }
        this.leftOwner = var0.getBoolean("LeftOwner");
        this.hasBeenShot = var0.getBoolean("HasBeenShot");
    }

    @Override
    public void tick() {
        if (!this.hasBeenShot) {
            this.gameEvent(GameEvent.PROJECTILE_SHOOT, this.getOwner());
            this.hasBeenShot = true;
        }
        if (!this.leftOwner) {
            this.leftOwner = this.checkLeftOwner();
        }
        super.tick();
    }

    private boolean checkLeftOwner() {
        Entity var02 = this.getOwner();
        if (var02 != null) {
            for (Entity var2 : this.level().getEntities(this, this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0), var0 -> !var0.isSpectator() && var0.isPickable())) {
                if (var2.getRootVehicle() != var02.getRootVehicle()) continue;
                return false;
            }
        }
        return true;
    }

    public void shoot(double var0, double var2, double var4, float var6, float var7) {
        Vec3D var8 = new Vec3D(var0, var2, var4).normalize().add(this.random.triangle(0.0, 0.0172275 * (double)var7), this.random.triangle(0.0, 0.0172275 * (double)var7), this.random.triangle(0.0, 0.0172275 * (double)var7)).scale(var6);
        this.setDeltaMovement(var8);
        double var9 = var8.horizontalDistance();
        this.setYRot((float)(MathHelper.atan2(var8.x, var8.z) * 57.2957763671875));
        this.setXRot((float)(MathHelper.atan2(var8.y, var9) * 57.2957763671875));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    public void shootFromRotation(Entity var0, float var1, float var2, float var3, float var4, float var5) {
        float var6 = -MathHelper.sin(var2 * ((float)Math.PI / 180)) * MathHelper.cos(var1 * ((float)Math.PI / 180));
        float var7 = -MathHelper.sin((var1 + var3) * ((float)Math.PI / 180));
        float var8 = MathHelper.cos(var2 * ((float)Math.PI / 180)) * MathHelper.cos(var1 * ((float)Math.PI / 180));
        this.shoot(var6, var7, var8, var4, var5);
        Vec3D var9 = var0.getDeltaMovement();
        this.setDeltaMovement(this.getDeltaMovement().add(var9.x, var0.onGround() ? 0.0 : var9.y, var9.z));
    }

    protected void onHit(MovingObjectPosition var0) {
        MovingObjectPosition.EnumMovingObjectType var1 = var0.getType();
        if (var1 == MovingObjectPosition.EnumMovingObjectType.ENTITY) {
            this.onHitEntity((MovingObjectPositionEntity)var0);
            this.level().gameEvent(GameEvent.PROJECTILE_LAND, var0.getLocation(), GameEvent.a.of(this, null));
        } else if (var1 == MovingObjectPosition.EnumMovingObjectType.BLOCK) {
            MovingObjectPositionBlock var2 = (MovingObjectPositionBlock)var0;
            this.onHitBlock(var2);
            BlockPosition var3 = var2.getBlockPos();
            this.level().gameEvent(GameEvent.PROJECTILE_LAND, var3, GameEvent.a.of(this, this.level().getBlockState(var3)));
        }
    }

    protected void onHitEntity(MovingObjectPositionEntity var0) {
    }

    protected void onHitBlock(MovingObjectPositionBlock var0) {
        IBlockData var1 = this.level().getBlockState(var0.getBlockPos());
        var1.onProjectileHit(this.level(), var1, var0, this);
    }

    @Override
    public void lerpMotion(double var0, double var2, double var4) {
        this.setDeltaMovement(var0, var2, var4);
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            double var6 = Math.sqrt(var0 * var0 + var4 * var4);
            this.setXRot((float)(MathHelper.atan2(var2, var6) * 57.2957763671875));
            this.setYRot((float)(MathHelper.atan2(var0, var4) * 57.2957763671875));
            this.xRotO = this.getXRot();
            this.yRotO = this.getYRot();
            this.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), this.getXRot());
        }
    }

    protected boolean canHitEntity(Entity var0) {
        if (!var0.canBeHitByProjectile()) {
            return false;
        }
        Entity var1 = this.getOwner();
        return var1 == null || this.leftOwner || !var1.isPassengerOfSameVehicle(var0);
    }

    protected void updateRotation() {
        Vec3D var0 = this.getDeltaMovement();
        double var1 = var0.horizontalDistance();
        this.setXRot(IProjectile.lerpRotation(this.xRotO, (float)(MathHelper.atan2(var0.y, var1) * 57.2957763671875)));
        this.setYRot(IProjectile.lerpRotation(this.yRotO, (float)(MathHelper.atan2(var0.x, var0.z) * 57.2957763671875)));
    }

    protected static float lerpRotation(float var0, float var1) {
        while (var1 - var0 < -180.0f) {
            var0 -= 360.0f;
        }
        while (var1 - var0 >= 180.0f) {
            var0 += 360.0f;
        }
        return MathHelper.lerp(0.2f, var0, var1);
    }

    @Override
    public Packet<PacketListenerPlayOut> getAddEntityPacket() {
        Entity var0 = this.getOwner();
        return new PacketPlayOutSpawnEntity(this, var0 == null ? 0 : var0.getId());
    }

    @Override
    public void recreateFromPacket(PacketPlayOutSpawnEntity var0) {
        super.recreateFromPacket(var0);
        Entity var1 = this.level().getEntity(var0.getData());
        if (var1 != null) {
            this.setOwner(var1);
        }
    }

    @Override
    public boolean mayInteract(World var0, BlockPosition var1) {
        Entity var2 = this.getOwner();
        if (var2 instanceof EntityHuman) {
            return var2.mayInteract(var0, var1);
        }
        return var2 == null || var0.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING);
    }
}

