/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.warden;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Collections;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.warden.SonicBoom;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.warden.AngerLevel;
import net.minecraft.world.entity.monster.warden.AngerManagement;
import net.minecraft.world.entity.monster.warden.WardenAi;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.Vec3D;
import org.jetbrains.annotations.Contract;
import org.joml.Vector3f;
import org.slf4j.Logger;

public class Warden
extends EntityMonster
implements VibrationSystem {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int VIBRATION_COOLDOWN_TICKS = 40;
    private static final int TIME_TO_USE_MELEE_UNTIL_SONIC_BOOM = 200;
    private static final int MAX_HEALTH = 500;
    private static final float MOVEMENT_SPEED_WHEN_FIGHTING = 0.3f;
    private static final float KNOCKBACK_RESISTANCE = 1.0f;
    private static final float ATTACK_KNOCKBACK = 1.5f;
    private static final int ATTACK_DAMAGE = 30;
    private static final DataWatcherObject<Integer> CLIENT_ANGER_LEVEL = DataWatcher.defineId(Warden.class, DataWatcherRegistry.INT);
    private static final int DARKNESS_DISPLAY_LIMIT = 200;
    private static final int DARKNESS_DURATION = 260;
    private static final int DARKNESS_RADIUS = 20;
    private static final int DARKNESS_INTERVAL = 120;
    private static final int ANGERMANAGEMENT_TICK_DELAY = 20;
    private static final int DEFAULT_ANGER = 35;
    private static final int PROJECTILE_ANGER = 10;
    private static final int ON_HURT_ANGER_BOOST = 20;
    private static final int RECENT_PROJECTILE_TICK_THRESHOLD = 100;
    private static final int TOUCH_COOLDOWN_TICKS = 20;
    private static final int DIGGING_PARTICLES_AMOUNT = 30;
    private static final float DIGGING_PARTICLES_DURATION = 4.5f;
    private static final float DIGGING_PARTICLES_OFFSET = 0.7f;
    private static final int PROJECTILE_ANGER_DISTANCE = 30;
    private int tendrilAnimation;
    private int tendrilAnimationO;
    private int heartAnimation;
    private int heartAnimationO;
    public AnimationState roarAnimationState = new AnimationState();
    public AnimationState sniffAnimationState = new AnimationState();
    public AnimationState emergeAnimationState = new AnimationState();
    public AnimationState diggingAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState sonicBoomAnimationState = new AnimationState();
    private final DynamicGameEventListener<VibrationSystem.b> dynamicGameEventListener;
    private final VibrationSystem.d vibrationUser;
    private VibrationSystem.a vibrationData;
    AngerManagement angerManagement = new AngerManagement(this::canTargetEntity, Collections.emptyList());

    public Warden(EntityTypes<? extends EntityMonster> var0, World var1) {
        super(var0, var1);
        this.vibrationUser = new a();
        this.vibrationData = new VibrationSystem.a();
        this.dynamicGameEventListener = new DynamicGameEventListener<VibrationSystem.b>(new VibrationSystem.b(this));
        this.xpReward = 5;
        this.getNavigation().setCanFloat(true);
        this.setPathfindingMalus(PathType.UNPASSABLE_RAIL, 0.0f);
        this.setPathfindingMalus(PathType.DAMAGE_OTHER, 8.0f);
        this.setPathfindingMalus(PathType.POWDER_SNOW, 8.0f);
        this.setPathfindingMalus(PathType.LAVA, 8.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, 0.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 0.0f);
    }

    @Override
    public Packet<PacketListenerPlayOut> getAddEntityPacket() {
        return new PacketPlayOutSpawnEntity(this, this.hasPose(EntityPose.EMERGING) ? 1 : 0);
    }

    @Override
    public void recreateFromPacket(PacketPlayOutSpawnEntity var0) {
        super.recreateFromPacket(var0);
        if (var0.getData() == 1) {
            this.setPose(EntityPose.EMERGING);
        }
    }

    @Override
    public boolean checkSpawnObstruction(IWorldReader var0) {
        return super.checkSpawnObstruction(var0) && var0.noCollision(this, this.getType().getDimensions().makeBoundingBox(this.position()));
    }

    @Override
    public float getWalkTargetValue(BlockPosition var0, IWorldReader var1) {
        return 0.0f;
    }

    @Override
    public boolean isInvulnerableTo(DamageSource var0) {
        if (this.isDiggingOrEmerging() && !var0.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return true;
        }
        return super.isInvulnerableTo(var0);
    }

    boolean isDiggingOrEmerging() {
        return this.hasPose(EntityPose.DIGGING) || this.hasPose(EntityPose.EMERGING);
    }

    @Override
    protected boolean canRide(Entity var0) {
        return false;
    }

    @Override
    public boolean canDisableShield() {
        return true;
    }

    @Override
    protected float nextStep() {
        return this.moveDist + 0.55f;
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityMonster.createMonsterAttributes().add(GenericAttributes.MAX_HEALTH, 500.0).add(GenericAttributes.MOVEMENT_SPEED, 0.3f).add(GenericAttributes.KNOCKBACK_RESISTANCE, 1.0).add(GenericAttributes.ATTACK_KNOCKBACK, 1.5).add(GenericAttributes.ATTACK_DAMAGE, 30.0);
    }

    @Override
    public boolean dampensVibrations() {
        return true;
    }

    @Override
    protected float getSoundVolume() {
        return 4.0f;
    }

    @Override
    @Nullable
    protected SoundEffect getAmbientSound() {
        if (this.hasPose(EntityPose.ROARING) || this.isDiggingOrEmerging()) {
            return null;
        }
        return this.getAngerLevel().getAmbientSound();
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.WARDEN_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.WARDEN_DEATH;
    }

    @Override
    protected void playStepSound(BlockPosition var0, IBlockData var1) {
        this.playSound(SoundEffects.WARDEN_STEP, 10.0f, 1.0f);
    }

    @Override
    public boolean doHurtTarget(Entity var0) {
        this.level().broadcastEntityEvent(this, (byte)4);
        this.playSound(SoundEffects.WARDEN_ATTACK_IMPACT, 10.0f, this.getVoicePitch());
        SonicBoom.setCooldown(this, 40);
        return super.doHurtTarget(var0);
    }

    @Override
    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(CLIENT_ANGER_LEVEL, 0);
    }

    public int getClientAngerLevel() {
        return this.entityData.get(CLIENT_ANGER_LEVEL);
    }

    private void syncClientAngerLevel() {
        this.entityData.set(CLIENT_ANGER_LEVEL, this.getActiveAnger());
    }

    @Override
    public void tick() {
        World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer var0 = (WorldServer)world;
            VibrationSystem.c.tick(var0, this.vibrationData, this.vibrationUser);
            if (this.isPersistenceRequired() || this.requiresCustomPersistence()) {
                WardenAi.setDigCooldown(this);
            }
        }
        super.tick();
        if (this.level().isClientSide()) {
            if (this.tickCount % this.getHeartBeatDelay() == 0) {
                this.heartAnimation = 10;
                if (!this.isSilent()) {
                    this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEffects.WARDEN_HEARTBEAT, this.getSoundSource(), 5.0f, this.getVoicePitch(), false);
                }
            }
            this.tendrilAnimationO = this.tendrilAnimation;
            if (this.tendrilAnimation > 0) {
                --this.tendrilAnimation;
            }
            this.heartAnimationO = this.heartAnimation;
            if (this.heartAnimation > 0) {
                --this.heartAnimation;
            }
            switch (this.getPose()) {
                case EMERGING: {
                    this.clientDiggingParticles(this.emergeAnimationState);
                    break;
                }
                case DIGGING: {
                    this.clientDiggingParticles(this.diggingAnimationState);
                }
            }
        }
    }

    @Override
    protected void customServerAiStep() {
        WorldServer var0 = (WorldServer)this.level();
        var0.getProfiler().push("wardenBrain");
        this.getBrain().tick(var0, this);
        this.level().getProfiler().pop();
        super.customServerAiStep();
        if ((this.tickCount + this.getId()) % 120 == 0) {
            Warden.applyDarknessAround(var0, this.position(), this, 20);
        }
        if (this.tickCount % 20 == 0) {
            this.angerManagement.tick(var0, this::canTargetEntity);
            this.syncClientAngerLevel();
        }
        WardenAi.updateActivity(this);
    }

    @Override
    public void handleEntityEvent(byte var0) {
        if (var0 == 4) {
            this.roarAnimationState.stop();
            this.attackAnimationState.start(this.tickCount);
        } else if (var0 == 61) {
            this.tendrilAnimation = 10;
        } else if (var0 == 62) {
            this.sonicBoomAnimationState.start(this.tickCount);
        } else {
            super.handleEntityEvent(var0);
        }
    }

    private int getHeartBeatDelay() {
        float var0 = (float)this.getClientAngerLevel() / (float)AngerLevel.ANGRY.getMinimumAnger();
        return 40 - MathHelper.floor(MathHelper.clamp(var0, 0.0f, 1.0f) * 30.0f);
    }

    public float getTendrilAnimation(float var0) {
        return MathHelper.lerp(var0, this.tendrilAnimationO, this.tendrilAnimation) / 10.0f;
    }

    public float getHeartAnimation(float var0) {
        return MathHelper.lerp(var0, this.heartAnimationO, this.heartAnimation) / 10.0f;
    }

    private void clientDiggingParticles(AnimationState var0) {
        if ((float)var0.getAccumulatedTime() < 4500.0f) {
            RandomSource var1 = this.getRandom();
            IBlockData var2 = this.getBlockStateOn();
            if (var2.getRenderShape() != EnumRenderType.INVISIBLE) {
                for (int var3 = 0; var3 < 30; ++var3) {
                    double var4 = this.getX() + (double)MathHelper.randomBetween(var1, -0.7f, 0.7f);
                    double var6 = this.getY();
                    double var8 = this.getZ() + (double)MathHelper.randomBetween(var1, -0.7f, 0.7f);
                    this.level().addParticle(new ParticleParamBlock(Particles.BLOCK, var2), var4, var6, var8, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> var0) {
        if (DATA_POSE.equals(var0)) {
            switch (this.getPose()) {
                case ROARING: {
                    this.roarAnimationState.start(this.tickCount);
                    break;
                }
                case SNIFFING: {
                    this.sniffAnimationState.start(this.tickCount);
                    break;
                }
                case EMERGING: {
                    this.emergeAnimationState.start(this.tickCount);
                    break;
                }
                case DIGGING: {
                    this.diggingAnimationState.start(this.tickCount);
                }
            }
        }
        super.onSyncedDataUpdated(var0);
    }

    @Override
    public boolean ignoreExplosion() {
        return this.isDiggingOrEmerging();
    }

    @Override
    protected BehaviorController<?> makeBrain(Dynamic<?> var0) {
        return WardenAi.makeBrain(this, var0);
    }

    public BehaviorController<Warden> getBrain() {
        return super.getBrain();
    }

    @Override
    protected void sendDebugPackets() {
        super.sendDebugPackets();
        PacketDebug.sendEntityBrain(this);
    }

    @Override
    public void updateDynamicGameEventListener(BiConsumer<DynamicGameEventListener<?>, WorldServer> var0) {
        World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer var1 = (WorldServer)world;
            var0.accept(this.dynamicGameEventListener, var1);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Contract(value="null->false")
    public boolean canTargetEntity(@Nullable Entity var0) {
        if (!(var0 instanceof EntityLiving)) return false;
        EntityLiving var1 = (EntityLiving)var0;
        if (this.level() != var0.level()) return false;
        if (!IEntitySelector.NO_CREATIVE_OR_SPECTATOR.test(var0)) return false;
        if (this.isAlliedTo(var0)) return false;
        if (var1.getType() == EntityTypes.ARMOR_STAND) return false;
        if (var1.getType() == EntityTypes.WARDEN) return false;
        if (var1.isInvulnerable()) return false;
        if (var1.isDeadOrDying()) return false;
        if (!this.level().getWorldBorder().isWithinBounds(var1.getBoundingBox())) return false;
        return true;
    }

    public static void applyDarknessAround(WorldServer var0, Vec3D var1, @Nullable Entity var2, int var3) {
        MobEffect var4 = new MobEffect(MobEffects.DARKNESS, 260, 0, false, false);
        MobEffectUtil.addEffectToPlayersAround(var0, var2, var1, var3, var4, 200);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        AngerManagement.codec(this::canTargetEntity).encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)this.angerManagement).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(var1 -> var0.put("anger", (NBTBase)var1));
        VibrationSystem.a.CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)this.vibrationData).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(var1 -> var0.put("listener", (NBTBase)var1));
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var02) {
        super.readAdditionalSaveData(var02);
        if (var02.contains("anger")) {
            AngerManagement.codec(this::canTargetEntity).parse(new Dynamic((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var02.get("anger"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(var0 -> {
                this.angerManagement = var0;
            });
            this.syncClientAngerLevel();
        }
        if (var02.contains("listener", 10)) {
            VibrationSystem.a.CODEC.parse(new Dynamic((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var02.getCompound("listener"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(var0 -> {
                this.vibrationData = var0;
            });
        }
    }

    private void playListeningSound() {
        if (!this.hasPose(EntityPose.ROARING)) {
            this.playSound(this.getAngerLevel().getListeningSound(), 10.0f, this.getVoicePitch());
        }
    }

    public AngerLevel getAngerLevel() {
        return AngerLevel.byAnger(this.getActiveAnger());
    }

    private int getActiveAnger() {
        return this.angerManagement.getActiveAnger(this.getTarget());
    }

    public void clearAnger(Entity var0) {
        this.angerManagement.clearAnger(var0);
    }

    public void increaseAngerAt(@Nullable Entity var0) {
        this.increaseAngerAt(var0, 35, true);
    }

    @VisibleForTesting
    public void increaseAngerAt(@Nullable Entity var0, int var1, boolean var2) {
        if (!this.isNoAi() && this.canTargetEntity(var0)) {
            WardenAi.setDigCooldown(this);
            boolean var3 = !(this.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null) instanceof EntityHuman);
            int var4 = this.angerManagement.increaseAnger(var0, var1);
            if (var0 instanceof EntityHuman && var3 && AngerLevel.byAnger(var4).isAngry()) {
                this.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
            }
            if (var2) {
                this.playListeningSound();
            }
        }
    }

    public Optional<EntityLiving> getEntityAngryAt() {
        if (this.getAngerLevel().isAngry()) {
            return this.angerManagement.getActiveEntity();
        }
        return Optional.empty();
    }

    @Override
    @Nullable
    public EntityLiving getTarget() {
        return this.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
    }

    @Override
    public boolean removeWhenFarAway(double var0) {
        return false;
    }

    @Override
    @Nullable
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EnumMobSpawn var2, @Nullable GroupDataEntity var3, @Nullable NBTTagCompound var4) {
        this.getBrain().setMemoryWithExpiry(MemoryModuleType.DIG_COOLDOWN, Unit.INSTANCE, 1200L);
        if (var2 == EnumMobSpawn.TRIGGERED) {
            this.setPose(EntityPose.EMERGING);
            this.getBrain().setMemoryWithExpiry(MemoryModuleType.IS_EMERGING, Unit.INSTANCE, WardenAi.EMERGE_DURATION);
            this.playSound(SoundEffects.WARDEN_AGITATED, 5.0f, 1.0f);
        }
        return super.finalizeSpawn(var0, var1, var2, var3, var4);
    }

    @Override
    public boolean hurt(DamageSource var0, float var1) {
        boolean var2 = super.hurt(var0, var1);
        if (!(this.level().isClientSide || this.isNoAi() || this.isDiggingOrEmerging())) {
            Entity var3 = var0.getEntity();
            this.increaseAngerAt(var3, AngerLevel.ANGRY.getMinimumAnger() + 20, false);
            if (this.brain.getMemory(MemoryModuleType.ATTACK_TARGET).isEmpty() && var3 instanceof EntityLiving) {
                EntityLiving var4 = (EntityLiving)var3;
                if (!var0.isIndirect() || this.closerThan(var4, 5.0)) {
                    this.setAttackTarget(var4);
                }
            }
        }
        return var2;
    }

    public void setAttackTarget(EntityLiving var0) {
        this.getBrain().eraseMemory(MemoryModuleType.ROAR_TARGET);
        this.getBrain().setMemory(MemoryModuleType.ATTACK_TARGET, var0);
        this.getBrain().eraseMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
        SonicBoom.setCooldown(this, 200);
    }

    @Override
    public EntitySize getDimensions(EntityPose var0) {
        EntitySize var1 = super.getDimensions(var0);
        if (this.isDiggingOrEmerging()) {
            return EntitySize.fixed(var1.width, 1.0f);
        }
        return var1;
    }

    @Override
    public boolean isPushable() {
        return !this.isDiggingOrEmerging() && super.isPushable();
    }

    @Override
    protected void doPush(Entity var0) {
        if (!this.isNoAi() && !this.getBrain().hasMemoryValue(MemoryModuleType.TOUCH_COOLDOWN)) {
            this.getBrain().setMemoryWithExpiry(MemoryModuleType.TOUCH_COOLDOWN, Unit.INSTANCE, 20L);
            this.increaseAngerAt(var0);
            WardenAi.setDisturbanceLocation(this, var0.blockPosition());
        }
        super.doPush(var0);
    }

    @VisibleForTesting
    public AngerManagement getAngerManagement() {
        return this.angerManagement;
    }

    @Override
    protected NavigationAbstract createNavigation(World var0) {
        return new Navigation(this, var0){

            @Override
            protected Pathfinder createPathFinder(int var0) {
                this.nodeEvaluator = new PathfinderNormal();
                this.nodeEvaluator.setCanPassDoors(true);
                return new Pathfinder(this.nodeEvaluator, var0){

                    @Override
                    protected float distance(PathPoint var0, PathPoint var1) {
                        return var0.distanceToXZ(var1);
                    }
                };
            }
        };
    }

    @Override
    protected Vector3f getPassengerAttachmentPoint(Entity var0, EntitySize var1, float var2) {
        return new Vector3f(0.0f, var1.height + 0.25f * var2, 0.0f);
    }

    @Override
    public VibrationSystem.a getVibrationData() {
        return this.vibrationData;
    }

    @Override
    public VibrationSystem.d getVibrationUser() {
        return this.vibrationUser;
    }

    class a
    implements VibrationSystem.d {
        private static final int GAME_EVENT_LISTENER_RANGE = 16;
        private final PositionSource positionSource;

        a() {
            this.positionSource = new EntityPositionSource(Warden.this, Warden.this.getEyeHeight());
        }

        @Override
        public int getListenerRadius() {
            return 16;
        }

        @Override
        public PositionSource getPositionSource() {
            return this.positionSource;
        }

        @Override
        public TagKey<GameEvent> getListenableEvents() {
            return GameEventTags.WARDEN_CAN_LISTEN;
        }

        @Override
        public boolean canTriggerAvoidVibration() {
            return true;
        }

        @Override
        public boolean canReceiveVibration(WorldServer var0, BlockPosition var1, GameEvent var2, GameEvent.a var3) {
            EntityLiving var4;
            if (Warden.this.isNoAi() || Warden.this.isDeadOrDying() || Warden.this.getBrain().hasMemoryValue(MemoryModuleType.VIBRATION_COOLDOWN) || Warden.this.isDiggingOrEmerging() || !var0.getWorldBorder().isWithinBounds(var1)) {
                return false;
            }
            Entity entity = var3.sourceEntity();
            return !(entity instanceof EntityLiving) || Warden.this.canTargetEntity(var4 = (EntityLiving)entity);
        }

        @Override
        public void onReceiveVibration(WorldServer var0, BlockPosition var1, GameEvent var2, @Nullable Entity var3, @Nullable Entity var4, float var5) {
            if (Warden.this.isDeadOrDying()) {
                return;
            }
            Warden.this.brain.setMemoryWithExpiry(MemoryModuleType.VIBRATION_COOLDOWN, Unit.INSTANCE, 40L);
            var0.broadcastEntityEvent(Warden.this, (byte)61);
            Warden.this.playSound(SoundEffects.WARDEN_TENDRIL_CLICKS, 5.0f, Warden.this.getVoicePitch());
            BlockPosition var6 = var1;
            if (var4 != null) {
                if (Warden.this.closerThan(var4, 30.0)) {
                    if (Warden.this.getBrain().hasMemoryValue(MemoryModuleType.RECENT_PROJECTILE)) {
                        if (Warden.this.canTargetEntity(var4)) {
                            var6 = var4.blockPosition();
                        }
                        Warden.this.increaseAngerAt(var4);
                    } else {
                        Warden.this.increaseAngerAt(var4, 10, true);
                    }
                }
                Warden.this.getBrain().setMemoryWithExpiry(MemoryModuleType.RECENT_PROJECTILE, Unit.INSTANCE, 100L);
            } else {
                Warden.this.increaseAngerAt(var3);
            }
            if (!Warden.this.getAngerLevel().isAngry()) {
                Optional<EntityLiving> var7 = Warden.this.angerManagement.getActiveEntity();
                if (var4 != null || var7.isEmpty() || var7.get() == var3) {
                    WardenAi.setDisturbanceLocation(Warden.this, var6);
                }
            }
        }
    }
}

