/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.ItemCrossbow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec3D;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public interface ICrossbow
extends IRangedEntity {
    public void setChargingCrossbow(boolean var1);

    public void shootCrossbowProjectile(EntityLiving var1, ItemStack var2, IProjectile var3, float var4);

    @Nullable
    public EntityLiving getTarget();

    public void onCrossbowAttackPerformed();

    default public void performCrossbowAttack(EntityLiving var0, float var1) {
        EnumHand var2 = ProjectileHelper.getWeaponHoldingHand(var0, Items.CROSSBOW);
        ItemStack var3 = var0.getItemInHand(var2);
        if (var0.isHolding(Items.CROSSBOW)) {
            ItemCrossbow.performShooting(var0.level(), var0, var2, var3, var1, 14 - var0.level().getDifficulty().getId() * 4);
        }
        this.onCrossbowAttackPerformed();
    }

    default public void shootCrossbowProjectile(EntityLiving var0, EntityLiving var1, IProjectile var2, float var3, float var4) {
        double var5 = var1.getX() - var0.getX();
        double var7 = var1.getZ() - var0.getZ();
        double var9 = Math.sqrt(var5 * var5 + var7 * var7);
        double var11 = var1.getY(0.3333333333333333) - var2.getY() + var9 * (double)0.2f;
        Vector3f var13 = this.getProjectileShotVector(var0, new Vec3D(var5, var11, var7), var3);
        var2.shoot(var13.x(), var13.y(), var13.z(), var4, 14 - var0.level().getDifficulty().getId() * 4);
        var0.playSound(SoundEffects.CROSSBOW_SHOOT, 1.0f, 1.0f / (var0.getRandom().nextFloat() * 0.4f + 0.8f));
    }

    default public Vector3f getProjectileShotVector(EntityLiving var0, Vec3D var1, float var2) {
        Vec3D var5;
        Vector3f var3 = var1.toVector3f().normalize();
        Vector3f var4 = new Vector3f((Vector3fc)var3).cross((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f));
        if ((double)var4.lengthSquared() <= 1.0E-7) {
            var5 = var0.getUpVector(1.0f);
            var4 = new Vector3f((Vector3fc)var3).cross((Vector3fc)var5.toVector3f());
        }
        var5 = new Vector3f((Vector3fc)var3).rotateAxis(1.5707964f, var4.x, var4.y, var4.z);
        return new Vector3f((Vector3fc)var3).rotateAxis(var2 * ((float)Math.PI / 180), ((Vector3f)var5).x, ((Vector3f)var5).y, ((Vector3f)var5).z);
    }
}

