/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import net.minecraft.core.BlockPosition;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import org.joml.Vector3f;

public class EntityZombieHusk
extends EntityZombie {
    public EntityZombieHusk(EntityTypes<? extends EntityZombieHusk> var0, World var1) {
        super((EntityTypes<? extends EntityZombie>)var0, var1);
    }

    public static boolean checkHuskSpawnRules(EntityTypes<EntityZombieHusk> var0, WorldAccess var1, EnumMobSpawn var2, BlockPosition var3, RandomSource var4) {
        return EntityZombieHusk.checkMonsterSpawnRules(var0, var1, var2, var3, var4) && (var2 == EnumMobSpawn.SPAWNER || var1.canSeeSky(var3));
    }

    @Override
    protected boolean isSunSensitive() {
        return false;
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.HUSK_AMBIENT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.HUSK_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.HUSK_DEATH;
    }

    @Override
    protected SoundEffect getStepSound() {
        return SoundEffects.HUSK_STEP;
    }

    @Override
    public boolean doHurtTarget(Entity var0) {
        boolean var1 = super.doHurtTarget(var0);
        if (var1 && this.getMainHandItem().isEmpty() && var0 instanceof EntityLiving) {
            float var2 = this.level().getCurrentDifficultyAt(this.blockPosition()).getEffectiveDifficulty();
            ((EntityLiving)var0).addEffect(new MobEffect(MobEffects.HUNGER, 140 * (int)var2), this);
        }
        return var1;
    }

    @Override
    protected boolean convertsInWater() {
        return true;
    }

    @Override
    protected void doUnderWaterConversion() {
        this.convertToZombieType(EntityTypes.ZOMBIE);
        if (!this.isSilent()) {
            this.level().levelEvent(null, 1041, this.blockPosition(), 0);
        }
    }

    @Override
    protected ItemStack getSkull() {
        return ItemStack.EMPTY;
    }

    @Override
    protected Vector3f getPassengerAttachmentPoint(Entity var0, EntitySize var1, float var2) {
        return new Vector3f(0.0f, var1.height + 0.125f * var2, 0.0f);
    }
}

