/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.monster.EntityIllagerAbstract;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.joml.Vector3f;

public class EntityRavager
extends EntityRaider {
    private static final Predicate<Entity> NO_RAVAGER_AND_ALIVE = var0 -> var0.isAlive() && !(var0 instanceof EntityRavager);
    private static final double BASE_MOVEMENT_SPEED = 0.3;
    private static final double ATTACK_MOVEMENT_SPEED = 0.35;
    private static final int STUNNED_COLOR = 8356754;
    private static final double STUNNED_COLOR_BLUE = 0.5725490196078431;
    private static final double STUNNED_COLOR_GREEN = 0.5137254901960784;
    private static final double STUNNED_COLOR_RED = 0.4980392156862745;
    private static final int ATTACK_DURATION = 10;
    public static final int STUN_DURATION = 40;
    private int attackTick;
    private int stunnedTick;
    private int roarTick;

    public EntityRavager(EntityTypes<? extends EntityRavager> var0, World var1) {
        super((EntityTypes<? extends EntityRaider>)var0, var1);
        this.setMaxUpStep(1.0f);
        this.xpReward = 20;
        this.setPathfindingMalus(PathType.LEAVES, 0.0f);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, new PathfinderGoalFloat(this));
        this.goalSelector.addGoal(4, new PathfinderGoalMeleeAttack(this, 1.0, true));
        this.goalSelector.addGoal(5, new PathfinderGoalRandomStrollLand(this, 0.4));
        this.goalSelector.addGoal(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.goalSelector.addGoal(10, new PathfinderGoalLookAtPlayer(this, EntityInsentient.class, 8.0f));
        this.targetSelector.addGoal(2, new PathfinderGoalHurtByTarget(this, EntityRaider.class).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(3, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        this.targetSelector.addGoal(4, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, true, var0 -> !var0.isBaby()));
        this.targetSelector.addGoal(4, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
    }

    @Override
    protected void updateControlFlags() {
        boolean var0 = !(this.getControllingPassenger() instanceof EntityInsentient) || this.getControllingPassenger().getType().is(TagsEntity.RAIDERS);
        boolean var1 = !(this.getVehicle() instanceof EntityBoat);
        this.goalSelector.setControlFlag(PathfinderGoal.Type.MOVE, var0);
        this.goalSelector.setControlFlag(PathfinderGoal.Type.JUMP, var0 && var1);
        this.goalSelector.setControlFlag(PathfinderGoal.Type.LOOK, var0);
        this.goalSelector.setControlFlag(PathfinderGoal.Type.TARGET, var0);
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityMonster.createMonsterAttributes().add(GenericAttributes.MAX_HEALTH, 100.0).add(GenericAttributes.MOVEMENT_SPEED, 0.3).add(GenericAttributes.KNOCKBACK_RESISTANCE, 0.75).add(GenericAttributes.ATTACK_DAMAGE, 12.0).add(GenericAttributes.ATTACK_KNOCKBACK, 1.5).add(GenericAttributes.FOLLOW_RANGE, 32.0);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putInt("AttackTick", this.attackTick);
        var0.putInt("StunTick", this.stunnedTick);
        var0.putInt("RoarTick", this.roarTick);
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        this.attackTick = var0.getInt("AttackTick");
        this.stunnedTick = var0.getInt("StunTick");
        this.roarTick = var0.getInt("RoarTick");
    }

    @Override
    public SoundEffect getCelebrateSound() {
        return SoundEffects.RAVAGER_CELEBRATE;
    }

    @Override
    public int getMaxHeadYRot() {
        return 45;
    }

    @Override
    protected Vector3f getPassengerAttachmentPoint(Entity var0, EntitySize var1, float var2) {
        return new Vector3f(0.0f, var1.height + 0.0625f * var2, -0.0625f * var2);
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (!this.isAlive()) {
            return;
        }
        if (this.isImmobile()) {
            this.getAttribute(GenericAttributes.MOVEMENT_SPEED).setBaseValue(0.0);
        } else {
            double var0 = this.getTarget() != null ? 0.35 : 0.3;
            double var2 = this.getAttribute(GenericAttributes.MOVEMENT_SPEED).getBaseValue();
            this.getAttribute(GenericAttributes.MOVEMENT_SPEED).setBaseValue(MathHelper.lerp(0.1, var2, var0));
        }
        if (this.horizontalCollision && this.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
            boolean var0 = false;
            AxisAlignedBB var1 = this.getBoundingBox().inflate(0.2);
            for (BlockPosition var3 : BlockPosition.betweenClosed(MathHelper.floor(var1.minX), MathHelper.floor(var1.minY), MathHelper.floor(var1.minZ), MathHelper.floor(var1.maxX), MathHelper.floor(var1.maxY), MathHelper.floor(var1.maxZ))) {
                IBlockData var4 = this.level().getBlockState(var3);
                Block var5 = var4.getBlock();
                if (!(var5 instanceof BlockLeaves)) continue;
                var0 = this.level().destroyBlock(var3, true, this) || var0;
            }
            if (!var0 && this.onGround()) {
                this.jumpFromGround();
            }
        }
        if (this.roarTick > 0) {
            --this.roarTick;
            if (this.roarTick == 10) {
                this.roar();
            }
        }
        if (this.attackTick > 0) {
            --this.attackTick;
        }
        if (this.stunnedTick > 0) {
            --this.stunnedTick;
            this.stunEffect();
            if (this.stunnedTick == 0) {
                this.playSound(SoundEffects.RAVAGER_ROAR, 1.0f, 1.0f);
                this.roarTick = 20;
            }
        }
    }

    private void stunEffect() {
        if (this.random.nextInt(6) == 0) {
            double var0 = this.getX() - (double)this.getBbWidth() * Math.sin(this.yBodyRot * ((float)Math.PI / 180)) + (this.random.nextDouble() * 0.6 - 0.3);
            double var2 = this.getY() + (double)this.getBbHeight() - 0.3;
            double var4 = this.getZ() + (double)this.getBbWidth() * Math.cos(this.yBodyRot * ((float)Math.PI / 180)) + (this.random.nextDouble() * 0.6 - 0.3);
            this.level().addParticle(Particles.ENTITY_EFFECT, var0, var2, var4, 0.4980392156862745, 0.5137254901960784, 0.5725490196078431);
        }
    }

    @Override
    protected boolean isImmobile() {
        return super.isImmobile() || this.attackTick > 0 || this.stunnedTick > 0 || this.roarTick > 0;
    }

    @Override
    public boolean hasLineOfSight(Entity var0) {
        if (this.stunnedTick > 0 || this.roarTick > 0) {
            return false;
        }
        return super.hasLineOfSight(var0);
    }

    @Override
    protected void blockedByShield(EntityLiving var0) {
        if (this.roarTick == 0) {
            if (this.random.nextDouble() < 0.5) {
                this.stunnedTick = 40;
                this.playSound(SoundEffects.RAVAGER_STUNNED, 1.0f, 1.0f);
                this.level().broadcastEntityEvent(this, (byte)39);
                var0.push(this);
            } else {
                this.strongKnockback(var0);
            }
            var0.hurtMarked = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void roar() {
        if (this.isAlive()) {
            void var3_5;
            List<Entity> var0 = this.level().getEntitiesOfClass(EntityLiving.class, this.getBoundingBox().inflate(4.0), NO_RAVAGER_AND_ALIVE);
            for (EntityLiving entityLiving : var0) {
                if (!(entityLiving instanceof EntityIllagerAbstract)) {
                    entityLiving.hurt(this.damageSources().mobAttack(this), 6.0f);
                }
                this.strongKnockback(entityLiving);
            }
            Vec3D var1 = this.getBoundingBox().getCenter();
            boolean bl = false;
            while (var3_5 < 40) {
                double var3 = this.random.nextGaussian() * 0.2;
                double var5 = this.random.nextGaussian() * 0.2;
                double var7 = this.random.nextGaussian() * 0.2;
                this.level().addParticle(Particles.POOF, var1.x, var1.y, var1.z, var3, var5, var7);
                ++var3_5;
            }
            this.gameEvent(GameEvent.ENTITY_ACTION);
        }
    }

    private void strongKnockback(Entity var0) {
        double var1 = var0.getX() - this.getX();
        double var3 = var0.getZ() - this.getZ();
        double var5 = Math.max(var1 * var1 + var3 * var3, 0.001);
        var0.push(var1 / var5 * 4.0, 0.2, var3 / var5 * 4.0);
    }

    @Override
    public void handleEntityEvent(byte var0) {
        if (var0 == 4) {
            this.attackTick = 10;
            this.playSound(SoundEffects.RAVAGER_ATTACK, 1.0f, 1.0f);
        } else if (var0 == 39) {
            this.stunnedTick = 40;
        }
        super.handleEntityEvent(var0);
    }

    public int getAttackTick() {
        return this.attackTick;
    }

    public int getStunnedTick() {
        return this.stunnedTick;
    }

    public int getRoarTick() {
        return this.roarTick;
    }

    @Override
    public boolean doHurtTarget(Entity var0) {
        this.attackTick = 10;
        this.level().broadcastEntityEvent(this, (byte)4);
        this.playSound(SoundEffects.RAVAGER_ATTACK, 1.0f, 1.0f);
        return super.doHurtTarget(var0);
    }

    @Override
    @Nullable
    protected SoundEffect getAmbientSound() {
        return SoundEffects.RAVAGER_AMBIENT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.RAVAGER_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.RAVAGER_DEATH;
    }

    @Override
    protected void playStepSound(BlockPosition var0, IBlockData var1) {
        this.playSound(SoundEffects.RAVAGER_STEP, 0.15f, 1.0f);
    }

    @Override
    public boolean checkSpawnObstruction(IWorldReader var0) {
        return !var0.containsAnyLiquid(this.getBoundingBox());
    }

    @Override
    public void applyRaidBuffs(int var0, boolean var1) {
    }

    @Override
    public boolean canBeLeader() {
        return false;
    }

    @Override
    protected AxisAlignedBB getAttackBoundingBox() {
        AxisAlignedBB var0 = super.getAttackBoundingBox();
        return var0.deflate(0.05, 0.0, 0.05);
    }
}

