/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntitySlime;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.phys.Vec3D;

public class EntityMagmaCube
extends EntitySlime {
    public EntityMagmaCube(EntityTypes<? extends EntityMagmaCube> var0, World var1) {
        super((EntityTypes<? extends EntitySlime>)var0, var1);
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityMonster.createMonsterAttributes().add(GenericAttributes.MOVEMENT_SPEED, 0.2f);
    }

    public static boolean checkMagmaCubeSpawnRules(EntityTypes<EntityMagmaCube> var0, GeneratorAccess var1, EnumMobSpawn var2, BlockPosition var3, RandomSource var4) {
        return var1.getDifficulty() != EnumDifficulty.PEACEFUL;
    }

    @Override
    public boolean checkSpawnObstruction(IWorldReader var0) {
        return var0.isUnobstructed(this) && !var0.containsAnyLiquid(this.getBoundingBox());
    }

    @Override
    public void setSize(int var0, boolean var1) {
        super.setSize(var0, var1);
        this.getAttribute(GenericAttributes.ARMOR).setBaseValue(var0 * 3);
    }

    @Override
    public float getLightLevelDependentMagicValue() {
        return 1.0f;
    }

    @Override
    protected ParticleParam getParticleType() {
        return Particles.FLAME;
    }

    @Override
    public boolean isOnFire() {
        return false;
    }

    @Override
    protected int getJumpDelay() {
        return super.getJumpDelay() * 4;
    }

    @Override
    protected void decreaseSquish() {
        this.targetSquish *= 0.9f;
    }

    @Override
    protected void jumpFromGround() {
        Vec3D var0 = this.getDeltaMovement();
        float var1 = (float)this.getSize() * 0.1f;
        this.setDeltaMovement(var0.x, this.getJumpPower() + var1, var0.z);
        this.hasImpulse = true;
    }

    @Override
    protected void jumpInLiquid(TagKey<FluidType> var0) {
        if (var0 == TagsFluid.LAVA) {
            Vec3D var1 = this.getDeltaMovement();
            this.setDeltaMovement(var1.x, 0.22f + (float)this.getSize() * 0.05f, var1.z);
            this.hasImpulse = true;
        } else {
            super.jumpInLiquid(var0);
        }
    }

    @Override
    protected boolean isDealsDamage() {
        return this.isEffectiveAi();
    }

    @Override
    protected float getAttackDamage() {
        return super.getAttackDamage() + 2.0f;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        if (this.isTiny()) {
            return SoundEffects.MAGMA_CUBE_HURT_SMALL;
        }
        return SoundEffects.MAGMA_CUBE_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        if (this.isTiny()) {
            return SoundEffects.MAGMA_CUBE_DEATH_SMALL;
        }
        return SoundEffects.MAGMA_CUBE_DEATH;
    }

    @Override
    protected SoundEffect getSquishSound() {
        if (this.isTiny()) {
            return SoundEffects.MAGMA_CUBE_SQUISH_SMALL;
        }
        return SoundEffects.MAGMA_CUBE_SQUISH;
    }

    @Override
    protected SoundEffect getJumpSound() {
        return SoundEffects.MAGMA_CUBE_JUMP;
    }
}

