/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.targeting;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;

public class PathfinderTargetCondition {
    public static final PathfinderTargetCondition DEFAULT = PathfinderTargetCondition.forCombat();
    private static final double MIN_VISIBILITY_DISTANCE_FOR_INVISIBLE_TARGET = 2.0;
    private final boolean isCombat;
    private double range = -1.0;
    private boolean checkLineOfSight = true;
    private boolean testInvisible = true;
    @Nullable
    private Predicate<EntityLiving> selector;

    private PathfinderTargetCondition(boolean var0) {
        this.isCombat = var0;
    }

    public static PathfinderTargetCondition forCombat() {
        return new PathfinderTargetCondition(true);
    }

    public static PathfinderTargetCondition forNonCombat() {
        return new PathfinderTargetCondition(false);
    }

    public PathfinderTargetCondition copy() {
        PathfinderTargetCondition var0 = this.isCombat ? PathfinderTargetCondition.forCombat() : PathfinderTargetCondition.forNonCombat();
        var0.range = this.range;
        var0.checkLineOfSight = this.checkLineOfSight;
        var0.testInvisible = this.testInvisible;
        var0.selector = this.selector;
        return var0;
    }

    public PathfinderTargetCondition range(double var0) {
        this.range = var0;
        return this;
    }

    public PathfinderTargetCondition ignoreLineOfSight() {
        this.checkLineOfSight = false;
        return this;
    }

    public PathfinderTargetCondition ignoreInvisibilityTesting() {
        this.testInvisible = false;
        return this;
    }

    public PathfinderTargetCondition selector(@Nullable Predicate<EntityLiving> var0) {
        this.selector = var0;
        return this;
    }

    public boolean test(@Nullable EntityLiving var0, EntityLiving var1) {
        if (var0 == var1) {
            return false;
        }
        if (!var1.canBeSeenByAnyone()) {
            return false;
        }
        if (this.selector != null && !this.selector.test(var1)) {
            return false;
        }
        if (var0 == null) {
            if (this.isCombat && (!var1.canBeSeenAsEnemy() || var1.level().getDifficulty() == EnumDifficulty.PEACEFUL)) {
                return false;
            }
        } else {
            EntityInsentient var2;
            if (this.isCombat && (!var0.canAttack(var1) || !var0.canAttackType(var1.getType()) || var0.isAlliedTo(var1))) {
                return false;
            }
            if (this.range > 0.0) {
                double var22 = this.testInvisible ? var1.getVisibilityPercent(var0) : 1.0;
                double var4 = Math.max(this.range * var22, 2.0);
                double var6 = var0.distanceToSqr(var1.getX(), var1.getY(), var1.getZ());
                if (var6 > var4 * var4) {
                    return false;
                }
            }
            if (this.checkLineOfSight && var0 instanceof EntityInsentient && !(var2 = (EntityInsentient)var0).getSensing().hasLineOfSight(var1)) {
                return false;
            }
        }
        return true;
    }
}

