/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.attributes;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import org.slf4j.Logger;

public class AttributeModifier {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final double amount;
    private final Operation operation;
    private final Supplier<String> nameGetter;
    private final UUID id;

    public AttributeModifier(String var0, double var1, Operation var3) {
        this(MathHelper.createInsecureUUID(RandomSource.createNewThreadLocalInstance()), () -> var0, var1, var3);
    }

    public AttributeModifier(UUID var0, String var1, double var2, Operation var4) {
        this(var0, () -> var1, var2, var4);
    }

    public AttributeModifier(UUID var0, Supplier<String> var1, double var2, Operation var4) {
        this.id = var0;
        this.nameGetter = var1;
        this.amount = var2;
        this.operation = var4;
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.nameGetter.get();
    }

    public Operation getOperation() {
        return this.operation;
    }

    public double getAmount() {
        return this.amount;
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 == null || this.getClass() != var0.getClass()) {
            return false;
        }
        AttributeModifier var1 = (AttributeModifier)var0;
        return Objects.equals(this.id, var1.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "AttributeModifier{amount=" + this.amount + ", operation=" + this.operation + ", name='" + this.nameGetter.get() + "', id=" + this.id + "}";
    }

    public NBTTagCompound save() {
        NBTTagCompound var0 = new NBTTagCompound();
        var0.putString("Name", this.getName());
        var0.putDouble("Amount", this.amount);
        var0.putInt("Operation", this.operation.toValue());
        var0.putUUID("UUID", this.id);
        return var0;
    }

    @Nullable
    public static AttributeModifier load(NBTTagCompound var0) {
        try {
            UUID var1 = var0.getUUID("UUID");
            Operation var2 = Operation.fromValue(var0.getInt("Operation"));
            return new AttributeModifier(var1, var0.getString("Name"), var0.getDouble("Amount"), var2);
        }
        catch (Exception var1) {
            LOGGER.warn("Unable to create attribute: {}", (Object)var1.getMessage());
            return null;
        }
    }

    public static final class Operation
    extends Enum<Operation>
    implements INamable {
        public static final /* enum */ Operation ADDITION = new Operation("addition", 0);
        public static final /* enum */ Operation MULTIPLY_BASE = new Operation("multiply_base", 1);
        public static final /* enum */ Operation MULTIPLY_TOTAL = new Operation("multiply_total", 2);
        private static final Operation[] OPERATIONS;
        public static final Codec<Operation> CODEC;
        private final String name;
        private final int value;
        private static final /* synthetic */ Operation[] h;

        public static Operation[] values() {
            return (Operation[])h.clone();
        }

        public static Operation valueOf(String var0) {
            return Enum.valueOf(Operation.class, var0);
        }

        private Operation(String var2, int var3) {
            this.name = var2;
            this.value = var3;
        }

        public int toValue() {
            return this.value;
        }

        public static Operation fromValue(int var0) {
            if (var0 < 0 || var0 >= OPERATIONS.length) {
                throw new IllegalArgumentException("No operation with value " + var0);
            }
            return OPERATIONS[var0];
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        private static /* synthetic */ Operation[] b() {
            return new Operation[]{ADDITION, MULTIPLY_BASE, MULTIPLY_TOTAL};
        }

        static {
            h = Operation.b();
            OPERATIONS = new Operation[]{ADDITION, MULTIPLY_BASE, MULTIPLY_TOTAL};
            CODEC = INamable.fromEnum(Operation::values);
        }
    }
}

